/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.rp.servlet.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.rp.AuthProtocolHandler;
import org.eclipse.higgins.rp.RelyingPartyEnabler;
import org.eclipse.higgins.rp.util.RPClaimTypeImpl;

public class RelyingPartyEnablerImpl
implements RelyingPartyEnabler {
    public static final String HANDLER_INIT_METHOD_NAME = "init";
    public static final String HANDLER_TOKEN_NAME_METHOD_NAME = "getSupportedTokenName";
    private List _registeredHandlers = null;
    private HashMap _tokenNames = null;
    public static final String propertiesSuffix = "Properties";
    protected static Log log = LogFactory.getLog((String)(class$org$eclipse$higgins$rp$servlet$impl$RelyingPartyEnablerImpl == null ? (class$org$eclipse$higgins$rp$servlet$impl$RelyingPartyEnablerImpl = RelyingPartyEnablerImpl.class$("org.eclipse.higgins.rp.servlet.impl.RelyingPartyEnablerImpl")) : class$org$eclipse$higgins$rp$servlet$impl$RelyingPartyEnablerImpl).getName());
    static /* synthetic */ Class class$org$eclipse$higgins$rp$servlet$impl$RelyingPartyEnablerImpl;
    static /* synthetic */ Class class$java$util$Map;

    private static List formClaimsList(List strLst) {
        ArrayList<RPClaimTypeImpl> lst = new ArrayList<RPClaimTypeImpl>();
        try {
            for (int i = 0; i < strLst.size(); ++i) {
                lst.add(new RPClaimTypeImpl((String)strLst.get(i)));
            }
        }
        catch (URISyntaxException exc) {
            exc.printStackTrace();
        }
        return lst;
    }

    private static Map getProtocolParamsMap(ServletContext ctxt, String name) {
        HashMap<String, String> _mp = new HashMap<String, String>();
        String propertiesFileName = ctxt.getInitParameter(name + propertiesSuffix);
        Properties properties = new Properties();
        InputStream propStream = ctxt.getResourceAsStream(propertiesFileName);
        if (null == propStream) {
            log.error((Object)("Cannot open properties file: " + ctxt.getRealPath(propertiesFileName)));
        } else {
            try {
                properties.load(propStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Enumeration<?> keys = properties.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String keyvalue = properties.getProperty(key);
                _mp.put(key, keyvalue);
            }
        }
        return _mp;
    }

    public RelyingPartyEnablerImpl(ServletContext sCtxt) {
        String param = sCtxt.getInitParameter("AuthProtocolHandlers");
        this._registeredHandlers = param == null ? null : Arrays.asList(param.split(" "));
        this._tokenNames = new HashMap();
        for (int i = 0; i < this._registeredHandlers.size(); ++i) {
            try {
                Class<?> hdlrClass = Class.forName((String)this._registeredHandlers.get(i));
                Method initMethod = hdlrClass.getMethod(HANDLER_INIT_METHOD_NAME, class$java$util$Map == null ? RelyingPartyEnablerImpl.class$("java.util.Map") : class$java$util$Map);
                Method tokenNameMethod = hdlrClass.getMethod(HANDLER_TOKEN_NAME_METHOD_NAME, null);
                Object hdlrObject = hdlrClass.newInstance();
                String tokenName = (String)tokenNameMethod.invoke(hdlrObject, (Object[])null);
                this._tokenNames.put((String)this._registeredHandlers.get(i), tokenName);
                Map mp = RelyingPartyEnablerImpl.getProtocolParamsMap(sCtxt, tokenName);
                if (mp.isEmpty()) continue;
                initMethod.invoke(hdlrObject, mp);
                continue;
            }
            catch (NoSuchMethodException ex1) {
                sCtxt.log("Method could not be found in subclass ");
                ex1.printStackTrace();
                throw new RuntimeException();
            }
            catch (InvocationTargetException ex2) {
                ex2.printStackTrace();
                throw new RuntimeException();
            }
            catch (ClassNotFoundException ex3) {
                sCtxt.log(" Class could not be found ");
                ex3.printStackTrace();
                throw new RuntimeException();
            }
            catch (IllegalAccessException ex4) {
                sCtxt.log("Illegal Access occured ");
                ex4.printStackTrace();
                throw new RuntimeException();
            }
            catch (InstantiationException ex5) {
                sCtxt.log("Error occured in instantiation ");
                ex5.printStackTrace();
                throw new RuntimeException();
            }
        }
    }

    public AuthProtocolHandler createNewSession(Map policy) {
        return this.findBestProtocolHandler(null, policy);
    }

    public AuthProtocolHandler createNewSession(String userAgent, Map policy) {
        return this.findBestProtocolHandler(userAgent, policy);
    }

    private AuthProtocolHandler findBestProtocolHandler(String userAgent, Map policy) {
        List tokenTypes = (List)policy.get("TokenTypes");
        ArrayList<AuthProtocolHandler> _matchingHandlers = new ArrayList<AuthProtocolHandler>();
        AuthProtocolHandler result = null;
        try {
            for (int i = 0; i < this._registeredHandlers.size(); ++i) {
                if (!tokenTypes.contains(this._tokenNames.get((String)this._registeredHandlers.get(i)))) continue;
                AuthProtocolHandler apHdlr = (AuthProtocolHandler)Class.forName((String)this._registeredHandlers.get(i)).newInstance();
                _matchingHandlers.add(apHdlr);
            }
        }
        catch (InstantiationException exc1) {
            exc1.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException exc2) {
            exc2.printStackTrace();
            return null;
        }
        catch (IllegalAccessException exc3) {
            exc3.printStackTrace();
            return null;
        }
        result = _matchingHandlers.size() == 1 ? (AuthProtocolHandler)_matchingHandlers.get(0) : null;
        List tmp = (List)policy.get("RequiredClaims");
        if (tmp != null) {
            result.setRequiredClaims(RelyingPartyEnablerImpl.formClaimsList(tmp));
        }
        if ((tmp = (List)policy.get("OptionalClaims")) != null) {
            result.setOptionalClaims(RelyingPartyEnablerImpl.formClaimsList(tmp));
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

