/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.rp.servlet.impl;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.higgins.rp.SessionContext;

public class SessionContextImpl
implements SessionContext,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String authenticationStore = "authenticationStore";
    private String _protectedResource = null;
    private HttpSession _httpsession = null;

    public SessionContextImpl(String origUri, HttpSession httpsession) {
        this._protectedResource = origUri;
        this._httpsession = httpsession;
    }

    public SessionContextImpl(HttpSession httpsession) {
        this._httpsession = httpsession;
    }

    public Object retrieveAttribute(String attribute) {
        Object result = this._httpsession.getAttribute(attribute);
        return result;
    }

    public Object retrieveAttribute(String authContext, String attribute) {
        Object result = this._httpsession.getAttribute(authContext + "/" + attribute);
        return result;
    }

    public int storeAttribute(String attribute, Object value) {
        this._httpsession.setAttribute(attribute, value);
        return 1;
    }

    public int storeAttribute(String authContext, String attribute, Object value) {
        this._httpsession.setAttribute(authContext + "/" + attribute, value);
        return 1;
    }

    public boolean attributeExists(String attribute) {
        Object result = this._httpsession.getAttribute(attribute);
        return null != result;
    }

    public boolean attributeExists(String authContext, String attribute) {
        Object result = this._httpsession.getAttribute(authContext + "/" + attribute);
        return null != result;
    }

    public void deleteAttribute(String attribute) {
        this._httpsession.removeAttribute(attribute);
    }

    public void deleteAttribute(String authContext, String attribute) {
        this._httpsession.removeAttribute(authContext + "/" + attribute);
    }

    public String getProtectedResource() {
        return this._protectedResource;
    }

    public String setProtectedResource(String rsrc) {
        this._protectedResource = rsrc;
        return rsrc;
    }

    public String getCurrentRequestUrl() {
        HttpServletRequest req = (HttpServletRequest)this._httpsession.getAttribute("request");
        String currentUrl = req.getRequestURL().toString();
        return currentUrl;
    }

    public String getRealPath(String path) {
        return this._httpsession.getServletContext().getRealPath(path);
    }
}

