/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.rp.servlet.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.rp.AuthProtocolHandler;
import org.eclipse.higgins.rp.DispatchCallback;
import org.eclipse.higgins.rp.ResultCallback;
import org.eclipse.higgins.rp.SessionContext;
import org.eclipse.higgins.rp.servlet.impl.DispatchCallbackHandler;
import org.eclipse.higgins.rp.servlet.impl.RelyingPartyEnablerImpl;
import org.eclipse.higgins.rp.servlet.impl.ResultCallbackHandler;
import org.eclipse.higgins.rp.servlet.impl.SessionContextImpl;

public class Invoker {
    private static RelyingPartyEnablerImpl rpImpl = null;
    protected static Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.rp.servlet.server.Invoker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    public static final Map extractRequestHeaders(HttpServletRequest request) {
        HashMap<String, String> hdrsMap = new HashMap<String, String>();
        Enumeration hdrnames = request.getHeaderNames();
        while (hdrnames.hasMoreElements()) {
            String key = (String)hdrnames.nextElement();
            String keyvalue = null;
            Enumeration hdrs = request.getHeaders(key);
            while (hdrs.hasMoreElements()) {
                String hdrVal = (String)hdrs.nextElement();
                String string = keyvalue = keyvalue == null ? hdrVal : String.valueOf(keyvalue) + "," + hdrVal;
            }
            hdrsMap.put(key, keyvalue);
        }
        return hdrsMap;
    }

    public static final void invoke(String authSession, HttpSession httpsession) {
        AuthProtocolHandler proto = null;
        ServletContext ctxt = httpsession.getServletContext();
        Map authCtxtParams = (Map)httpsession.getAttribute(authSession);
        HttpServletRequest req = (HttpServletRequest)authCtxtParams.get("request");
        String authState = (String)authCtxtParams.get("_authenticationState");
        log.debug((Object)("getting authentication state from http session: " + httpsession.getId()));
        if (rpImpl == null) {
            rpImpl = new RelyingPartyEnablerImpl(ctxt);
        }
        if (authState.equals("Processing")) {
            proto = (AuthProtocolHandler)authCtxtParams.get("_protocolHandler");
        } else {
            List<String> tokenTypes;
            authCtxtParams.put("_authenticationState", "Processing");
            String param = ctxt.getInitParameter("TokenTypes");
            List<String> list = tokenTypes = param == null ? null : Arrays.asList(param.split(" "));
            if (tokenTypes != null) {
                List<String> tmp;
                HashMap<String, List<String>> policy = new HashMap<String, List<String>>();
                policy.put("TokenTypes", tokenTypes);
                String userAgent = req.getHeader("User-Agent");
                param = ctxt.getInitParameter("RequiredClaims");
                List<String> list2 = tmp = param == null ? null : Arrays.asList(param.split(" "));
                if (tmp != null) {
                    policy.put("RequiredClaims", tmp);
                }
                List<String> list3 = tmp = (param = ctxt.getInitParameter("OptionalClaims")) == null ? null : Arrays.asList(param.split(" "));
                if (tmp != null) {
                    policy.put("OptionalClaims", tmp);
                }
                if ((proto = rpImpl.createNewSession(userAgent, policy)) != null) {
                    ResultCallbackHandler resCallback = new ResultCallbackHandler(authSession, httpsession);
                    DispatchCallbackHandler renderCallback = new DispatchCallbackHandler(authSession, httpsession);
                    String origUri = (String)authCtxtParams.get("protectedresource");
                    SessionContextImpl sessCtxt = new SessionContextImpl(origUri, httpsession);
                    proto.registerCallbacks((ResultCallback)resCallback, (DispatchCallback)renderCallback, (SessionContext)sessCtxt);
                    proto.setSessionId(authSession);
                    authCtxtParams.put("_protocolHandler", proto);
                } else {
                    HttpServletResponse resp = (HttpServletResponse)httpsession.getAttribute("response");
                    if (resp != null) {
                        try {
                            resp.sendError(500, " No authentication protocols configured ");
                        }
                        catch (IOException iOException) {
                            throw new RuntimeException(" Error while returning error to client ");
                        }
                    }
                }
            }
        }
        Map parameterMap = req.getParameterMap();
        Map hdrsMap = Invoker.extractRequestHeaders(req);
        if (proto != null) {
            proto.authenticate(hdrsMap, parameterMap);
        } else {
            log.debug((Object)"no protocol hdlr to call");
        }
    }

    public static void resetRPState(String authSession, HttpSession httpsession) {
        Map _mp = (Map)httpsession.getAttribute(authSession);
        _mp.put("_authenticationState", "Restarting");
        _mp.put("_protocolHandler", null);
    }
}

