/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Bruce Rich (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.rp.servlet.server;

public final class CxtConstants {
	
	// names of context parameters used in web.xml
	public static final String LOGOUT_JSP_NAME = "icardLogoutPage";
	public static final String PRIVACY_URL = "PrivacyUrl";
	public static final String REQUIRED_CLAIMS = "RequiredClaims";
	public static final String TOKEN_TYPES = "TokenTypes";
	public static final String AUTH_PROTOCOL_HANDLERS = "AuthProtocolHandlers";
	public static final String OPTIONAL_CLAIMS = "OptionalClaims";
	public static final String USE_QUERYSTRING_FOR_ALL = "UseQueryStringForAll";
	public static final String ROOT_CERT_URL = "RootCertUrl";
	
	// session attribute names
	public static final String AUTHENTICATION_STATE_URI = "_authenticationState";
	public static final String PROTOCOL_HANDLER_URI = "_protocolHandler";
	public static final String RET_TOKEN_TYPE = "ReturnedTokenType";
	public static final String RET_TOKEN_ID = "ReturnedTokenId";
	public static final String RET_CLAIMS = "ReturnedClaims";

	
	// authentication state
	public static final String INIT_STATE = "Initializing";
	public static final String PROCESS_STATE = "Processing";
	public static final String RESET_STATE = "Restarting";
    
	// general constants
    public static final String USER_AGENT_HEADER_NAME = "User-Agent";
    
    // constant parameter names 
    public static final String AUTH_CONTEXT_PARAM = "authcontext";
    // components of a particular auth context
    public static final String PROTECTED_RESOURCE = "protectedresource";

    public static final String REQUEST = "request";
    public static final String RESPONSE = "response";
}
