/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.rp.servlet.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.rp.ResultCallback;
import org.eclipse.higgins.rp.servlet.server.Invoker;
import org.eclipse.higgins.rp.tokens.RPClaim;
import org.eclipse.higgins.rp.tokens.RPSecurityToken;

public class ResultCallbackHandler
implements ResultCallback,
Serializable {
    static final long serialVersionUID = 1L;
    protected static Log log = LogFactory.getLog((String)(class$org$eclipse$higgins$rp$servlet$impl$ResultCallbackHandler == null ? (class$org$eclipse$higgins$rp$servlet$impl$ResultCallbackHandler = ResultCallbackHandler.class$("org.eclipse.higgins.rp.servlet.impl.ResultCallbackHandler")) : class$org$eclipse$higgins$rp$servlet$impl$ResultCallbackHandler).getName());
    private String _authSession = null;
    private HttpSession _httpsession = null;
    private Map _mp = null;
    static /* synthetic */ Class class$org$eclipse$higgins$rp$servlet$impl$ResultCallbackHandler;

    public ResultCallbackHandler(String authSession, HttpSession httpsession) {
        this._authSession = authSession;
        this._httpsession = httpsession;
        this._mp = (Map)this._httpsession.getAttribute(this._authSession);
    }

    public void handleFailure(int errCode) {
        Invoker.resetRPState(this._authSession, this._httpsession);
        String errorpage = (String)this._httpsession.getAttribute("ErrorPage");
        switch (errCode) {
            case -3: {
                log.error((Object)("authn internal error: forward to " + errorpage));
                break;
            }
            case -1: {
                log.error((Object)("authn failure - no token: forward to " + errorpage));
            }
        }
        HttpServletResponse response = (HttpServletResponse)this._mp.get("response");
        if (errorpage != null) {
            HttpServletRequest request = (HttpServletRequest)this._mp.get("request");
            RequestDispatcher rd = request.getRequestDispatcher(errorpage);
            try {
                rd.forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (ServletException exc1) {
                exc1.printStackTrace();
            }
            catch (IOException exc2) {
                exc2.printStackTrace();
            }
        } else {
            response.setStatus(403);
        }
    }

    public void handleFailure(int errCode, Throwable rootCause) {
        log.debug((Object)("remove state from http session: " + this._httpsession.getId()));
        Invoker.resetRPState(this._authSession, this._httpsession);
        String errorpage = (String)this._httpsession.getAttribute("ErrorPage");
        switch (errCode) {
            case -3: {
                log.error((Object)("authn internal error" + rootCause));
                break;
            }
            case -1: {
                log.error((Object)("authn failure - no token" + rootCause));
            }
        }
        HttpServletResponse response = (HttpServletResponse)this._httpsession.getAttribute("response");
        if (errorpage != null) {
            HttpServletRequest request = (HttpServletRequest)this._httpsession.getAttribute("request");
            RequestDispatcher rd = request.getRequestDispatcher(errorpage);
            try {
                rd.forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (ServletException exc1) {
                exc1.printStackTrace();
            }
            catch (IOException exc2) {
                exc2.printStackTrace();
            }
        } else {
            response.setStatus(403);
        }
    }

    public void handleSuccess(String protectedResource, RPSecurityToken authenticationResult) {
        String ret_token = authenticationResult.getTokenType().toString();
        this._httpsession.setAttribute("ReturnedTokenType", (Object)ret_token);
        this._httpsession.setAttribute("ReturnedTokenId", (Object)authenticationResult.getAsString());
        List claimList = authenticationResult.getClaims();
        if (null != claimList) {
            this._httpsession.setAttribute("ReturnedClaims", (Object)claimList);
            for (int i = 0; i < claimList.size(); ++i) {
                RPClaim claim = (RPClaim)claimList.get(i);
                String attribute = claim.getType().getDisplayName();
                ArrayList<String> valList = new ArrayList<String>();
                Iterator itrtr = claim.getValues();
                int j = 0;
                while (itrtr.hasNext()) {
                    valList.add((String)itrtr.next());
                    ++j;
                }
                String[] values = valList.toArray(new String[0]);
                this._httpsession.setAttribute(attribute, (Object)values);
            }
        }
        this._httpsession.removeAttribute(this._authSession);
        log.info((Object)("Redirecting to " + protectedResource));
        HttpServletResponse response = (HttpServletResponse)this._mp.get("response");
        try {
            response.sendRedirect(protectedResource);
        }
        catch (IOException exc2) {
            exc2.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

