/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.rp.servlet.server;

import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.higgins.rp.util.RPClaimTypeImpl;

public class AttributeHelper {
    public static String getSingleValuedAttribute(HttpServletRequest req, String attrname) {
        String[] strs;
        HttpSession session;
        String result = "";
        Object o = req.getAttribute(attrname);
        if (o == null && (session = req.getSession(false)) != null) {
            o = session.getAttribute(attrname);
        }
        if (o instanceof String) {
            result = (String)o;
        } else if (o instanceof String[] && (strs = (String[])o) != null && strs.length > 0) {
            result = strs[0];
        }
        return AttributeHelper.htmlEncode(result);
    }

    public static String[] getMultiValuedAttribute(HttpServletRequest req, String attrname) {
        HttpSession session;
        String[] result = new String[]{};
        Object o = req.getAttribute(attrname);
        if (o == null && (session = req.getSession(false)) != null) {
            o = session.getAttribute(attrname);
        }
        if (o instanceof String) {
            result = new String[]{(String)o};
        } else if (o instanceof String[]) {
            result = (String[])o;
        }
        return AttributeHelper.htmlEncode(result);
    }

    public static String[] getAllSimpleStringClaims(HttpServletRequest request) {
        ServletContext sCtxt = request.getSession().getServletContext();
        String claimsS = String.valueOf(sCtxt.getInitParameter("RequiredClaims")) + " " + sCtxt.getInitParameter("OptionalClaims");
        return AttributeHelper.getSuffixes(claimsS, " ");
    }

    public static String[] getSimpleStringClaims(HttpServletRequest request, boolean optional) {
        String claimsKeyS = optional ? "OptionalClaims" : "RequiredClaims";
        String claimsS = request.getSession().getServletContext().getInitParameter(claimsKeyS);
        return AttributeHelper.getSuffixes(claimsS, " ");
    }

    public static String[] getSuffixes(String urlS, String separatorS) {
        Vector<String> v = new Vector<String>();
        StringTokenizer st = new StringTokenizer(urlS, separatorS);
        while (st.hasMoreTokens()) {
            String thisS = st.nextToken();
            thisS = thisS.substring(thisS.lastIndexOf(47) + 1);
            v.add(thisS);
        }
        return v.toArray(new String[0]);
    }

    public static String getSimpleStringClaimsAsMarkup(HttpServletRequest request, String startMarker, String endMarker, boolean optional) {
        String claimsKeyS = optional ? "OptionalClaims" : "RequiredClaims";
        String claimsS = request.getSession().getServletContext().getInitParameter(claimsKeyS);
        StringBuffer sb = new StringBuffer(claimsS.length());
        StringTokenizer st = new StringTokenizer(claimsS, " ");
        while (st.hasMoreTokens()) {
            sb.append(startMarker).append(st.nextToken()).append(endMarker);
        }
        return sb.toString();
    }

    public static String[] getValues(String[][] list, int index) {
        int newLen = list[index].length;
        if (newLen > 0) {
            --newLen;
        }
        String[] tmpStr = new String[newLen];
        int j = 1;
        while (j < list[index].length) {
            tmpStr[j - 1] = list[index][j];
            ++j;
        }
        return tmpStr;
    }

    public static String getValueString(String[][] list, int index) {
        String tmpStr = "";
        int j = 1;
        while (j < list[index].length) {
            tmpStr = String.valueOf(tmpStr) + list[index][j];
            if (j < list[index].length - 1) {
                tmpStr = String.valueOf(tmpStr) + ", ";
            }
            ++j;
        }
        return tmpStr;
    }

    public static String htmlEncode(String pText) {
        StringTokenizer tokenizer = new StringTokenizer(pText, "&<>\"", true);
        int tokenCount = tokenizer.countTokens();
        if (tokenCount == 1) {
            return pText;
        }
        StringBuffer buffer = new StringBuffer(pText.length() + tokenCount * 6);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.length() == 1) {
                switch (token.charAt(0)) {
                    case '&': {
                        buffer.append("&amp;");
                        break;
                    }
                    case '<': {
                        buffer.append("&lt;");
                        break;
                    }
                    case '>': {
                        buffer.append("&gt;");
                        break;
                    }
                    case '\"': {
                        buffer.append("&quot;");
                        break;
                    }
                    default: {
                        buffer.append(token);
                        break;
                    }
                }
                continue;
            }
            buffer.append(token);
        }
        return buffer.toString();
    }

    static String[] htmlEncode(String[] strs) {
        String[] result = null;
        if (strs != null) {
            result = new String[strs.length];
            int i = 0;
            while (i < strs.length) {
                result[i] = AttributeHelper.htmlEncode(strs[i]);
                ++i;
            }
        }
        return result;
    }

    public static String writeXClaims(List claimList, boolean optional) throws IOException {
        StringBuffer sb = new StringBuffer();
        String claimsS = RPClaimTypeImpl.claimListToString((List)claimList);
        StringTokenizer st = new StringTokenizer(claimsS, " ");
        while (st.hasMoreTokens()) {
            sb.append("<ic:add claimType=\"" + st.nextToken() + "\" optional=\"" + Boolean.toString(optional) + "\" />\n");
        }
        return sb.toString();
    }
}

