/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Paula Austel, Suresh Chari (IBM Corporation) - initial implementation
 *******************************************************************************/ 
package org.eclipse.higgins.rp.servlet.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.rp.AuthProtocolHandler;
import org.eclipse.higgins.rp.Constants;
import org.eclipse.higgins.rp.servlet.impl.DispatchCallbackHandler;
import org.eclipse.higgins.rp.servlet.impl.RelyingPartyEnablerImpl;
import org.eclipse.higgins.rp.servlet.impl.ResultCallbackHandler;
import org.eclipse.higgins.rp.servlet.impl.SessionContextImpl;


public class Invoker {
	
	private static  RelyingPartyEnablerImpl rpImpl = null;
	
	protected static Log log =
        LogFactory.getLog(Invoker.class.getName());

	/**
	 * Utility function to extract request headers into a map which maps
	 * hdrName to a comma separated list of values for this header
	 * 
	 * @param request
	 * @return
	 */
	public static final Map extractRequestHeaders( HttpServletRequest request ){
		Map hdrsMap = new HashMap();
		Enumeration hdrnames = request.getHeaderNames();
		
		while (hdrnames.hasMoreElements())
		{
			String key = (String) hdrnames.nextElement();
			// Form the comma separated list of headers with this header name
			String keyvalue = null;
			Enumeration hdrs = request.getHeaders( key );
			while (hdrs.hasMoreElements()){
				String hdrVal = (String)hdrs.nextElement();
				keyvalue = (keyvalue==null)? hdrVal: ( keyvalue + "," +hdrVal);
			}
			hdrsMap.put( key, keyvalue );
		}
		
		return hdrsMap;
	}
	
	
	public static final void invoke(String authSession, HttpSession httpsession){

		AuthProtocolHandler proto = null;
		ServletContext ctxt = httpsession.getServletContext();
		Map authCtxtParams = (Map)httpsession.getAttribute( authSession );
		HttpServletRequest req = (HttpServletRequest)authCtxtParams.get( CxtConstants.REQUEST );

		String authState = (String)authCtxtParams.get(CxtConstants.AUTHENTICATION_STATE_URI);
		log.debug("getting authentication state from http session: " + httpsession.getId());
		
		if (rpImpl==null)
			rpImpl = new RelyingPartyEnablerImpl( ctxt );
		
		if (authState.equals(CxtConstants.PROCESS_STATE)) {
			proto = (AuthProtocolHandler)authCtxtParams.get(CxtConstants.PROTOCOL_HANDLER_URI);
		} else { // we are in INIT_STATE or RESET_STATE
		
			authCtxtParams.put(CxtConstants.AUTHENTICATION_STATE_URI, CxtConstants.PROCESS_STATE);
			// Form the policy for authentication
			String param = ctxt.getInitParameter(Constants.TOKENTYPES);
			List tokenTypes = (List)( param==null? null: Arrays.asList( param.split(" ")));

			if (tokenTypes!=null){
				HashMap policy = new HashMap();
				policy.put( Constants.TOKENTYPES, tokenTypes );
				String userAgent = req.getHeader(CxtConstants.USER_AGENT_HEADER_NAME);
				param = ctxt.getInitParameter(Constants.REQUIREDCLAIMS);
				List tmp = (List)( param==null? null: Arrays.asList( param.split(" ")));
				if (tmp!=null)
					policy.put( Constants.REQUIREDCLAIMS, tmp);

				param = ctxt.getInitParameter(Constants.OPTIONALCLAIMS);
				tmp = (List)( param==null? null: Arrays.asList( param.split(" ")));
				if (tmp!=null)
					policy.put( Constants.OPTIONALCLAIMS, tmp );
				
				proto = rpImpl.createNewSession(userAgent, policy);
					
				if (proto!=null){
					ResultCallbackHandler resCallback = new ResultCallbackHandler(authSession, httpsession);
				
				DispatchCallbackHandler renderCallback = new DispatchCallbackHandler(authSession, httpsession);
				String origUri = (String)authCtxtParams.get(CxtConstants.PROTECTED_RESOURCE);
				SessionContextImpl sessCtxt = new SessionContextImpl( origUri, httpsession);
				proto.registerCallbacks(resCallback, renderCallback, sessCtxt );
				proto.setSessionId(authSession);
				authCtxtParams.put(CxtConstants.PROTOCOL_HANDLER_URI, proto);
				} else{
					HttpServletResponse resp = (HttpServletResponse)httpsession.getAttribute( CxtConstants.RESPONSE );
					if ( resp !=null ){
						try{
							resp.sendError( HttpServletResponse.SC_INTERNAL_SERVER_ERROR, " No authentication protocols configured ");
						} catch( IOException ioe ){
							throw new RuntimeException(" Error while returning error to client ");
						}
					}
				}
				
			}
		}
			
		Map parameterMap = req.getParameterMap();
		Map hdrsMap = extractRequestHeaders( req );

		if (proto!=null)
			proto.authenticate(hdrsMap, parameterMap);
		else
			log.debug("no protocol hdlr to call");
			
	}
	
	public static void resetRPState(String authSession, HttpSession httpsession) {
		Map _mp  = (Map)httpsession.getAttribute( authSession );
		_mp.put(CxtConstants.AUTHENTICATION_STATE_URI, CxtConstants.RESET_STATE);
		_mp.put(CxtConstants.PROTOCOL_HANDLER_URI, null);
	}
}
