/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Peter Kimlach - initial API and implementation
 */
package org.eclipse.higgins.auto.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;

import javax.xml.transform.OutputKeys;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WSDLProcessor extends XMLDataReader1 {
	File file;
	
	public WSDLProcessor(File file) {
		// TODO Auto-generated constructor stub
		this.file = file;
		try {
			readXMLdata(file.getAbsolutePath());
		} catch (SAXException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public void process(){
		boolean changes = false;
		if(file != null && file.exists()){
			String targetNamespace = root.getAttribute("targetNamespace");
			Element wsdlTypes = (Element) root.getElementsByTagName("wsdl:types").item(0);
			NodeList list = wsdlTypes.getElementsByTagName("schema");
			for(int i = 0; i < list.getLength(); i++){
				Element first = (Element) list.item(0);
				if(targetNamespace.equalsIgnoreCase(first.getAttribute("targetNamespace"))){
					break;
				} else {
					Element current = (Element) list.item(i);
					if(targetNamespace.equalsIgnoreCase(current.getAttribute("targetNamespace"))){
						wsdlTypes.appendChild(wsdlTypes.replaceChild(current, first));
						changes = true;
						break;
					}
				}
			}
			if(changes){
				BufferedWriter writer = null;
				try {
					String xml = toString(getDoc());
					System.out.println(xml.length());
					writer = new BufferedWriter(new FileWriter(file));
					writer.write(xml);
					writer.flush();
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} finally {
					if(writer != null){
						try{
							writer.close();
						} catch (Exception e) {
							// TODO: handle exception
							e.printStackTrace();
						}
					}

				}
			}
		}
	}
	
	/**
     * Convert document to formatted XML string.
     */
    private String toString(Document doc) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException
    {
        // NOTE: There are different transformer implementations in the wild, which are configured differently
        //       regarding the indent size:
        //       Java 1.4: org.apache.xalan.transformer.TransformerIdentityImpl 
        //       Java 1.5: com.sun.org.apache.xalan.internal.xsltc.trax.TransformerImpl

        StringWriter writer = new StringWriter();
        Source source = new DOMSource(doc);
        Result result = new StreamResult(writer);
        TransformerFactory factory = TransformerFactory.newInstance();
        boolean indentFallback = false;
        try
        {
            // indent using TransformerImpl
            factory.setAttribute("indent-number", "4"); //$NON-NLS-1$ //$NON-NLS-2$
        }
        catch (IllegalArgumentException e)
        {
            // option not supported, set indent size below
            indentFallback = true;
        }
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty(OutputKeys.INDENT, "yes"); //$NON-NLS-1$
        if (indentFallback)
        {
            // indent using TransformerIdentityImpl
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4"); //$NON-NLS-1$ //$NON-NLS-2$
        }
        transformer.transform(source, result);
        return writer.toString();
    }
}
