/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Peter Kimlach - initial API and implementation
 */
package org.eclipse.higgins.auto.ant.tasks;

import java.io.File;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.higgins.auto.utils.WSDLProcessor;

public class WSDLStandardizer extends Task {

	private File file;

	public void execute() throws BuildException {
		if (file.exists()) {
			new WSDLProcessor(file).process();
		} else {
			System.out.println("WSDL file could not be found.");
		}
		// TODO Auto-generated method stub
		super.execute();
	}

	public File getFile() {
		return file;
	}

	public void setFile(File file) {
		this.file = file;
	}

}
