/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Peter Kimlach - initial API and implementation
 */

package org.eclipse.higgins.auto.utils;

import java.io.IOException;

import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class XMLDataReader1 {
	protected Document doc;
	
	protected Element root;

	public XMLDataReader1() {
	}

	protected void readXMLdata(String path) throws SAXException, IOException {
		DOMParser parser = new DOMParser();
		parser.parse(path);
		doc = parser.getDocument();
		root = doc.getDocumentElement();
	}

	protected String getDataFromElement(Element element, String tagName) {
		return element != null && element.getElementsByTagName(tagName).item(0) != null && element.getElementsByTagName(tagName).item(0).getFirstChild() != null ? element
				.getElementsByTagName(tagName).item(0).getFirstChild()
				.getNodeValue().trim()
				: "";

	}
	
	protected Document getDoc() {
		return doc;
	}
}
