/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.rpps.core.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.rmi.AccessException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.utils.Base64;
import org.eclipse.higgins.cache.CacheProviderFactory;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IComplexClaim;
import org.eclipse.higgins.icard.IPersonalInformationCard;
import org.eclipse.higgins.icard.IPolicy;
import org.eclipse.higgins.icard.ISimpleClaim;
import org.eclipse.higgins.icard.ISimpleClaimType;
import org.eclipse.higgins.icard.ITemplateContainer;
import org.eclipse.higgins.icard.ITemplateElement;
import org.eclipse.higgins.icard.ITemplateValue;
import org.eclipse.higgins.icard.IURICard;
import org.eclipse.higgins.icard.InvalidStateException;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.InvalidValueCountException;
import org.eclipse.higgins.icard.InvalidValueException;
import org.eclipse.higgins.icard.ReadOnlyObjectException;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.ICredentialDescriptor;
import org.eclipse.higgins.icard.auth.IPasswordCredential;
import org.eclipse.higgins.icard.auth.IPinCodeCredential;
import org.eclipse.higgins.icard.auth.ITSKerberosV5Credential;
import org.eclipse.higgins.icard.auth.ITSSelfIssuedCredential;
import org.eclipse.higgins.icard.auth.ITSUsernamePasswordCredential;
import org.eclipse.higgins.icard.auth.ITSX509V3Credential;
import org.eclipse.higgins.icard.auth.ITokenServiceCredential;
import org.eclipse.higgins.icard.auth.IUsernamePasswordCredential;
import org.eclipse.higgins.icard.common.auth.PinCodeCredential;
import org.eclipse.higgins.icard.common.auth.callback.PinCodeCallback;
import org.eclipse.higgins.icard.io.IFormatDescriptor;
import org.eclipse.higgins.icard.policy.ICardSpacePolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.PPIDCardSpacePolicy;
import org.eclipse.higgins.icard.registry.ICardRegistry;
import org.eclipse.higgins.icard.userprofile.CardCredential;
import org.eclipse.higgins.icard.userprofile.CardInformation;
import org.eclipse.higgins.icard.userprofile.CardUsage;
import org.eclipse.higgins.icard.userprofile.Category;
import org.eclipse.higgins.icard.userprofile.ICardUsageManager;
import org.eclipse.higgins.icard.userprofile.UserProfile;
import org.eclipse.higgins.icard.userprofile.UserProfileAuthenticationException;
import org.eclipse.higgins.icard.userprofile.UserProfileException;
import org.eclipse.higgins.iss.CredentialContainer;
import org.eclipse.higgins.iss.ICardSelectorService;
import org.eclipse.higgins.iss.IICardSelector;
import org.eclipse.higgins.iss.IIdentityToken;
import org.eclipse.higgins.iss.SelectionANDofORs;
import org.eclipse.higgins.iss.SelectionANDofORsElm;
import org.eclipse.higgins.iss.UCTelm;
import org.eclipse.higgins.iss.UserChoiceTree;
import org.eclipse.higgins.iss.UserChoiceTree_ANDofORs;
import org.eclipse.higgins.iss.cardspace.IdentityToken;
import org.eclipse.higgins.iss.cardspace.util.UserProfileTokenHelper;
import org.eclipse.higgins.rpps.core.IRppsService;
import org.eclipse.higgins.rpps.core.RppsException;
import org.eclipse.higgins.rpps.core.impl.CardInformationRPPS;
import org.eclipse.higgins.rpps.core.impl.CategoryComparator;
import org.eclipse.higgins.rpps.core.impl.ConvertHelper;
import org.eclipse.higgins.rpps.core.impl.FeedProperties;
import org.eclipse.higgins.rpps.core.impl.FileService;
import org.eclipse.higgins.rpps.core.impl.RppsHelper;
import org.eclipse.higgins.rpps.core.impl.RssService;
import org.eclipse.higgins.rpps.core.impl.UserInterfaceResponse;
import org.eclipse.higgins.rpps.core.rss.RssServlet;
import org.eclipse.higgins.rpps.core.tobj.CardInformationTO;
import org.eclipse.higgins.rpps.core.tobj.CardUsageTO;
import org.eclipse.higgins.rpps.core.tobj.CategoryTO;
import org.eclipse.higgins.rpps.core.tobj.ExtraTokenResponseTO;
import org.eclipse.higgins.rpps.core.tobj.FormatDescriptorTO;
import org.eclipse.higgins.rpps.core.tobj.ICardTO;
import org.eclipse.higgins.rpps.core.tobj.ICardTemplateTO;
import org.eclipse.higgins.rpps.core.tobj.ICardsAndCategoryTO;
import org.eclipse.higgins.rpps.core.tobj.PropertyTO;
import org.eclipse.higgins.rpps.core.tobj.ResponseMessage;
import org.eclipse.higgins.rpps.core.tobj.TokenResponseTO;
import org.eclipse.higgins.rpps.core.tobj.UIResponseAndTO;
import org.eclipse.higgins.rpps.core.tobj.UIResponseCardTO;
import org.eclipse.higgins.rpps.core.tobj.UIResponseClauseTO;
import org.eclipse.higgins.rpps.core.tobj.UIResponseOrTO;
import org.eclipse.higgins.rpps.core.tobj.UIResponseRPTO;
import org.eclipse.higgins.rpps.core.tobj.UIResponseTO;
import org.eclipse.higgins.rpps.core.tobj.UIResponseUsableCardsTO;
import org.eclipse.higgins.rpps.core.tobj.UITokenServiceCredentialTO;
import org.eclipse.higgins.rpps.core.tobj.UserProfileTO;
import org.eclipse.higgins.sts.api.ISTSResponse;

public class RppsService
implements IRppsService {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$rpps$core$impl$RppsService == null ? (class$org$eclipse$higgins$rpps$core$impl$RppsService = RppsService.class$("org.eclipse.higgins.rpps.core.impl.RppsService")) : class$org$eclipse$higgins$rpps$core$impl$RppsService));
    UserProfile userProfile = null;
    private CallbackHandler handler = null;
    protected static CertStore certStoreTrust;
    static /* synthetic */ Class class$org$eclipse$higgins$rpps$core$impl$RppsService;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$IPersonalInformationCard;
    static /* synthetic */ Class class$org$eclipse$higgins$rpps$core$impl$RppsService$DummyTrustManagerFactory;

    public RppsService() {
    }

    public RppsService(String userId, String password) throws AccessException {
        this.authenticate(userId, password);
    }

    public static IRppsService getInstance() {
        return new RppsService();
    }

    public static IRppsService getInstance(String userId, String password) throws AccessException {
        return new RppsService(userId, password);
    }

    public CallbackHandler getHandler() {
        return this.handler;
    }

    public void setHandler(CallbackHandler handler) {
        this.handler = handler;
    }

    public void authenticate(String userId, String password) throws AccessException {
        try {
            this.userProfile = ICardRegistry.getInstance().getUserProfileService().getUserProfile(RppsHelper.getCallbackHandler(userId, password));
            if (this.userProfile == null) {
                throw new AccessException("Don't found user profile for userId = <" + userId + ">");
            }
            this.handler = RppsHelper.getCallbackHandler(this.userProfile.getUserIdentifier());
        }
        catch (UserProfileAuthenticationException e) {
            throw new AccessException(e.getMessage(), (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new AccessException(e.getMessage(), e);
        }
    }

    private ICard getURIICard(String cref, String cuid) {
        Iterator pit = ICardRegistry.getInstance().getICardProviders();
        while (pit.hasNext()) {
            ICardProvider provider = (ICardProvider)pit.next();
            try {
                Iterator icards = provider.getICards(this.getHandler());
                while (icards.hasNext()) {
                    ICard icard = (ICard)icards.next();
                    if (!(icard instanceof IURICard) || !((IURICard)icard).getContextRef().equals(cref) || !((IURICard)icard).getCuid().equals(cuid)) continue;
                    return icard;
                }
            }
            catch (CardException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String acquireICard(String subscribeURL) throws MalformedURLException {
        FeedProperties feedProperties = null;
        URL subscribeURL_ = new URL(subscribeURL);
        String rssDir = RssServlet.getRssDir();
        CallbackHandler handler = this.getHandler();
        try {
            NameCallback name = new NameCallback("name");
            handler.handle(new Callback[]{name});
            feedProperties = RssService.getInstance().loadFeedProperties(subscribeURL_, rssDir + "/" + name.getName());
        }
        catch (IOException e) {
            throw new RppsException(e);
        }
        catch (UnsupportedCallbackException e) {
            throw new RppsException(e);
        }
        return feedProperties != null ? this.createICard(feedProperties.getId(), feedProperties.getProperties()).getCUID().toString() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void connectionNotify(String host, String username, boolean success) throws MalformedURLException {
        IClaim lastConnectionClaim;
        IClaim lastConnectionAttemptClaim;
        URL host_ = new URL(host);
        ICard icard = this.getURIICard(host_.toString(), username);
        if (icard == null) throw new RppsException("There is not found an i-card for host: " + host_ + ", username: " + username);
        try {
            lastConnectionAttemptClaim = icard.getClaimByLocalName("lastConnectionAttempt");
        }
        catch (CardException e) {
            throw new RppsException(e);
        }
        ArrayList<Date> values = new ArrayList<Date>();
        values.add(new Date());
        if (lastConnectionAttemptClaim == null) throw new RppsException("There is not found a claim: lastConnectionAttempt");
        try {
            ((ISimpleClaim)lastConnectionAttemptClaim).setValues(values);
        }
        catch (InvalidValueException e) {
            throw new RppsException(e.getMessage());
        }
        catch (InvalidStateException e) {
            throw new RppsException(e.getMessage());
        }
        catch (ReadOnlyObjectException e) {
            throw new RppsException(e.getMessage());
        }
        catch (InvalidValueCountException e) {
            throw new RppsException(e.getMessage());
        }
        try {
            lastConnectionClaim = icard.getClaimByLocalName("lastConnection");
        }
        catch (CardException e) {
            throw new RppsException(e);
        }
        if (lastConnectionClaim == null) throw new RppsException("There is not found a claim: lastConnection");
        if (!success) return;
        try {
            ((ISimpleClaim)lastConnectionClaim).setValues(values);
            return;
        }
        catch (InvalidValueException e) {
            throw new RppsException(e.getMessage());
        }
        catch (InvalidStateException e) {
            throw new RppsException(e.getMessage());
        }
        catch (ReadOnlyObjectException e) {
            throw new RppsException(e.getMessage());
        }
        catch (InvalidValueCountException e) {
            throw new RppsException(e.getMessage());
        }
    }

    public boolean connectionVerify(String host, String username) throws MalformedURLException {
        IClaim lastConnectionClaim;
        URL host_ = new URL(host);
        ICard icard = this.getURIICard(host_.toString(), username);
        String lastConnectionAttempt = null;
        String lastConnection = null;
        if (icard != null) {
            IClaim lastConnectionAttemptClaim;
            try {
                lastConnectionAttemptClaim = icard.getClaimByLocalName("lastConnectionAttempt");
            }
            catch (CardException e) {
                throw new RppsException(e);
            }
            if (lastConnectionAttemptClaim == null) {
                throw new RppsException("There is not found a claim: lastConnectionAttempt");
            }
            lastConnectionAttempt = ((ISimpleClaim)lastConnectionAttemptClaim).getValues().get(0).toString();
            try {
                lastConnectionClaim = icard.getClaimByLocalName("lastConnection");
            }
            catch (CardException e) {
                throw new RppsException(e);
            }
            if (lastConnectionClaim == null) {
                throw new RppsException("There is not found a claim: lastConnection");
            }
        } else {
            throw new RppsException("There is not found an i-card for host: " + host_ + ", username: " + username);
        }
        lastConnection = ((ISimpleClaim)lastConnectionClaim).getValues().get(0).toString();
        return lastConnectionAttempt != null && lastConnection != null && lastConnectionAttempt.equals(lastConnection);
    }

    public String getFormFillingScript(URL page, String username, String form) {
        return null;
    }

    public String getHtmlScrapingScript(String page) throws MalformedURLException, RppsException {
        String script = "";
        URL page_ = new URL(page);
        try {
            String line;
            BufferedReader br = FileService.getInstance().getBufferedReader(FileService.SCRIPTS_DIR + FileService.convertURLToPath(page_) + FileService.SCRIPTS_EXT);
            while ((line = br.readLine()) != null) {
                script = script + line;
            }
        }
        catch (IOException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        return script;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setHtmlScrapingScript(String page, String script) throws MalformedURLException, RppsException {
        BufferedWriter bw = null;
        URL page_ = new URL(page);
        try {
            try {
                bw = FileService.getInstance().getBufferedWriter(FileService.SCRIPTS_DIR + FileService.convertURLToPath(page_) + FileService.SCRIPTS_EXT);
                bw.write(script);
            }
            catch (IOException e) {
                this.log.error((Object)e, (Throwable)e);
                throw new RppsException(e);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            try {
                if (bw == null) throw throwable;
                bw.close();
                throw throwable;
            }
            catch (IOException e) {
                this.log.error((Object)e, (Throwable)e);
                throw new RppsException(e);
            }
        }
        try {}
        catch (IOException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        if (bw == null) return;
        bw.close();
    }

    public ICardTO createICard(String id, String[] properties) throws RppsException {
        ICard card = null;
        try {
            card = this.createICard(URI.create(id), RppsHelper.loadProperties(properties));
            return this.convertICard_To_ICardTO(card, false);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected ICard createICard(URI id, Properties properties) throws RppsException {
        Iterator it = ICardRegistry.getInstance().getICardProviders();
        while (it.hasNext()) {
            ICardProvider provider = (ICardProvider)it.next();
            if (!provider.canCreateCard(this.getHandler(), id.toString(), properties)) continue;
            try {
                return provider.createCard(this.getHandler(), id.toString(), properties);
            }
            catch (Exception ex) {
                throw new RppsException(ex);
            }
        }
        throw new RppsException("There is not a registered provider for this type of i-card.");
    }

    public ICardTO createICard(ICardTemplateTO template) throws RppsException {
        ICard card = null;
        try {
            ICardTemplate[] templates = this.getICardCreationTemplateByProvider(template.getProviderID());
            card = this.createICard(RppsHelper.fillICardTemplate_from_ICardTemplateTO(templates, template));
            ICardTO iCardTO = this.convertICard_To_ICardTO(card, false);
            return iCardTO;
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected ICard createICard(ICardTemplate template) throws RppsException {
        try {
            if (template != null) {
                String extID = template.getProviderID();
                ICardProvider provider = ICardRegistry.getInstance().getICardProvider(extID);
                if (provider != null && provider.getCardCreationTemplates(this.getHandler()) != null) {
                    try {
                        return provider.createCard(this.getHandler(), template);
                    }
                    catch (Exception ex) {
                        throw new RppsException(ex);
                    }
                }
                throw new RppsException("There is not a registered provider for this id.");
            }
            throw new RppsException("Paramenter <<template>> is null");
        }
        catch (RppsException e) {
            this.log.error((Object)e, (Throwable)e);
            throw e;
        }
    }

    public ICardTO createDuplicateICard(String cardName, String cuid, String pinCode) throws RppsException {
        ICard card = null;
        try {
            card = this.createDuplicateICard(cardName, new CUID(cuid), pinCode);
            ICardTO iCardTO = this.convertICard_To_ICardTO(card, false);
            return iCardTO;
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected ICard createDuplicateICard(String cardName, CUID cuid, String pinCode) throws RppsException, UserProfileException {
        try {
            ICard card = ICardRegistry.getInstance().getICardByCUID(this.getHandler(), cuid);
            if (!(card instanceof IPersonalInformationCard)) {
                throw new RppsException("You can not create dublicate this card.");
            }
            if (card.getRequiredCredentials() != null && card.getRequiredCredentials().length > 0) {
                PinCodeCredential credential = null;
                if (pinCode != null && pinCode.trim().length() > 0) {
                    credential = new PinCodeCredential();
                    try {
                        credential.setPinCode(pinCode.getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        credential.setPinCode(pinCode.getBytes());
                    }
                } else {
                    CardInformationRPPS cardInformation = this.getCardInformationByCuid(cuid);
                    if (cardInformation != null && cardInformation.getCardCredential() != null) {
                        credential = ConvertHelper.convertCardCredential_to_ICredential(card, cardInformation.getCardCredential());
                    } else {
                        throw new RppsException("Rpps can not retrieve card. You have to send pin code.");
                    }
                }
                card = card.getProvider().getICardByCUID(this.getHandler(), cuid, (ICredential)credential);
            }
            ICardTemplate[] cardTemplates = card.getProvider().getCardCreationTemplates(this.getHandler());
            ICardTemplate cardTemplate = null;
            for (int i = 0; i < cardTemplates.length; ++i) {
                if (!cardTemplates[i].getCardType().isInstance(card)) continue;
                cardTemplate = cardTemplates[i];
                if (cardTemplate.getTemplateElementByID("cardName") != null) {
                    ((ITemplateValue)cardTemplate.getTemplateElementByID("cardName")).setValue(cardName);
                }
                if (cardTemplate.getTemplateElementByID("cardPicture") != null && card.getImage() != null) {
                    ((ITemplateValue)cardTemplate.getTemplateElementByID("cardPicture")).setValue(Base64.encode((byte[])card.getImage()));
                }
                if (cardTemplate.getTemplateElementByID("claimList") == null) break;
                Iterator iter = ((ITemplateContainer)cardTemplate.getTemplateElementByID("claimList")).getTemplateElements();
                while (iter.hasNext()) {
                    ITemplateElement element = (ITemplateElement)iter.next();
                    IClaim claim = card.getClaim(element.getID());
                    if (claim == null || ((ISimpleClaim)claim).getValues().size() <= 0) continue;
                    ((ITemplateValue)element).setValue((String)((ISimpleClaim)claim).getValues().get(0));
                }
                break;
            }
            if (cardTemplate != null) {
                return this.createICard(cardTemplate);
            }
        }
        catch (CardException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createICardFromHBX(String cardname) throws RppsException {
        String ret = null;
        ICardTemplate template = this.getPersonalICardCreationTemplate(this.getHandler());
        template = RppsHelper.fillPersonalCardTemplate(template, cardname, "", "", "", "", "", "", "", "", "", "", "", "", "", "");
        ret = this.createICard(template).getCUID().toString();
        return ret;
    }

    public ICardTO getICardByCUID(String cuid) throws RppsException {
        try {
            ICard card = this.getICardByCUID(new CUID(cuid));
            ICardTO iCardTO = this.convertICard_To_ICardTO(card, false);
            return iCardTO;
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected ICard getICardByCUID(CUID cuid) throws RppsException {
        try {
            return ICardRegistry.getInstance().getICardByCUID(this.getHandler(), cuid);
        }
        catch (CardException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public ICardTO getICardByCUIDAndTokenServiceCredential(String cuid, UITokenServiceCredentialTO tokenCredential) throws RppsException {
        try {
            ICard card = this.getICardByCUID(new CUID(cuid));
            if (card == null) {
                throw new RppsException("Can't find card with CUID " + cuid);
            }
            CardInformationRPPS cardInformation = this.getCardInformationByCuid(new CUID(cuid));
            ICredential credential = null;
            if (cardInformation.getCardCredential() != null) {
                credential = ConvertHelper.convertCardCredential_to_ICredential(card, cardInformation.getCardCredential());
            } else if (tokenCredential != null) {
                credential = ConvertHelper.convertUITokenServiceCredentialTO_to_ICredentials(card, tokenCredential);
            }
            if (credential != null) {
                card = card.getProvider().getICardByCUID(this.getHandler(), card.getCUID(), credential);
            }
            ICardTO iCardTO = this.convertICard_To_ICardTO(card, true);
            return iCardTO;
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public UIResponseCardTO getICardClaims(String cuid, String policy, String typeofCredential, String[] credentialKey, String[] credentialValue) throws RppsException {
        block8: {
            ICard card;
            RppsService.AllowSelfSignedSSL();
            Hashtable<String, String> table = new Hashtable<String, String>();
            for (int i = 0; i < credentialKey.length; ++i) {
                if (credentialKey[i] == null || credentialValue[i] == null) continue;
                table.put(credentialKey[i], credentialValue[i]);
            }
            URI url = null;
            if (table.get("url") != null) {
                String urlStr = (String)table.get("url");
                url = ConvertHelper.convertString_to_URI(urlStr);
            }
            if ((card = this.getICardByCUID(new CUID(cuid))) == null) break block8;
            CardInformationRPPS cardCredentialInfo = this.getCardInformationByCuid(new CUID(cuid));
            ICredential credential = cardCredentialInfo != null && cardCredentialInfo.getCardCredential() != null ? ConvertHelper.convertCardCredential_to_ICredential(card, cardCredentialInfo.getCardCredential()) : ConvertHelper.convertHashtable_to_Credential(card, typeofCredential, table);
            if (credential != null) {
                card = card.getProvider().getICardByCUID(this.getHandler(), card.getCUID(), credential);
            }
            ICardSpacePolicy policy_ = (ICardSpacePolicy)ICardSelectorService.getInstance().parsePolicy(policy);
            UIResponseCardTO uIResponseCardTO = this.convertICard_To_UIResponseCardTO(card, url, policy_, cardCredentialInfo);
            return uIResponseCardTO;
        }
        try {
            throw new RppsException("Didn't find card with cuid=" + cuid);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICardTO[] getICardsByUser() {
        ICardTO[] icards = new ICardTO[]{};
        try {
            List cards = null;
            cards = this.getICardsByUser(this.getHandler());
            if (cards != null) {
                icards = new ICardTO[cards.size()];
                for (int i = 0; i < cards.size(); ++i) {
                    try {
                        icards[i] = this.convertICard_To_ICardTO((ICard)cards.get(i), false);
                        continue;
                    }
                    catch (Exception e) {
                        this.log.error((Object)e, (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
        }
        return icards;
    }

    protected List getICardsByUser(CallbackHandler handler) {
        ArrayList cards = new ArrayList();
        Iterator pit = ICardRegistry.getInstance().getICardProviders();
        while (pit.hasNext()) {
            ICardProvider provider = (ICardProvider)pit.next();
            try {
                Iterator icards = provider.getICards(handler);
                while (icards.hasNext()) {
                    cards.add(icards.next());
                }
            }
            catch (Exception e) {
                this.log.error((Object)e, (Throwable)e);
            }
        }
        return cards;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICardsAndCategoryTO getICardsAndCategoriesByUser() throws RppsException {
        ICardsAndCategoryTO cardsAndCategoryTO = new ICardsAndCategoryTO();
        try {
            cardsAndCategoryTO.setICardList(this.getICardsByUser());
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
        }
        try {
            cardsAndCategoryTO.setCategoryList(this.getCategory());
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
        }
        ICardsAndCategoryTO iCardsAndCategoryTO = cardsAndCategoryTO;
        return iCardsAndCategoryTO;
    }

    public ICardTO updateICard(ICardTO icardTO) throws RppsException {
        ICard card = null;
        try {
            card = this.getICardByCUID(new CUID(icardTO.getCuid()));
            CardInformationRPPS cardInformation = this.getCardInformationByCuid(card.getCUID());
            ICredential credential = null;
            if (cardInformation.getCardCredential() != null) {
                credential = ConvertHelper.convertCardCredential_to_ICredential(card, cardInformation.getCardCredential());
            } else if (icardTO.getTokenServiceCredentials() != null && icardTO.getTokenServiceCredentials().length != 0) {
                credential = ConvertHelper.convertUITokenServiceCredentialTO_to_ICredentials(card, icardTO.getTokenServiceCredentials()[0]);
            }
            if (credential != null) {
                card = card.getProvider().getICardByCUID(this.getHandler(), card.getCUID(), credential);
            }
            card.beginUpdates();
            if (!RppsHelper.equalsObject(card.getName(), icardTO.getName())) {
                card.setName(icardTO.getName());
            }
            try {
                if (!RppsHelper.equalsObject(card.getIssuerName(), icardTO.getIssuerName())) {
                    card.setIssuerName(icardTO.getIssuerName());
                }
            }
            catch (Exception exc) {
                this.log.error((Object)exc, (Throwable)exc);
            }
            if (!RppsHelper.equalsObject(card.getImageType(), icardTO.getImageType()) || !RppsHelper.equalsObject(card.getImage(), icardTO.getImage())) {
                card.setImage(icardTO.getImage(), icardTO.getImageType());
            }
            if (card instanceof IPersonalInformationCard) {
                try {
                    if (!RppsHelper.equalsObject(card.getTimeExpires(), icardTO.getExpiredTime())) {
                        card.setTimeExpires(icardTO.getExpiredTime());
                    }
                }
                catch (Exception exc) {
                    this.log.error((Object)exc, (Throwable)exc);
                }
                if (icardTO.getProperties() != null) {
                    int size = icardTO.getProperties().length;
                    for (int index = 0; index < size; ++index) {
                        PropertyTO propTO = icardTO.getProperties()[index];
                        IClaim claim = card.getClaim(propTO.getClaimType());
                        if (claim == null) {
                            claim = card.createClaim(propTO.getClaimType());
                        }
                        if (propTO.getComplexValue() == null) {
                            this.setSimpleValues(claim, propTO);
                            continue;
                        }
                        this.setComplexValues(claim, propTO);
                    }
                }
            }
            card.applyUpdates();
            card = this.getICardByCUID(new CUID(icardTO.getCuid()));
            ICardTO iCardTO = this.convertICard_To_ICardTO(card, false);
            return iCardTO;
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            try {
                if (card != null && card.isEditMode()) {
                    card.cancelUpdates();
                }
            }
            catch (Throwable tr) {
                // empty catch block
            }
            throw new RppsException(e);
        }
    }

    private void setSimpleValues(IClaim claim, PropertyTO value) throws Exception {
        if (claim != null && claim instanceof ISimpleClaim && ((ISimpleClaimType)claim.getType()).getDataType().getName().equals(value.getValueType())) {
            ArrayList<String> newValues = new ArrayList<String>();
            for (int index = 0; index < value.getValue().length; ++index) {
                newValues.add(value.getValue()[index]);
            }
            ((ISimpleClaim)claim).setValues(newValues);
        }
    }

    private void setComplexValues(IClaim claim, PropertyTO value) throws Exception {
        if (claim != null && claim instanceof IComplexClaim) {
            int size = value.getComplexValue().length;
            for (int index = 0; index < size; ++index) {
                PropertyTO propTO = value.getComplexValue()[index];
                IClaim claimValue = ((IComplexClaim)claim).getClaim(propTO.getClaimType());
                if (claimValue == null) {
                    claimValue = ((IComplexClaim)claim).createClaim(propTO.getClaimType());
                }
                if (propTO.getValueType() != null) {
                    this.setSimpleValues(claimValue, propTO);
                    continue;
                }
                this.setComplexValues(claimValue, propTO);
            }
        }
    }

    public ICardTO[] importICards(byte[] crd) throws RppsException {
        try {
            List cards = null;
            cards = this.importICards(new ByteArrayInputStream(crd), null, null);
            ICardTO[] icards = new ICardTO[]{};
            if (cards != null) {
                icards = new ICardTO[cards.size()];
                for (int i = 0; i < cards.size(); ++i) {
                    icards[i] = this.convertICard_To_ICardTO((ICard)cards.get(i), false);
                }
            }
            return icards;
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public ICardTO[] importICards(byte[] crd, String formatID, UITokenServiceCredentialTO credential) throws RppsException {
        try {
            List cards = null;
            cards = this.importICards(new ByteArrayInputStream(crd), formatID, ConvertHelper.convertUITokenServiceCredentialTO_to_ICredentials(credential));
            ICardTO[] icards = new ICardTO[]{};
            if (cards != null) {
                icards = new ICardTO[cards.size()];
                for (int i = 0; i < cards.size(); ++i) {
                    icards[i] = this.convertICard_To_ICardTO((ICard)cards.get(i), false);
                }
            }
            return icards;
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected List importICards(InputStream in, String formatID, ICredential credential) throws RppsException {
        try {
            ArrayList result = new ArrayList();
            Iterator iter = ICardRegistry.getInstance().importICards(this.getHandler(), in, formatID, credential);
            while (iter.hasNext()) {
                result.add(iter.next());
            }
            return result;
        }
        catch (CardException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public FormatDescriptorTO checkImportStream(byte[] crd) throws RppsException {
        try {
            IFormatDescriptor formatDescriptor = ICardRegistry.getInstance().checkInput((InputStream)new ByteArrayInputStream(crd));
            return this.convertIFormatDescriptor_to_FormatDescriptorTO(formatDescriptor);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public byte[] exportICards(String formatID, String[] cards, UITokenServiceCredentialTO credential) throws RppsException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (cards != null && cards.length > 0) {
                CUID[] cuids = new CUID[cards.length];
                for (int i = 0; i < cards.length; ++i) {
                    cuids[i] = new CUID(cards[i]);
                }
                ICredential credential_ = ConvertHelper.convertUITokenServiceCredentialTO_to_ICredentials(credential);
                ICardRegistry.getInstance().exportICards(this.getHandler(), (OutputStream)out, formatID, cuids, credential_);
                return out.toByteArray();
            }
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICardTO[] getICardsByFormat(String formatID) throws RppsException {
        ICardTO[] icards = new ICardTO[]{};
        try {
            ArrayList cards = new ArrayList();
            try {
                Iterator iter = ICardRegistry.getInstance().getICardsByFormat(this.getHandler(), formatID);
                while (iter.hasNext()) {
                    try {
                        cards.add(iter.next());
                    }
                    catch (Exception e) {
                        this.log.error((Object)e, (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)e, (Throwable)e);
            }
            if (cards != null) {
                icards = new ICardTO[cards.size()];
                for (int i = 0; i < cards.size(); ++i) {
                    try {
                        icards[i] = this.convertICard_To_ICardTO((ICard)cards.get(i), false);
                        continue;
                    }
                    catch (Exception e) {
                        this.log.error((Object)e, (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
        }
        return icards;
    }

    public FormatDescriptorTO[] getOutputFormats() throws RppsException {
        try {
            IFormatDescriptor[] formatDescriptor = ICardRegistry.getInstance().getOutputFormats();
            if (formatDescriptor != null && formatDescriptor.length > 0) {
                FormatDescriptorTO[] formatDescriptorTO = new FormatDescriptorTO[formatDescriptor.length];
                for (int i = 0; i < formatDescriptor.length; ++i) {
                    formatDescriptorTO[i] = this.convertIFormatDescriptor_to_FormatDescriptorTO(formatDescriptor[i]);
                }
                return formatDescriptorTO;
            }
            return null;
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteICard(String cuid) throws RppsException {
        try {
            CallbackHandler handler = this.getHandler();
            CUID cuid_ = new CUID(cuid);
            ICardRegistry.getInstance().getUserProfileService().clearCardCredential(this.getHandler(), cuid_);
            ICardUsageManager cardUsageManager = null;
            try {
                cardUsageManager = ICardRegistry.getInstance().getUserProfileService().getCardUsageManager(handler);
                cardUsageManager.clearUsedAlwaysURLs(cuid_);
                cardUsageManager.clearCardHistory(cuid_);
            }
            finally {
                cardUsageManager.close();
            }
            ICardRegistry.getInstance().deleteICard(this.getHandler(), new CUID(cuid));
        }
        catch (CardException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        catch (UserProfileException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public void deleteAllICard() throws RppsException {
        List icards = this.getICardsByUser(this.getHandler());
        Iterator iter = icards.iterator();
        while (iter.hasNext()) {
            this.deleteICard(((ICard)iter.next()).getCUID().toString());
        }
    }

    public UIResponseTO getUserInterface(String url, String target, String sslCert, String policytype, String policy) throws RppsException {
        UserInterfaceResponse uir = new UserInterfaceResponse();
        try {
            IICardSelector selector = ICardSelectorService.getInstance().getICardSelector(this.getHandler(), policy);
            uir.setUCL(selector.getUserChoice());
            uir.setRequestorInformation(RppsHelper.parseSSLCert(sslCert));
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        UIResponseTO uirto = new UIResponseTO();
        try {
            URI url_ = ConvertHelper.convertString_to_URI(url);
            if (uir != null) {
                uirto.setStatus("ok");
                UIResponseRPTO rp = new UIResponseRPTO();
                rp.setName(uir.getName());
                rp.setAddr1(uir.getAddr1());
                rp.setAddr2(uir.getAddr2());
                rp.setPhone(uir.getPhone());
                rp.setVerifier(uir.getVerifier());
                uirto.setRP(rp);
                uirto.setAnd(this.getAnds(uir.getUCL(), url_, (ICardSpacePolicy)ICardSelectorService.getInstance().parsePolicy(policy)));
            }
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        return uirto;
    }

    protected ICredential getICredentialByPPID(X509Certificate x509cert, String ppid) throws RppsException {
        try {
            byte[] bppid = Base64.decode((String)ppid);
            PPIDCardSpacePolicy policy = new PPIDCardSpacePolicy(x509cert, certStoreTrust, bppid);
            IICardSelector selector = ICardSelectorService.getInstance().getICardSelector(this.getHandler(), (IPolicy)policy);
            UserChoiceTree_ANDofORs uct = (UserChoiceTree_ANDofORs)selector.getUserChoice();
            SelectionANDofORs subselection = uct.getDefaultSelection();
            if (subselection.isEmpty()) {
                throw new RppsException("Cannot find the Personal card used to authenticate for this managed card.");
            }
            String cuid = ((SelectionANDofORsElm)subselection.getElements().get(0)).getUUID();
            ICard card = this.getICardByCUID(new CUID(cuid));
            if (card == null) {
                return null;
            }
            ICredentialDescriptor[] der = card.getRequiredCredentials();
            if (der == null) {
                return null;
            }
            if (der.length == 0) {
                return null;
            }
            return der[0].getCredential();
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected ICard getICardByPPID(X509Certificate x509cert, String ppid) throws RppsException {
        try {
            byte[] bppid = Base64.decode((String)ppid);
            PPIDCardSpacePolicy policy = new PPIDCardSpacePolicy(x509cert, certStoreTrust, bppid);
            IICardSelector selector = ICardSelectorService.getInstance().getICardSelector(this.getHandler(), (IPolicy)policy);
            UserChoiceTree_ANDofORs uct = (UserChoiceTree_ANDofORs)selector.getUserChoice();
            SelectionANDofORs subselection = uct.getDefaultSelection();
            if (subselection.isEmpty()) {
                throw new RppsException("Cannot find the Personal card used to authenticate for this managed card.");
            }
            String cuid = ((SelectionANDofORsElm)subselection.getElements().get(0)).getUUID();
            return this.getICardByCUID(new CUID(cuid));
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public TokenResponseTO getTokenByClaims(String sslCert, String[] claimName, String[] claimValue) throws RppsException {
        try {
            Hashtable<String, String> claimHashtable = new Hashtable<String, String>();
            for (int i = 0; i < claimName.length; ++i) {
                try {
                    claimHashtable.put(claimName[i], claimValue[i]);
                    continue;
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
            X509Certificate cert = RppsHelper.parseSSLCert(sslCert);
            ISTSResponse resp = UserProfileTokenHelper.getToken((X509Certificate)RppsHelper.parseSSLCert(sslCert), claimHashtable);
            IdentityToken itoken = new IdentityToken(resp, Base64.encode((byte[])cert.getEncoded()));
            String tokenAsString = (String)itoken.getAs(class$java$lang$String == null ? (class$java$lang$String = RppsService.class$("java.lang.String")) : class$java$lang$String);
            return ConvertHelper.createTokenResponse(tokenAsString);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public TokenResponseTO getTokenObject(String policy, String policytype, String sslCert, String[] cuids, String typeofCredential, String[] credentialKey, String[] credentialValue) throws RppsException {
        TokenResponseTO token = null;
        try {
            CardInformationRPPS cardCredentialInfo;
            ICard card;
            RppsService.AllowSelfSignedSSL();
            Hashtable<String, String> table = new Hashtable<String, String>();
            boolean saveCard = false;
            boolean saveCredential = false;
            String urlStr = null;
            for (int i = 0; i < credentialKey.length; ++i) {
                if (credentialKey[i] == null || credentialValue[i] == null) continue;
                table.put(credentialKey[i], credentialValue[i]);
                this.log.debug((Object)("Put in table key='" + credentialKey[i] + "' with value='" + credentialValue[i] + "'"));
            }
            if (table.get("saveCard") != null && "true".equalsIgnoreCase((String)table.get("saveCard"))) {
                saveCard = true;
            }
            if (table.get("saveCredential") != null && "true".equalsIgnoreCase((String)table.get("saveCredential"))) {
                saveCredential = true;
            }
            if (table.get("url") != null) {
                urlStr = (String)table.get("url");
            }
            if (urlStr != null && urlStr.indexOf("?") > -1) {
                urlStr = urlStr.substring(0, urlStr.indexOf("?"));
            }
            this.log.debug((Object)("CUID parameter is " + cuids[0]));
            this.log.debug((Object)("SaveCard parameter is " + Boolean.toString(saveCard)));
            this.log.debug((Object)("SaveCredential parameter is " + Boolean.toString(saveCredential)));
            this.log.debug((Object)("Url parameter is " + urlStr));
            URI url = null;
            if (urlStr != null && urlStr.length() > 0) {
                url = ConvertHelper.convertString_to_URI(urlStr);
            }
            if ((card = this.getICardByCUID(new CUID(cuids[0]))) != null) {
                cardCredentialInfo = null;
                CUID cuidUrl = this.getCuidByUrl(url);
                if (cuidUrl != null && cuidUrl.equals((Object)card.getCUID()) && !saveCard) {
                    this.deleteUrlCardRelation(card.getCUID(), url);
                }
            } else {
                throw new RppsException("Didn't find card with cuid=" + cuids[0]);
            }
            cardCredentialInfo = this.getCardInformationByCuid(card.getCUID());
            ICredential credential = cardCredentialInfo != null && cardCredentialInfo.getCardCredential() != null ? ConvertHelper.convertCardCredential_to_ICredential(card, cardCredentialInfo.getCardCredential()) : ConvertHelper.convertHashtable_to_Credential(card, typeofCredential, table);
            token = this.getTokenObject(policy, policytype, sslCert, cuids, credential, cardCredentialInfo, url, saveCard, saveCredential);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        return token;
    }

    protected TokenResponseTO getTokenObject(String policy, String policytype, String sslCert, String[] cuids, ICredential credential, CardInformationRPPS cardCredentialInfo, URI url, boolean saveCard, boolean saveCredential) throws RppsException {
        TokenResponseTO token = null;
        try {
            CUID cuid = new CUID(cuids[0]);
            if (!saveCredential && cardCredentialInfo != null && cardCredentialInfo.getCardCredential() != null) {
                this.clearCardCredential(cuid);
            }
            if ((token = this.getTokenObject(policy, policytype, sslCert, cuids, credential, url)) != null && token.getTkn() != null && token.getTkn().length() > 0) {
                if (url != null) {
                    this.addCardHistory(cuid, url);
                }
                if (saveCard && url != null) {
                    this.addUrlCardRelation(cuid, url, cardCredentialInfo);
                }
                if (saveCredential) {
                    CardCredential cardCredential = ConvertHelper.convertICredential_to_CardCredential(credential);
                    this.setCardCredential(cuid, cardCredential);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        return token;
    }

    protected TokenResponseTO getTokenObject(String policy, String policytype, String sslCert, String[] cuids, ICredential credential, URI url) throws RppsException {
        String token = null;
        SelectionANDofORs selection = new SelectionANDofORs();
        if (url != null) {
            selection.action = url.toString();
        }
        selection.idemix_credential_db_uri = "credentials.db";
        selection.cardspace_credential_db_uri = "infocards.properties";
        selection.publickey_db_uri = "pk.db";
        selection.sslCertChain = new X509Certificate[]{RppsHelper.parseSSLCert(sslCert)};
        selection.setCredential(credential);
        for (int i = 0; i < cuids.length; ++i) {
            String uid = cuids[i];
            int ui = 0;
            try {
                if (i < cuids.length - 1) {
                    ui = Integer.parseInt(cuids[++i]);
                }
            }
            catch (Exception ew) {
                ew.printStackTrace();
            }
            SelectionANDofORsElm se = new SelectionANDofORsElm(uid, ui, 0);
            selection.add(se);
        }
        try {
            IICardSelector selector = ICardSelectorService.getInstance().getICardSelector(this.getHandler(), policy);
            IIdentityToken iToken = selector.getIdentityToken(selection);
            token = (String)iToken.getAs(class$java$lang$String == null ? (class$java$lang$String = RppsService.class$("java.lang.String")) : class$java$lang$String);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        return ConvertHelper.createTokenResponse(token);
    }

    public TokenResponseTO getTokenByUrl(String policy, String policytype, String sslCert, String url) throws RppsException {
        TokenResponseTO token = null;
        try {
            URI url_ = ConvertHelper.convertString_to_URI(url);
            CUID cuidUrl = this.getCuidByUrl(url_);
            if (cuidUrl == null) {
                return null;
            }
            CardInformationRPPS cardInformation = this.getCardInformationByCuid(cuidUrl);
            if (cardInformation != null) {
                String[] cuids = new String[]{cuidUrl.toString()};
                ICard card = this.getICardByCUID(cuidUrl);
                if (card == null) {
                    new RppsException("Does not find card with cuid " + cuidUrl.toString());
                }
                ICredential credential = null;
                credential = ConvertHelper.convertCardCredential_to_ICredential(card, cardInformation.getCardCredential());
                token = this.getTokenObject(policy, policytype, sslCert, cuids, credential, url_);
                if (token != null && token.getTkn() != null && token.getTkn().length() > 0 && url_ != null) {
                    this.addCardHistory(card.getCUID(), url_);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
        }
        return token;
    }

    public ExtraTokenResponseTO getTokenExtraByUrl(String policy, String policytype, String sslCert, String url) throws RppsException {
        ExtraTokenResponseTO token = null;
        try {
            URI url_ = ConvertHelper.convertString_to_URI(url);
            CUID cuidUrl = this.getCuidByUrl(url_);
            if (cuidUrl == null) {
                return null;
            }
            CardInformationRPPS cardCredentialInfo = this.getCardInformationByCuid(cuidUrl);
            if (cardCredentialInfo != null) {
                String[] cuids = new String[]{cardCredentialInfo.getCuid().toString()};
                ICard card = this.getICardByCUID(cardCredentialInfo.getCuid());
                if (card == null) {
                    new RppsException("Does not find card with cuid " + cardCredentialInfo.getCuid().toString());
                }
                ICredential credential = null;
                credential = ConvertHelper.convertCardCredential_to_ICredential(card, cardCredentialInfo.getCardCredential());
                TokenResponseTO tokenTO = this.getTokenObject(policy, policytype, sslCert, cuids, credential, url_);
                if (tokenTO != null && tokenTO.getTkn() != null && tokenTO.getTkn().length() > 0 && url_ != null) {
                    this.addCardHistory(card.getCUID(), url_);
                }
                token = new ExtraTokenResponseTO();
                token.setTkn(tokenTO.getTkn());
                token.setCardName(card.getName());
                token.setCardDescription(card.getDescription());
                token.setCardImage(card.getImage());
                token.setCardImageType(card.getImageType());
            }
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
        }
        return token;
    }

    protected List getICardCreationTemplate(CallbackHandler handler) throws RppsException {
        Vector<ICardTemplate> temps = new Vector<ICardTemplate>();
        Iterator it = ICardRegistry.getInstance().getICardProviders();
        while (it.hasNext()) {
            ICardProvider provider = (ICardProvider)it.next();
            try {
                if (provider.getCardCreationTemplates(handler) == null) continue;
                ICardTemplate[] templates = provider.getCardCreationTemplates(handler);
                for (int i = 0; i < templates.length; ++i) {
                    temps.add(templates[i]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RppsException(e);
            }
        }
        return temps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICardTemplateTO[] getICardCreationTemplate() {
        List templates = null;
        templates = this.getICardCreationTemplate(this.getHandler());
        ICardTemplateTO[] telmplateList = new ICardTemplateTO[]{};
        if (templates != null) {
            telmplateList = new ICardTemplateTO[templates.size()];
            for (int index = 0; index < templates.size(); ++index) {
                telmplateList[index] = ConvertHelper.convertICardTemplate_to_ICardTemplateTO((ICardTemplate)templates.get(index));
            }
        }
        return telmplateList;
    }

    public ICardTemplate[] getICardCreationTemplateByProvider(String extID) throws RppsException {
        ICardProvider provider = ICardRegistry.getInstance().getICardProvider(extID);
        return provider.getCardCreationTemplates(this.getHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICardTemplateTO getPersonalICardCreationTemplate() {
        ICardTemplate template = null;
        template = this.getPersonalICardCreationTemplate(this.getHandler());
        if (template != null) {
            return ConvertHelper.convertICardTemplate_to_ICardTemplateTO(template);
        }
        return null;
    }

    protected ICardTemplate getPersonalICardCreationTemplate(CallbackHandler handler) throws RppsException {
        Iterator it = ICardRegistry.getInstance().getICardProviders();
        while (it.hasNext()) {
            ICardProvider provider = (ICardProvider)it.next();
            try {
                if (provider.getCardCreationTemplates(handler) == null) continue;
                ICardTemplate[] templates = provider.getCardCreationTemplates(handler);
                for (int i = 0; i < templates.length; ++i) {
                    if (!templates[i].getCardType().isAssignableFrom(class$org$eclipse$higgins$icard$IPersonalInformationCard == null ? RppsService.class$("org.eclipse.higgins.icard.IPersonalInformationCard") : class$org$eclipse$higgins$icard$IPersonalInformationCard)) continue;
                    return templates[i];
                }
            }
            catch (Exception e) {
                this.log.error((Object)e, (Throwable)e);
                throw new RppsException(e);
            }
        }
        return null;
    }

    public ICardTO setPinCode(String cuid, String pinCode) throws RppsException {
        ICard card = null;
        try {
            card = ICardRegistry.getInstance().getICardByCUID(this.getHandler(), cuid);
            if (!(card instanceof IPersonalInformationCard)) {
                new RppsException("This card is not personal");
            }
            card = this.setPinCode((IPersonalInformationCard)card, pinCode.getBytes("UTF-8"));
            return this.convertICard_To_ICardTO(card, false);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected ICard setPinCode(IPersonalInformationCard card, byte[] pinCode) throws RppsException {
        try {
            PinCodeCredential pinCodeCredential = new PinCodeCredential();
            try {
                card.beginUpdates();
                pinCodeCredential.setPinCode(pinCode);
                card.setPinCode((IPinCodeCredential)pinCodeCredential);
                card.applyUpdates();
            }
            catch (CardException e) {
                if (card.isEditMode()) {
                    card.cancelUpdates();
                }
                throw new RppsException(e);
            }
            pinCodeCredential = new PinCodeCredential();
            pinCodeCredential.setPinCode(pinCode);
            return card.getProvider().getICardByCUID(this.getHandler(), card.getCUID(), (ICredential)pinCodeCredential);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public ICardTO resetPinCode(String cuid, String oldPinCode) throws RppsException {
        ICard card = null;
        byte[] oldPinCode_ = null;
        try {
            card = this.getICardByCUID(new CUID(cuid));
            if (card == null) {
                throw new RppsException("Can't find card with CUID " + cuid);
            }
            if (!(card instanceof IPersonalInformationCard)) {
                new RppsException("This card is not personal");
            }
            CardInformationRPPS cardInformation = null;
            if (oldPinCode == null) {
                cardInformation = this.getCardInformationByCuid(new CUID(cuid));
                if (cardInformation.getCardCredential() != null && "IPinCodeCredential".equals(cardInformation.getCardCredential().getCredentialType())) {
                    oldPinCode_ = cardInformation.getCardCredential().getPinCode();
                }
            } else {
                oldPinCode_ = oldPinCode.getBytes("UTF-8");
            }
            card = this.resetPinCode((IPersonalInformationCard)card, oldPinCode_);
            if (cardInformation == null) {
                this.clearCardCredential(card.getCUID());
            }
            return this.convertICard_To_ICardTO(card, false);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected ICard resetPinCode(IPersonalInformationCard card, byte[] oldPinCode) throws RppsException {
        try {
            PinCodeCredential pinCodeCredential = new PinCodeCredential();
            pinCodeCredential.setPinCode(oldPinCode);
            card = (IPersonalInformationCard)card.getProvider().getICardByCUID(this.getHandler(), card.getCUID(), (ICredential)pinCodeCredential);
            try {
                PinCodeCredential pinCodeCredentialNew = new PinCodeCredential();
                pinCodeCredentialNew.setPinCode(null);
                card.beginUpdates();
                card.setPinCode((IPinCodeCredential)pinCodeCredentialNew);
                card.applyUpdates();
            }
            catch (CardException e) {
                if (card.isEditMode()) {
                    card.cancelUpdates();
                }
                throw new RppsException(e);
            }
            return ICardRegistry.getInstance().getICardByCUID(this.getHandler(), card.getCUID());
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public ICardTO editPinCode(String cuid, String oldPinCode, String newPinCode) throws RppsException {
        ICard card = null;
        byte[] oldPinCode_ = null;
        try {
            card = this.getICardByCUID(new CUID(cuid));
            if (card == null) {
                throw new RppsException("Can't find card with CUID " + cuid);
            }
            if (!(card instanceof IPersonalInformationCard)) {
                new RppsException("This card is not personal");
            }
            CardInformationRPPS cardInformation = null;
            if (oldPinCode == null) {
                cardInformation = this.getCardInformationByCuid(new CUID(cuid));
                if (cardInformation.getCardCredential() != null && "IPinCodeCredential".equals(cardInformation.getCardCredential().getCredentialType())) {
                    oldPinCode_ = cardInformation.getCardCredential().getPinCode();
                }
            } else {
                oldPinCode_ = oldPinCode.getBytes("UTF-8");
            }
            card = this.resetPinCode((IPersonalInformationCard)card, oldPinCode_);
            card = this.setPinCode((IPersonalInformationCard)card, newPinCode.getBytes("UTF-8"));
            if (cardInformation != null) {
                try {
                    if (cardInformation.getCardCredential() != null) {
                        CardCredential cardCredential = cardInformation.getCardCredential();
                        cardCredential.setPinCode(newPinCode.getBytes("UTF-8"));
                        this.setCardCredential(new CUID(cuid), cardCredential);
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)e, (Throwable)e);
                }
            }
            return this.convertICard_To_ICardTO(card, false);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public void addCardHistory(CUID cuid, URI site) throws UserProfileException {
        ICardUsageManager cardUsageManager = null;
        try {
            cardUsageManager = ICardRegistry.getInstance().getUserProfileService().getCardUsageManager(this.getHandler());
            cardUsageManager.addCardHistory(cuid, site);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        finally {
            if (cardUsageManager != null) {
                cardUsageManager.close();
            }
        }
    }

    protected void clearCardHistory(CUID cuid) throws UserProfileException {
        ICardUsageManager cardUsageManager = null;
        try {
            cardUsageManager = ICardRegistry.getInstance().getUserProfileService().getCardUsageManager(this.getHandler());
            cardUsageManager.clearCardHistory(cuid);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        finally {
            if (cardUsageManager != null) {
                cardUsageManager.close();
            }
        }
    }

    public boolean clearCardHistory(String cuid) {
        try {
            this.clearCardHistory(new CUID(cuid));
            List list = this.getCardHistoryLog(new CUID(cuid));
            return list == null || list != null && list.size() == 0;
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    private List getCardHistoryLog(CUID cuid) throws UserProfileException {
        ICardUsageManager cardUsageManager = null;
        try {
            cardUsageManager = ICardRegistry.getInstance().getUserProfileService().getCardUsageManager(this.getHandler());
            List list = cardUsageManager.getCardHistory(cuid);
            return list;
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        finally {
            if (cardUsageManager != null) {
                cardUsageManager.close();
            }
        }
    }

    public CardUsageTO[] getCardHistoryLog(String cuid, int startFrom, int size, String orderBy, String orderDirection) {
        boolean desc = orderDirection.equalsIgnoreCase("desc");
        String order = "site";
        if ("date".equalsIgnoreCase(orderBy)) {
            order = "date";
        } else if ("site".equalsIgnoreCase(orderBy)) {
            order = "useAlways";
        }
        try {
            List list = this.getCardHistoryLog(new CUID(cuid), startFrom, size, order, desc);
            CardUsageTO[] arrayUsage = new CardUsageTO[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                CardUsage cardUsage = (CardUsage)list.get(i);
                arrayUsage[i] = ConvertHelper.convertCardUsage_to_CardUsageTO(cardUsage);
            }
            return arrayUsage;
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    private List getCardHistoryLog(CUID cuid, int startFrom, int size, String orderBy, boolean desc) throws RppsException, UserProfileException {
        ICardUsageManager cardUsageManager = null;
        try {
            cardUsageManager = ICardRegistry.getInstance().getUserProfileService().getCardUsageManager(this.getHandler());
            List list = cardUsageManager.getCardHistory(cuid);
            return list;
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        finally {
            if (cardUsageManager != null) {
                cardUsageManager.close();
            }
        }
    }

    protected List getCardHistory(CUID cuid) throws RppsException, UserProfileException {
        ICardUsageManager cardUsageManager = null;
        try {
            cardUsageManager = ICardRegistry.getInstance().getUserProfileService().getCardUsageManager(this.getHandler());
            List list = cardUsageManager.getCardUsageSummary(cuid);
            return list;
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        finally {
            if (cardUsageManager != null) {
                cardUsageManager.close();
            }
        }
    }

    public CardUsageTO[] getCardHistory(String cuid, int startFrom, int size, String orderBy, String orderDirection) {
        boolean desc = orderDirection.equalsIgnoreCase("desc");
        String order = "site";
        if ("date".equalsIgnoreCase(orderBy)) {
            order = "date";
        } else if ("site".equalsIgnoreCase(orderBy)) {
            order = "useAlways";
        }
        try {
            List list = this.getCardHistory(new CUID(cuid), startFrom, size, order, desc);
            CardUsageTO[] arrayUsage = new CardUsageTO[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                CardUsage cardUsage = (CardUsage)list.get(i);
                arrayUsage[i] = ConvertHelper.convertCardUsage_to_CardUsageTO(cardUsage);
            }
            return arrayUsage;
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected List getCardHistory(CUID cuid, int startFrom, int size, String orderBy, boolean desc) throws RppsException, UserProfileException {
        ICardUsageManager cardUsageManager = null;
        try {
            cardUsageManager = ICardRegistry.getInstance().getUserProfileService().getCardUsageManager(this.getHandler());
            List list = cardUsageManager.getCardUsageSummary(cuid, startFrom, size, orderBy, desc);
            return list;
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        finally {
            if (cardUsageManager != null) {
                cardUsageManager.close();
            }
        }
    }

    private List getUsedCards(URI url) throws RppsException, UserProfileException {
        ICardUsageManager cardUsageManager = null;
        try {
            cardUsageManager = ICardRegistry.getInstance().getUserProfileService().getCardUsageManager(this.getHandler());
            List list = cardUsageManager.getUsedCards(url);
            return list;
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        finally {
            if (cardUsageManager != null) {
                cardUsageManager.close();
            }
        }
    }

    public CategoryTO[] getCategory() throws RppsException {
        try {
            List category = this.getCategories(this.getHandler());
            CategoryTO[] categorysTO = new CategoryTO[]{};
            if (category != null) {
                categorysTO = new CategoryTO[category.size()];
                for (int i = 0; i < category.size(); ++i) {
                    categorysTO[i] = ConvertHelper.convertCategory_to_CategoryTO((Category)category.get(i));
                }
            }
            return categorysTO;
        }
        catch (RppsException e) {
            this.log.error((Object)e, (Throwable)e);
            throw e;
        }
    }

    protected List getCategories(CallbackHandler handler) throws RppsException {
        try {
            List list = ICardRegistry.getInstance().getUserProfileService().getCategories(handler);
            Collections.sort(list, new CategoryComparator());
            return list;
        }
        catch (UserProfileException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public CategoryTO addCategory(CategoryTO categoryTO) throws RppsException {
        try {
            Category category = ICardRegistry.getInstance().getUserProfileService().addCategory(this.getHandler(), ConvertHelper.convertCategoryTO_to_Category(categoryTO));
            return ConvertHelper.convertCategory_to_CategoryTO(category);
        }
        catch (UserProfileException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public void deleteCategory(String categoryId) throws RppsException {
        try {
            ICardRegistry.getInstance().getUserProfileService().deleteCategory(this.getHandler(), categoryId);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public CategoryTO modifyCategory(CategoryTO categoryTO) throws RppsException {
        try {
            Category category = ICardRegistry.getInstance().getUserProfileService().modifyCategory(this.getHandler(), ConvertHelper.convertCategoryTO_to_Category(categoryTO));
            return ConvertHelper.convertCategory_to_CategoryTO(category);
        }
        catch (UserProfileException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public ResponseMessage modifyCategories(CategoryTO[] categoriesTO) throws RppsException {
        try {
            for (int i = 0; i < categoriesTO.length; ++i) {
                ICardRegistry.getInstance().getUserProfileService().modifyCategory(this.getHandler(), ConvertHelper.convertCategoryTO_to_Category(categoriesTO[i]));
            }
            return new ResponseMessage(0, "");
        }
        catch (UserProfileException e) {
            this.log.error((Object)e, (Throwable)e);
            return new ResponseMessage(-1, e.getMessage());
        }
    }

    public UserProfileTO getUserProfile() throws RppsException, AccessException {
        UserProfile userProfile = this.getUserProfile(this.getHandler());
        return ConvertHelper.convertUserProfile_to_UserProfileTO(userProfile);
    }

    private UserProfile getUserProfile(CallbackHandler handler) throws RppsException, AccessException {
        try {
            if (this.userProfile == null) {
                this.userProfile = ICardRegistry.getInstance().getUserProfileService().getUserProfile(handler);
            }
            return this.userProfile;
        }
        catch (UserProfileAuthenticationException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new AccessException(e.getMessage(), (Exception)((Object)e));
        }
        catch (UserProfileException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e.getMessage(), e);
        }
    }

    public void addUserProfileFromHBX(String userId, String password) throws RppsException {
        UserProfileTO userProfile = new UserProfileTO();
        userProfile.setLoginName(userId);
        userProfile.setPassword(password);
        ResponseMessage responseMessage = this.addUserProfile(userProfile);
        if (responseMessage.getCode() != 0) {
            throw new RppsException(responseMessage.getMessage());
        }
    }

    public ResponseMessage addUserProfile(UserProfileTO userProfile) throws RppsException {
        try {
            CallbackHandler handler = RppsHelper.getCallbackHandler(userProfile.getLoginName(), userProfile.getPassword());
            ICardRegistry.getInstance().getUserProfileService().addUserProfile(handler, ConvertHelper.convertUserProfileTO_to_UserProfile(userProfile));
            return new ResponseMessage(0);
        }
        catch (UserProfileException e) {
            this.log.error((Object)e, (Throwable)e);
            return new ResponseMessage(-1, e.getMessage());
        }
    }

    public ResponseMessage deleteUserProfile() throws RppsException {
        try {
            this.deleteUserProfile(this.getHandler());
            return new ResponseMessage(0);
        }
        catch (RppsException e) {
            this.log.error((Object)e, (Throwable)e);
            return new ResponseMessage(-1, e.getMessage());
        }
    }

    protected void deleteUserProfile(CallbackHandler handler) throws RppsException {
        try {
            ICardRegistry.getInstance().getUserProfileService().deleteUserProfile(handler);
        }
        catch (UserProfileException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public boolean userIdentifierExists(String userIdentifier) {
        try {
            return ICardRegistry.getInstance().getUserProfileService().userIdentifierExists(userIdentifier);
        }
        catch (UserProfileException userProfileException) {
            return false;
        }
    }

    public UserProfileTO modifyUserProfile(UserProfileTO userProfile) throws RppsException {
        try {
            this.userProfile = ICardRegistry.getInstance().getUserProfileService().modifyUserProfile(this.getHandler(), ConvertHelper.convertUserProfileTO_to_UserProfile(userProfile));
            return this.getUserProfile();
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public CardInformationTO getCardInformation(String cuid, int size) throws RppsException {
        try {
            List cardHistory = this.getCardHistory(new CUID(cuid));
            int sizeAll = 0;
            if (cardHistory != null) {
                sizeAll = cardHistory.size();
            }
            cardHistory = this.getCardHistory(new CUID(cuid), 0, size, "date", false);
            return ConvertHelper.createCardInformationTO(cardHistory, sizeAll);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected CUID getCuidByUrl(URI url) throws RppsException, UserProfileException {
        ICardUsageManager cardUsageManager = null;
        try {
            cardUsageManager = ICardRegistry.getInstance().getUserProfileService().getCardUsageManager(this.getHandler());
            CUID cUID = cardUsageManager.getUsedAlwaysCard(url);
            return cUID;
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        finally {
            if (cardUsageManager != null) {
                cardUsageManager.close();
            }
        }
    }

    protected CardInformationRPPS getCardInformationByCuid(CUID cuid) throws RppsException, UserProfileException {
        CardInformationRPPS cardInformation = null;
        ICardUsageManager cardUsageManager = null;
        try {
            cardUsageManager = ICardRegistry.getInstance().getUserProfileService().getCardUsageManager(this.getHandler());
            CardInformation cardInformationUP = ICardRegistry.getInstance().getUserProfileService().getCardInformation(this.getHandler(), cuid);
            cardInformation = new CardInformationRPPS(cardInformationUP);
            List cardUsages = cardUsageManager.getUsedAlwaysURLs(cuid);
            URI[] uris = new URI[cardUsages.size()];
            for (int i = 0; i < cardUsages.size(); ++i) {
                uris[i] = ((CardUsage)cardUsages.get(i)).getSite();
            }
            cardInformation.setUris(uris);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        return cardInformation;
    }

    public ICardTO clearCardCredential(String cuid) throws RppsException {
        try {
            this.clearCardCredential(new CUID(cuid));
            return this.getICardByCUID(cuid);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected void clearCardCredential(CUID cuid) throws RppsException {
        try {
            ICardRegistry.getInstance().getUserProfileService().clearCardCredential(this.getHandler(), cuid);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public boolean setCardCredential(String cuid, UITokenServiceCredentialTO tokenCredential) throws RppsException {
        try {
            ICard card = this.getICardByCUID(new CUID(cuid));
            if (card == null) {
                throw new RppsException("Can't find card with CUID " + cuid);
            }
            ICredential credential = ConvertHelper.convertUITokenServiceCredentialTO_to_ICredentials(card, tokenCredential);
            ICardProvider provider = card.getProvider();
            card = null;
            if (credential != null) {
                card = provider.getICardByCUID(this.getHandler(), new CUID(cuid), credential);
            }
            if (card != null) {
                CardCredential cardCredential = ConvertHelper.convertUITokenServiceCredentialTO_to_CardCredential(tokenCredential);
                boolean result = this.setCardCredential(new CUID(cuid), cardCredential);
                return result;
            }
            throw new RppsException("Didn't set card credential.");
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e.getMessage(), e);
        }
    }

    protected boolean setCardCredential(CUID cuid, CardCredential cardCredential) throws RppsException {
        try {
            CardInformationRPPS cardInformation = new CardInformationRPPS(ICardRegistry.getInstance().getUserProfileService().setCardCredential(this.getHandler(), cuid, cardCredential));
            if (cardInformation.getCardCredential() != null && cardCredential != null || cardInformation.getCardCredential() == null && cardCredential == null) {
                return true;
            }
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        return false;
    }

    protected void addUrlCardRelation(CUID cuid, URI url, CardInformationRPPS cardInformation) throws RppsException, UserProfileException {
        ICardUsageManager cardUsageManager = null;
        try {
            URI[] urls;
            URI url_ = ConvertHelper.convertString_to_URI(url.toString());
            if (cardInformation != null && (urls = cardInformation.getUris()) != null) {
                for (int i = 0; i < urls.length; ++i) {
                    if (!urls[i].equals(url)) continue;
                    return;
                }
            }
            cardUsageManager = ICardRegistry.getInstance().getUserProfileService().getCardUsageManager(this.getHandler());
            cardUsageManager.setUsedAlways(cuid, url_);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        finally {
            if (cardUsageManager != null) {
                cardUsageManager.close();
            }
        }
    }

    public boolean deleteUrlCardRelation(String cuid, String url) throws RppsException {
        try {
            if (url != null) {
                this.deleteUrlCardRelation(new CUID(cuid), new URI(url));
            }
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected CardUsage deleteUrlCardRelation(CUID cuid, URI url) throws RppsException, UserProfileException {
        ICardUsageManager cardUsageManager = null;
        try {
            cardUsageManager = ICardRegistry.getInstance().getUserProfileService().getCardUsageManager(this.getHandler());
            CardUsage cardUsage = cardUsageManager.deleteUsedAlways(cuid, url);
            return cardUsage;
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        finally {
            if (cardUsageManager != null) {
                cardUsageManager.close();
            }
        }
    }

    public static void AllowSelfSignedSSL() {
        if (Security.getProvider("Dummy") == null) {
            Security.insertProviderAt(new DummySecurityProvider(), 2);
            Security.setProperty("ssl.TrustManagerFactory.algorithm", DummyTrustManagerFactory.getAlgorithm());
        }
    }

    public String getHigginsServiceGlobalIName() {
        return System.getProperty("higgins.service.global.name", "=parity");
    }

    protected UIResponseAndTO[] getAnds(UserChoiceTree uct, URI url, ICardSpacePolicy policy) throws RppsException, UserProfileException {
        ArrayList<UIResponseAndTO> andList = new ArrayList<UIResponseAndTO>();
        if (uct != null) {
            ListIterator li = uct.getListIterator();
            while (li.hasNext()) {
                Object child = li.next();
                UIResponseAndTO and = new UIResponseAndTO();
                if (child instanceof UserChoiceTree) {
                    ArrayList<UIResponseOrTO> orList = new ArrayList<UIResponseOrTO>();
                    ListIterator li2 = ((UserChoiceTree)child).getListIterator();
                    while (li2.hasNext()) {
                        Object child2 = li2.next();
                        UIResponseOrTO or = new UIResponseOrTO();
                        if (child2 instanceof UserChoiceTree) {
                            ArrayList<UIResponseAndTO> andList2 = new ArrayList<UIResponseAndTO>();
                            ListIterator li3 = ((UserChoiceTree)child2).getListIterator();
                            while (li3.hasNext()) {
                                Object child3 = li3.next();
                                UIResponseAndTO and2 = new UIResponseAndTO();
                                if (child3 instanceof UCTelm) {
                                    // empty if block
                                }
                                andList2.add(and2);
                            }
                        } else if (child2 instanceof UCTelm) {
                            IPolicy atom = ((UCTelm)child2).getAtom();
                            UIResponseClauseTO clause = new UIResponseClauseTO();
                            if (atom instanceof ICardSpacePolicy) {
                                ICardSpacePolicy icp = (ICardSpacePolicy)atom;
                                clause.setLabel(icp.getSummary());
                                clause.setLonglabel(icp.getSummary().toString());
                                List requiredClaims = icp.getRequiredClaims();
                                String[] summary = new String[requiredClaims.size()];
                                ListIterator iter = requiredClaims.listIterator();
                                int i = 0;
                                while (iter.hasNext()) {
                                    summary[i++] = iter.next().toString();
                                }
                                clause.setLabelType(summary);
                                clause.setOptional(icp.getOptionalClaimSummary());
                                clause.setLongOptional(icp.getOptionalClaimSummary().toString());
                                List optionalClaims = icp.getOptionalClaims();
                                summary = new String[optionalClaims.size()];
                                iter = optionalClaims.listIterator();
                                i = 0;
                                while (iter.hasNext()) {
                                    summary[i++] = iter.next().toString();
                                }
                                clause.setOptionalType(summary);
                            } else {
                                clause.setLabel(atom.getSummary());
                                clause.setLonglabel(atom.getSummary().toString());
                                clause.setLabelType(new String[0]);
                            }
                            UIResponseUsableCardsTO uc = new UIResponseUsableCardsTO();
                            ArrayList<UIResponseCardTO> cardList = new ArrayList<UIResponseCardTO>();
                            Iterator it = ((UCTelm)child2).getCredsIterator();
                            while (it != null && it.hasNext()) {
                                URI[] urls;
                                UIResponseCardTO card = new UIResponseCardTO();
                                CredentialContainer cc = (CredentialContainer)it.next();
                                ICard cred = cc.getCredential();
                                CardInformationRPPS cardInformation = this.getCardInformationByCuid(cred.getCUID());
                                card = this.convertICard_To_UIResponseCardTO(cred, url, policy, cardInformation);
                                card.setUid(cc.key);
                                if (cardInformation != null && (urls = cardInformation.getUris()) != null) {
                                    for (int i = 0; i < urls.length; ++i) {
                                        if (!urls[i].equals(url)) continue;
                                        card.setSaveCard(true);
                                    }
                                }
                                cardList.add(card);
                            }
                            UIResponseCardTO[] cards = new UIResponseCardTO[cardList.size()];
                            cardList.toArray(cards);
                            uc.setCard(cards);
                            clause.setUsableCards(uc);
                            List usedCard = this.getUsedCards(url);
                            String[] usedCardCuids = new String[usedCard.size()];
                            for (int index = 0; index < usedCard.size(); ++index) {
                                usedCardCuids[index] = ((CardUsage)usedCard.get(index)).getCuid().toString();
                            }
                            clause.setUsedCardCuids(usedCardCuids);
                            or.setClause(clause);
                        }
                        orList.add(or);
                    }
                    UIResponseOrTO[] ors = new UIResponseOrTO[orList.size()];
                    orList.toArray(ors);
                    and.setOr(ors);
                } else if (child instanceof UCTelm) {
                    // empty if block
                }
                andList.add(and);
            }
        }
        UIResponseAndTO[] ands = new UIResponseAndTO[andList.size()];
        andList.toArray(ands);
        return ands;
    }

    protected UITokenServiceCredentialTO[] convertICredentials_to_UITokenServiceCredentialTO(ICard card, CardCredential cardCredential) {
        ICredentialDescriptor[] der;
        ArrayList<UITokenServiceCredentialTO> credList = new ArrayList<UITokenServiceCredentialTO>();
        if (card != null && (der = card.getRequiredCredentials()) != null) {
            for (int i = 0; i < der.length; ++i) {
                ICredential credential = der[i].getCredential();
                UITokenServiceCredentialTO credentialTO = this.convertICredentials_to_UITokenServiceCredentialTO(credential);
                if (credentialTO == null) continue;
                if (cardCredential != null && credentialTO.getType().equals(cardCredential.getCredentialType())) {
                    credentialTO.setSaveCredential(true);
                }
                credList.add(credentialTO);
            }
        }
        UITokenServiceCredentialTO[] array = new UITokenServiceCredentialTO[credList.size()];
        credList.toArray(array);
        return array;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected UITokenServiceCredentialTO convertICredentials_to_UITokenServiceCredentialTO(ICredential credential) {
        UITokenServiceCredentialTO tokenService = null;
        if (credential == null) return tokenService;
        tokenService = new UITokenServiceCredentialTO();
        if (credential instanceof ITokenServiceCredential) {
            tokenService.setAddress(((ITokenServiceCredential)credential).getAddress().toString());
            tokenService.setMetadataAddress(((ITokenServiceCredential)credential).getMetadataAddress().toString());
            if (credential instanceof ITSUsernamePasswordCredential) {
                tokenService.setPassword(((ITSUsernamePasswordCredential)credential).getPassword());
                tokenService.setUsername(((ITSUsernamePasswordCredential)credential).getUsername());
                tokenService.setType("ITSUsernamePasswordCredential");
                return tokenService;
            } else if (credential instanceof ITSSelfIssuedCredential) {
                tokenService.setType("ITSSelfIssuedNonPinCredential");
                try {
                    ICard personalCard = this.getICardByPPID(((ITSSelfIssuedCredential)credential).getCertificate(), ((ITSSelfIssuedCredential)credential).getPPID());
                    if (personalCard == null) {
                        throw new RppsException("Cannot find the Personal card used to authenticate for this managed card.");
                    }
                    tokenService.setAssociatedCardName(personalCard.getName());
                    tokenService.setAssociatedCardImage(personalCard.getImage());
                    tokenService.setAssociatedCardImageType(personalCard.getDescription());
                    tokenService.setAssociatedCardDescription(personalCard.getDescription());
                    ICredential subCredential = null;
                    ICredentialDescriptor[] derPersonal = personalCard.getRequiredCredentials();
                    if (derPersonal != null && derPersonal.length > 0) {
                        subCredential = derPersonal[0].getCredential();
                    }
                    if (subCredential == null) return tokenService;
                    int index = 0;
                    while (index < subCredential.getCallbacks().length) {
                        if (subCredential.getCallbacks()[index] instanceof PinCodeCallback) {
                            tokenService.setType("ITSSelfIssuedCredential");
                            return tokenService;
                        }
                        ++index;
                    }
                    return tokenService;
                }
                catch (Exception e) {
                    this.log.error((Object)e, (Throwable)e);
                    return tokenService;
                }
            } else if (credential instanceof ITSKerberosV5Credential) {
                tokenService.setType("ITSKerberosV5Credential");
                return tokenService;
            } else {
                if (!(credential instanceof ITSX509V3Credential)) return null;
                tokenService.setType("ITSX509V3Credential");
            }
            return tokenService;
        } else if (credential instanceof IPinCodeCredential) {
            tokenService.setType("IPinCodeCredential");
            return tokenService;
        } else if (credential instanceof IUsernamePasswordCredential) {
            tokenService.setType("IUsernamePasswordCredential");
            tokenService.setUsername(((IUsernamePasswordCredential)credential).getUsername());
            return tokenService;
        } else {
            if (!(credential instanceof IPasswordCredential)) return null;
            tokenService.setType("IPasswordCredential");
        }
        return tokenService;
    }

    protected UIResponseCardTO convertICard_To_UIResponseCardTO(ICard icard, URI url, ICardSpacePolicy policy, CardInformationRPPS cardInformation) {
        UIResponseCardTO cardTO = new UIResponseCardTO();
        if (icard != null) {
            URI[] urls;
            cardTO.setUid(icard.getCUID().toString());
            String nm = icard.getName();
            int k = nm.lastIndexOf(47);
            nm = k > 0 ? nm.substring(k + 1) : nm;
            cardTO.setName(nm);
            cardTO.setDescription(icard.getDescription());
            cardTO.setImage(icard.getImage());
            cardTO.setImagetype(icard.getImageType());
            List supportedClaimTypeList = icard.getSupportedClaimTypesUris();
            if (supportedClaimTypeList != null && supportedClaimTypeList.size() > 0) {
                String[] supportedClaimType = new String[supportedClaimTypeList.size()];
                supportedClaimTypeList.toArray(supportedClaimType);
                cardTO.setSupportedClaimTypes(supportedClaimType);
            }
            UITokenServiceCredentialTO[] tokenservices = this.convertICredentials_to_UITokenServiceCredentialTO(icard, cardInformation != null ? cardInformation.getCardCredential() : null);
            cardTO.setTokenservices(tokenservices);
            if (cardInformation != null && (urls = cardInformation.getUris()) != null) {
                for (int i = 0; i < urls.length; ++i) {
                    if (!urls[i].equals(url)) continue;
                    cardTO.setSaveCard(true);
                }
            }
            try {
                if (policy.getRequiredClaims() != null && policy.getRequiredClaims().size() > 0) {
                    cardTO.setProperties(ConvertHelper.convertClaims_to_PropertyTO(icard, false, policy.getRequiredClaims().iterator()));
                }
                if (policy.getOptionalClaims() != null && policy.getOptionalClaims().size() > 0) {
                    cardTO.setOptionalClaims(ConvertHelper.convertClaims_to_PropertyTO(icard, false, policy.getOptionalClaims().iterator()));
                }
            }
            catch (Exception e) {
                this.log.error((Object)e, (Throwable)e);
            }
        }
        return cardTO;
    }

    protected ICardTO convertICard_To_ICardTO(ICard card, boolean isCatchAuthentication) throws CardException, InvalidTypeException, RppsException, UserProfileException {
        ICardTO icard = new ICardTO();
        if (card != null) {
            UITokenServiceCredentialTO[] tokenServiceCredentials;
            icard.setId(card.getID());
            icard.setCuid(card.getCUID().toString());
            icard.setName(card.getName());
            icard.setIssuerName(card.getIssuerName());
            icard.setImage(card.getImage());
            icard.setImageType(card.getImageType());
            icard.setSelfIssued(card.isSelfIssued());
            if (card instanceof IPersonalInformationCard) {
                icard.setDeleteable(false);
            } else {
                icard.setDeleteable(true);
            }
            CardCredential cardCredential = null;
            CardInformationRPPS cardInformation = this.getCardInformationByCuid(card.getCUID());
            if (cardInformation != null) {
                cardCredential = cardInformation.getCardCredential();
            }
            if ((tokenServiceCredentials = this.convertICredentials_to_UITokenServiceCredentialTO(card, cardCredential)).length > 0) {
                icard.setTokenServiceCredentials(tokenServiceCredentials);
            }
            icard.setProperties(ConvertHelper.convertClaims_to_PropertyTO(card, isCatchAuthentication, card.getSupportedClaimTypes()));
        }
        return icard;
    }

    protected FormatDescriptorTO convertIFormatDescriptor_to_FormatDescriptorTO(IFormatDescriptor descriptor) {
        FormatDescriptorTO descriptorTO = null;
        if (descriptor != null) {
            descriptorTO = new FormatDescriptorTO();
            descriptorTO.setFormatID(descriptor.getID());
            descriptorTO.setName(descriptor.getDescription());
            descriptorTO.setFileExtension(descriptor.getFileExtension());
            if (descriptor.getCredentialDescriptor() != null && descriptor.getCredentialDescriptor().getCredential() != null) {
                UITokenServiceCredentialTO credential = this.convertICredentials_to_UITokenServiceCredentialTO(descriptor.getCredentialDescriptor().getCredential());
                descriptorTO.setCredential(credential);
            }
        }
        return descriptorTO;
    }

    protected static void CreateTrustedKeystore() {
        Certificate cert;
        String strAlias;
        Enumeration<String> enumCertificates;
        String filename = System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
        String filenameSSLTrustStore = System.getProperty("javax.net.ssl.trustStore");
        ArrayList<Certificate> collCertificates = new ArrayList<Certificate>();
        try {
            KeyStore defaultKeyStore = RppsHelper.loadKeyStore(filename);
            enumCertificates = defaultKeyStore.aliases();
            while (enumCertificates.hasMoreElements()) {
                strAlias = enumCertificates.nextElement();
                cert = defaultKeyStore.getCertificate(strAlias);
                collCertificates.add(cert);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            KeyStore sslKeyStore = RppsHelper.loadKeyStore(filenameSSLTrustStore);
            enumCertificates = sslKeyStore.aliases();
            while (enumCertificates.hasMoreElements()) {
                strAlias = enumCertificates.nextElement();
                cert = sslKeyStore.getCertificate(strAlias);
                collCertificates.add(cert);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!collCertificates.isEmpty()) {
            try {
                CollectionCertStoreParameters collCSP = new CollectionCertStoreParameters(collCertificates);
                certStoreTrust = CertStore.getInstance("Collection", collCSP);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    public static synchronized void ConfigureCache(String configurationBase, String configurationFile) {
        CacheProviderFactory.setConfigurationBase((String)configurationBase);
        CacheProviderFactory.setFileName((String)configurationFile);
        CacheProviderFactory.getCacheProvider();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        RppsService.AllowSelfSignedSSL();
    }

    public static final class DummyTrustManagerFactory
    extends TrustManagerFactorySpi {
        public static String getAlgorithm() {
            return "XTrust509";
        }

        protected void engineInit(KeyStore keystore) throws KeyStoreException {
        }

        protected TrustManager[] engineGetTrustManagers() {
            return new TrustManager[]{new X509TrustManager(this){
                private final /* synthetic */ DummyTrustManagerFactory this$0;
                {
                    this.this$0 = this$0;
                }

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    for (int i = 0; i < certs.length; ++i) {
                        System.out.println("  >>> Checking certificate " + certs[i]);
                    }
                }
            }};
        }

        protected void engineInit(ManagerFactoryParameters arg0) throws InvalidAlgorithmParameterException {
        }
    }

    static final class DummySecurityProvider
    extends Provider {
        private static final long serialVersionUID = 594145003249139851L;

        public DummySecurityProvider() {
            super("Dummy", 1.0, "");
            AccessController.doPrivileged(new PrivilegedAction(this){
                private final /* synthetic */ DummySecurityProvider this$0;
                {
                    this.this$0 = this$0;
                }

                public Object run() {
                    this.this$0.put("TrustManagerFactory." + DummyTrustManagerFactory.getAlgorithm(), (class$org$eclipse$higgins$rpps$core$impl$RppsService$DummyTrustManagerFactory == null ? (class$org$eclipse$higgins$rpps$core$impl$RppsService$DummyTrustManagerFactory = RppsService.class$("org.eclipse.higgins.rpps.core.impl.RppsService$DummyTrustManagerFactory")) : class$org$eclipse$higgins$rpps$core$impl$RppsService$DummyTrustManagerFactory).getName());
                    return null;
                }
            });
        }
    }
}

