/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.rpps.core.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Properties;
import org.eclipse.higgins.rpps.core.impl.FeedProperties;
import org.eclipse.higgins.rsse.RssFeed;
import org.eclipse.higgins.rsse.RssItem;
import org.eclipse.higgins.rsse.parser.FeedParser;
import org.eclipse.higgins.rsse.parser.ParseException;
import org.eclipse.higgins.rsse.util.RssVersion;

public class RssService {
    public static RssService getInstance() {
        return new RssService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RssFeed loadFeed(URL feedUrl, String rssDir) throws IOException, ParseException {
        RssFeed remoteFeed = null;
        InputStream ins = null;
        try {
            URLConnection connection = feedUrl.openConnection();
            connection.setUseCaches(false);
            ins = connection.getInputStream();
            remoteFeed = FeedParser.parse((InputStream)ins);
        }
        finally {
            if (ins != null) {
                ins.close();
            }
        }
        String feedFileName = feedUrl.getFile();
        if (feedFileName != null && feedFileName.length() > 0) {
            feedFileName = feedFileName.substring(feedFileName.lastIndexOf(47));
            File feedFile = new File(rssDir + feedFileName);
            RssFeed localFeed = RssFeed.load((File)feedFile);
            if (localFeed == null) {
                if (feedFile.getParent() != null) {
                    new File(feedFile.getParent()).mkdirs();
                }
                feedFile.createNewFile();
                localFeed = new RssFeed(remoteFeed.getTitle(), remoteFeed.getLink(), remoteFeed.getDescription());
                localFeed.setVersion(RssVersion.RSS_2_0);
            }
            localFeed.merge(remoteFeed);
            localFeed.save(feedFile);
            return localFeed;
        }
        return null;
    }

    public FeedProperties loadFeedProperties(URL feedUrl, String rssDir) throws IOException {
        FeedProperties feedProperties = null;
        try {
            RssFeed feed = this.loadFeed(feedUrl, rssDir);
            if (feed != null) {
                Properties props = new Properties();
                List items = feed.getItems();
                for (int i = 0; i < items.size(); ++i) {
                    RssItem item = (RssItem)items.get(i);
                    props.setProperty(item.getName(), item.getValue() != null ? item.getValue() : "");
                }
                feedProperties = new FeedProperties(URI.create(feed.getTitle()), props);
            }
        }
        catch (ParseException e) {
            throw new IOException(e.getMessage());
        }
        return feedProperties;
    }
}

