/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.rpps.core.rss;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.higgins.rpps.core.impl.RppsService;
import org.eclipse.higgins.rsse.RssFeed;
import org.eclipse.higgins.rsse.RssItem;

public class RssServlet
extends HttpServlet {
    private static final long serialVersionUID = 838906887589824979L;
    private static String rssDir;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (RssServlet.getRssDir() == null || RssServlet.getRssDir().length() == 0) {
            rssDir = config.getServletContext().getRealPath("") + "/rss";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String userId = request.getParameter("userId");
        String password = request.getParameter("password");
        String file = request.getPathInfo();
        if (file.endsWith(".xml")) {
            response.setContentType("text/xml;charset=UTF-8");
        } else {
            response.setContentType("text/html;charset=UTF-8");
        }
        PrintWriter out = response.getWriter();
        File rssFile = new File(rssDir + "/" + userId + file);
        if (rssFile.exists()) {
            try {
                int i;
                String ALIAS = "alias";
                String VALIDATE = "validate";
                RssFeed localFeed = RssFeed.load((File)rssFile);
                List items = localFeed.getItems();
                ArrayList<RssItem> aliasItems = new ArrayList<RssItem>();
                ArrayList<RssItem> validateItems = new ArrayList<RssItem>();
                for (i = 0; i < items.size(); ++i) {
                    RssItem item = (RssItem)items.get(i);
                    if (item.getName().startsWith(ALIAS)) {
                        aliasItems.add(item);
                        continue;
                    }
                    if (!item.getName().startsWith(VALIDATE)) continue;
                    validateItems.add(item);
                }
                for (i = 0; i < aliasItems.size(); ++i) {
                    RssItem aliasItem = (RssItem)aliasItems.get(i);
                    String index = aliasItem.getName().substring(ALIAS.length());
                    StringTokenizer token = new StringTokenizer(aliasItem.getValue(), ",");
                    String host = token.hasMoreTokens() ? token.nextToken().trim() : "";
                    String username = token.hasMoreTokens() ? token.nextToken().trim() : "";
                    try {
                        if (!RppsService.getInstance(userId, password).connectionVerify(host, username)) continue;
                        for (int j = 0; j < validateItems.size(); ++j) {
                            RssItem validateItem = (RssItem)validateItems.get(j);
                            if (!validateItem.getName().equals(VALIDATE + index)) continue;
                            validateItem.setValue("true");
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                localFeed.save(rssFile);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            BufferedReader in = new BufferedReader(new FileReader(rssFile));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    out.println(line);
                }
            }
            finally {
                in.close();
            }
        }
        out.close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }

    public static String getRssDir() {
        return rssDir;
    }
}

