/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.rpps.core.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.ITemplateContainer;
import org.eclipse.higgins.icard.ITemplateElement;
import org.eclipse.higgins.icard.ITemplateValue;
import org.eclipse.higgins.rpps.core.tobj.ICardTemplateTO;
import org.eclipse.higgins.rpps.core.tobj.ITemplateElementTO;

public class RppsHelper {
    public static X509Certificate parseSSLCert(String soapval) {
        X509Certificate sslCert = null;
        if (soapval == null || soapval.trim().length() == 0) {
            return null;
        }
        String[] a = soapval.split(",");
        if (a != null) {
            try {
                byte[] ssl = new byte[a.length];
                int j = 0;
                while (j < a.length) {
                    ssl[j] = (byte)Integer.parseInt(a[j]);
                    ++j;
                }
                ByteArrayInputStream bis = new ByteArrayInputStream(ssl);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                sslCert = (X509Certificate)cf.generateCertificate(bis);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        return sslCert;
    }

    public static CallbackHandler getCallbackHandler(final String userId, final String password) {
        return new CallbackHandler(){

            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                int i = 0;
                while (i < callbacks.length) {
                    if (callbacks[i] instanceof NameCallback) {
                        NameCallback n = (NameCallback)callbacks[i];
                        n.setName(userId);
                    } else if (callbacks[i] instanceof PasswordCallback) {
                        PasswordCallback p = (PasswordCallback)callbacks[i];
                        p.setPassword(password.toCharArray());
                    }
                    ++i;
                }
            }
        };
    }

    public static CallbackHandler getCallbackHandler(final String userId) {
        return new CallbackHandler(){

            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                int i = 0;
                while (i < callbacks.length) {
                    if (callbacks[i] instanceof NameCallback) {
                        NameCallback n = (NameCallback)callbacks[i];
                        n.setName(userId);
                    }
                    ++i;
                }
            }
        };
    }

    public static Properties loadProperties(String[] properties) {
        Properties props = new Properties();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            int i = 0;
            while (i < properties.length) {
                os.write(properties[i].getBytes());
                os.write(13);
                os.write(10);
                ++i;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            props.load(new ByteArrayInputStream(os.toByteArray()));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return props;
    }

    public static ICardTemplate fillICardTemplate_from_ICardTemplateTO(ICardTemplate[] templates, ICardTemplateTO templeteTO) {
        ICardTemplate template = null;
        if (templates != null) {
            int index = 0;
            while (index < templates.length) {
                if (templates[index].getCardType().getName().equalsIgnoreCase(templeteTO.getCardType())) {
                    template = templates[index];
                    template.setDescription(templeteTO.getDescription());
                    template.setDisplayName(templeteTO.getName());
                    int size = templeteTO.getElements().length;
                    int i = 0;
                    while (i < size) {
                        ITemplateElement element = template.getTemplateElementByID(templeteTO.getElements()[i].getId());
                        if (element != null) {
                            if (element instanceof ITemplateValue) {
                                RppsHelper.fillITemplateValue((ITemplateValue)element, templeteTO.getElements()[i].getValue());
                            } else {
                                RppsHelper.fillITemplateContainer((ITemplateContainer)element, templeteTO.getElements()[i].getContainerValue());
                            }
                        }
                        ++i;
                    }
                }
                ++index;
            }
        }
        return template;
    }

    public static void fillITemplateValue(ITemplateValue element, String elementTOValue) {
        if (element != null) {
            element.setValue(elementTOValue);
        }
    }

    public static void fillITemplateContainer(ITemplateContainer root, ITemplateElementTO[] elementsTO) {
        if (root != null) {
            int size = elementsTO.length;
            int i = 0;
            while (i < size) {
                ITemplateElement element = root.getTemplateElementByID(elementsTO[i].getId());
                if (element != null) {
                    if (element instanceof ITemplateValue) {
                        RppsHelper.fillITemplateValue((ITemplateValue)element, elementsTO[i].getValue());
                    } else {
                        RppsHelper.fillITemplateContainer((ITemplateContainer)element, elementsTO[i].getContainerValue());
                    }
                }
                ++i;
            }
        }
    }

    public static ICardTemplate fillPersonalCardTemplate(ICardTemplate template, String cardname, String surname, String givenname, String emailaddress, String streetaddress, String locality, String stateorprovince, String postalcode, String country, String homephone, String otherphone, String mobilephone, String dateofbirth, String gender, String webpage) {
        if (template != null) {
            ITemplateValue elementCardName = (ITemplateValue)template.getTemplateElementByID("cardName");
            elementCardName.setValue(cardname);
            ITemplateContainer elementClaimList = (ITemplateContainer)template.getTemplateElementByID("claimList");
            ITemplateValue elementSurName = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname");
            elementSurName.setValue(surname);
            ITemplateValue elementGivenName = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname");
            elementGivenName.setValue(givenname);
            ITemplateValue elementEmailAddress = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress");
            elementEmailAddress.setValue(emailaddress);
            ITemplateValue elementStreetAddress = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/streetaddress");
            elementStreetAddress.setValue(streetaddress);
            ITemplateValue elementlocality = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/locality");
            elementlocality.setValue(locality);
            ITemplateValue elementstateorprovince = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/stateorprovince");
            elementstateorprovince.setValue(stateorprovince);
            ITemplateValue elementpostalcode = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/postalcode");
            elementpostalcode.setValue(postalcode);
            ITemplateValue elementcountry = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/country");
            elementcountry.setValue(country);
            ITemplateValue elementhomephone = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/homephone");
            elementhomephone.setValue(homephone);
            ITemplateValue elementotherphone = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/otherphone");
            elementotherphone.setValue(otherphone);
            ITemplateValue elementmobilephone = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/mobilephone");
            elementmobilephone.setValue(mobilephone);
            ITemplateValue elementdateofbirth = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/dateofbirth");
            elementdateofbirth.setValue(dateofbirth);
            ITemplateValue elementgender = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/gender");
            elementgender.setValue(gender);
            ITemplateValue elementwebpage = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/webpage");
            elementwebpage.setValue(webpage);
        }
        return template;
    }

    public static boolean equalsObject(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 != null && obj2 == null || obj1 == null && obj2 != null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public static KeyStore loadKeyStore(String filename) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        FileInputStream is = new FileInputStream(filename);
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        String password = "changeit";
        keystore.load(is, password.toCharArray());
        return keystore;
    }
}

