/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.rpps.core.impl;

import java.security.cert.X509Certificate;
import java.util.Hashtable;
import org.eclipse.higgins.iss.UserChoiceTree;

public class UserInterfaceResponse {
    String _name = "unknown";
    String _addr1 = "unknown";
    String _addr2 = "unknown";
    String _phone = "unknown";
    String _verifier = "unknown";
    UserChoiceTree _ucl = null;

    public void setUCL(UserChoiceTree ucl) {
        this._ucl = ucl;
    }

    public UserChoiceTree getUCL() {
        return this._ucl;
    }

    public void setRequestorInformation(X509Certificate sslCert) {
        if (sslCert == null) {
            return;
        }
        Hashtable t = this.getHashFromX509Name(sslCert.getSubjectX500Principal().getName());
        this._name = this.clean(t.get("CN"));
        this._addr1 = this.clean(t.get("O"));
        String st = this.clean(t.get("ST"));
        this._addr2 = String.valueOf(st.length() > 0 ? String.valueOf(st) + " " : "") + this.clean(t.get("C"));
        t = this.getHashFromX509Name(sslCert.getIssuerX500Principal().getName());
        this._verifier = this.clean(t.get("CN"));
        String vc = this.clean(t.get("C"));
        if (vc.length() > 0) {
            this._verifier = String.valueOf(this._verifier) + " in " + vc;
        }
    }

    public String clean(Object o) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    public Hashtable getHashFromX509Name(String name) {
        Hashtable<String, String> h = new Hashtable<String, String>();
        String[] s = name.split(",");
        if (s != null) {
            int j = 0;
            while (j < s.length) {
                String[] keyval = s[j].split("=");
                if (keyval != null && keyval.length > 1) {
                    h.put(keyval[0], keyval[1]);
                }
                ++j;
            }
        }
        return h;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getAddr1() {
        return this._addr1;
    }

    public void setAddr1(String addr) {
        this._addr1 = addr;
    }

    public String getAddr2() {
        return this._addr2;
    }

    public void setAddr2(String addr) {
        this._addr2 = addr;
    }

    public String getPhone() {
        return this._phone;
    }

    public void setPhone(String phone) {
        this._phone = phone;
    }

    public String getVerifier() {
        return this._verifier;
    }

    public void setVerifier(String verifier) {
        this._verifier = verifier;
    }
}

