/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.rpps.core.rss;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.higgins.rpps.core.impl.RppsService;
import org.eclipse.higgins.rsse.RssFeed;
import org.eclipse.higgins.rsse.RssItem;

public class RssServlet
extends HttpServlet {
    private static final long serialVersionUID = 838906887589824979L;
    private static String rssDir;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (RssServlet.getRssDir() == null || RssServlet.getRssDir().length() == 0) {
            rssDir = String.valueOf(config.getServletContext().getRealPath("")) + "/rss";
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String userId = request.getParameter("userId");
        String password = request.getParameter("password");
        String file = request.getPathInfo();
        if (file.endsWith(".xml")) {
            response.setContentType("text/xml;charset=UTF-8");
        } else {
            response.setContentType("text/html;charset=UTF-8");
        }
        PrintWriter out = response.getWriter();
        File rssFile = new File(String.valueOf(rssDir) + "/" + userId + file);
        if (rssFile.exists()) {
            Object var10_11;
            try {
                String ALIAS = "alias";
                String VALIDATE = "validate";
                RssFeed localFeed = RssFeed.load((File)rssFile);
                List items = localFeed.getItems();
                ArrayList<RssItem> aliasItems = new ArrayList<RssItem>();
                ArrayList<RssItem> validateItems = new ArrayList<RssItem>();
                int i = 0;
                while (true) {
                    if (i >= items.size()) break;
                    RssItem item = (RssItem)items.get(i);
                    if (item.getName().startsWith(ALIAS)) {
                        aliasItems.add(item);
                    } else if (item.getName().startsWith(VALIDATE)) {
                        validateItems.add(item);
                    }
                    ++i;
                }
                i = 0;
                while (true) {
                    if (i >= aliasItems.size()) {
                        localFeed.save(rssFile);
                        break;
                    }
                    RssItem aliasItem = (RssItem)aliasItems.get(i);
                    String index = aliasItem.getName().substring(ALIAS.length());
                    StringTokenizer token = new StringTokenizer(aliasItem.getValue(), ",");
                    String host = token.hasMoreTokens() ? token.nextToken().trim() : "";
                    String username = token.hasMoreTokens() ? token.nextToken().trim() : "";
                    try {
                        if (RppsService.getInstance(userId, password).connectionVerify(host, username)) {
                            int j = 0;
                            while (j < validateItems.size()) {
                                RssItem validateItem = (RssItem)validateItems.get(j);
                                if (validateItem.getName().equals(String.valueOf(VALIDATE) + index)) {
                                    validateItem.setValue("true");
                                }
                                ++j;
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            BufferedReader in = new BufferedReader(new FileReader(rssFile));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    out.println(line);
                }
            }
            catch (Throwable throwable) {
                var10_11 = null;
                in.close();
                throw throwable;
            }
            {
                var10_11 = null;
            }
            in.close();
        }
        out.close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }

    public static String getRssDir() {
        return rssDir;
    }
}

