/*
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Sergei Yakovlev - initial API and implementation
 */

package org.eclipse.higgins.rpps.core.tobj;

import java.io.Serializable;

/**
 * The transfer object for the UserInterfaceResponse. A transfer object is a serializable class that groups related attributes, 
 * forming a composite value. This class is used as the return type of a WS business method.
 * @author Sergei Yakovlev
 */
public class UIResponseTO extends BaseTransferObject implements Serializable {
	
	private static final long serialVersionUID = 7336807528331203756L;
	private String status;
	private UIResponseRPTO rp;
	private UIResponseAndTO[] and;

	/** Creates a new instance of UIResponseTO */
	public UIResponseTO() {
		super();
	}
	
	/**
	 * Gets array of AND elements.
	 * @return the array of AND elements.
	 */
	public UIResponseAndTO[] getAnd() {
		return and;
	}
	
	/**
	 * Sets array of AND elements.
	 * @param and the array of AND elements.
	 */
	public void setAnd(UIResponseAndTO[] and) {
		this.and = and;
	}
	
	/**
	 * Gets RP element.
	 * @return the RP element.
	 */
	public UIResponseRPTO getRP() {
		return rp;
	}
	
	/**
	 * Sets RP element.
	 * @param rp the RP element.
	 */
	public void setRP(UIResponseRPTO rp) {
		this.rp = rp;
	}
	
	/**
	 * Gets STATUS element.
	 * @return the STATUS element.
	 */
	public String getStatus() {
		return status;
	}
	
	/**
	 * Sets STATUS element.
	 * @param status the STATUS element.
	 */
	public void setStatus(String status) {
		this.status = status;
	}
}