/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.rpps.core.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.rmi.AccessException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.utils.Base64;
import org.eclipse.higgins.cache.CacheProviderFactory;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IComplexClaim;
import org.eclipse.higgins.icard.IPersonalInformationCard;
import org.eclipse.higgins.icard.IPolicy;
import org.eclipse.higgins.icard.ISimpleClaim;
import org.eclipse.higgins.icard.ISimpleClaimType;
import org.eclipse.higgins.icard.ITemplateContainer;
import org.eclipse.higgins.icard.ITemplateElement;
import org.eclipse.higgins.icard.ITemplateValue;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.TUID;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.ICredentialDescriptor;
import org.eclipse.higgins.icard.auth.IPasswordCredential;
import org.eclipse.higgins.icard.auth.IPinCodeCredential;
import org.eclipse.higgins.icard.auth.ITSKerberosV5Credential;
import org.eclipse.higgins.icard.auth.ITSSelfIssuedCredential;
import org.eclipse.higgins.icard.auth.ITSUsernamePasswordCredential;
import org.eclipse.higgins.icard.auth.ITSX509V3Credential;
import org.eclipse.higgins.icard.auth.ITokenServiceCredential;
import org.eclipse.higgins.icard.auth.IUsernamePasswordCredential;
import org.eclipse.higgins.icard.common.auth.PinCodeCredential;
import org.eclipse.higgins.icard.common.auth.callback.PinCodeCallback;
import org.eclipse.higgins.icard.io.IFormatDescriptor;
import org.eclipse.higgins.icard.policy.ICardSpacePolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.CardSpacePolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.PPIDCardSpacePolicy;
import org.eclipse.higgins.icard.registry.ICardRegistry;
import org.eclipse.higgins.icard.userprofile.CardCredential;
import org.eclipse.higgins.icard.userprofile.CardUsage;
import org.eclipse.higgins.icard.userprofile.Category;
import org.eclipse.higgins.icard.userprofile.ICardUsageManager;
import org.eclipse.higgins.icard.userprofile.UserProfile;
import org.eclipse.higgins.icard.userprofile.UserProfileAuthenticationException;
import org.eclipse.higgins.icard.userprofile.UserProfileException;
import org.eclipse.higgins.iss.CredentialContainer;
import org.eclipse.higgins.iss.ICardSelectorService;
import org.eclipse.higgins.iss.IICardSelector;
import org.eclipse.higgins.iss.IIdentityToken;
import org.eclipse.higgins.iss.SelectionANDofORs;
import org.eclipse.higgins.iss.SelectionANDofORsElm;
import org.eclipse.higgins.iss.UCTelm;
import org.eclipse.higgins.iss.UserChoiceTree;
import org.eclipse.higgins.iss.UserChoiceTree_ANDofORs;
import org.eclipse.higgins.iss.cardspace.IdentityToken;
import org.eclipse.higgins.iss.cardspace.util.UserProfileTokenHelper;
import org.eclipse.higgins.keystore.IKeyStoreService;
import org.eclipse.higgins.keystore.registry.KeyStoreRegistry;
import org.eclipse.higgins.rpps.core.IRppsService;
import org.eclipse.higgins.rpps.core.RppsException;
import org.eclipse.higgins.rpps.core.impl.CardInformationRPPS;
import org.eclipse.higgins.rpps.core.impl.CategoryComparator;
import org.eclipse.higgins.rpps.core.impl.ConvertHelper;
import org.eclipse.higgins.rpps.core.impl.RppsHelper;
import org.eclipse.higgins.rpps.core.impl.StringComparator;
import org.eclipse.higgins.rpps.core.impl.UserInterfaceResponse;
import org.eclipse.higgins.rpps.core.tobj.CardInformationTO;
import org.eclipse.higgins.rpps.core.tobj.CardUsageTO;
import org.eclipse.higgins.rpps.core.tobj.CategoryTO;
import org.eclipse.higgins.rpps.core.tobj.ExtraTokenResponseTO;
import org.eclipse.higgins.rpps.core.tobj.FormatDescriptorTO;
import org.eclipse.higgins.rpps.core.tobj.ICardResponseTO;
import org.eclipse.higgins.rpps.core.tobj.ICardTO;
import org.eclipse.higgins.rpps.core.tobj.ICardTemplateTO;
import org.eclipse.higgins.rpps.core.tobj.ICardUpdateResponseTO;
import org.eclipse.higgins.rpps.core.tobj.ICardUpdateTO;
import org.eclipse.higgins.rpps.core.tobj.ICardsAndCategoryTO;
import org.eclipse.higgins.rpps.core.tobj.MapTO;
import org.eclipse.higgins.rpps.core.tobj.PropertyTO;
import org.eclipse.higgins.rpps.core.tobj.ResponseMessage;
import org.eclipse.higgins.rpps.core.tobj.TokenResponseTO;
import org.eclipse.higgins.rpps.core.tobj.UIResponseAndTO;
import org.eclipse.higgins.rpps.core.tobj.UIResponseCardTO;
import org.eclipse.higgins.rpps.core.tobj.UIResponseClauseTO;
import org.eclipse.higgins.rpps.core.tobj.UIResponseOrTO;
import org.eclipse.higgins.rpps.core.tobj.UIResponseRPTO;
import org.eclipse.higgins.rpps.core.tobj.UIResponseTO;
import org.eclipse.higgins.rpps.core.tobj.UIResponseUsableCardsTO;
import org.eclipse.higgins.rpps.core.tobj.UITokenServiceCredentialTO;
import org.eclipse.higgins.rpps.core.tobj.UserProfileTO;
import org.eclipse.higgins.sts.api.ISTSResponse;

public class RppsService
implements IRppsService {
    private static Log log;
    protected UserProfile userProfile = null;
    private CallbackHandler handler = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.rpps.core.impl.RppsService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        RppsService.AllowSelfSignedSSL();
    }

    public RppsService() {
    }

    public RppsService(String userId, String password) throws AccessException {
        this.authenticate(userId, password);
    }

    public static IRppsService getInstance() {
        return new RppsService();
    }

    public static IRppsService getInstance(String userId, String password) throws AccessException {
        return new RppsService(userId, password);
    }

    public CallbackHandler getHandler() {
        return this.handler;
    }

    public void setHandler(CallbackHandler handler) {
        this.handler = handler;
    }

    public static String resolveUserIdentifier(String privateSelectorINumber) {
        try {
            return ICardRegistry.getInstance().getUserProfileService().resolveUserIdentifier(privateSelectorINumber);
        }
        catch (UserProfileException e) {
            log.error((Object)e, (Throwable)e);
            return "";
        }
    }

    public void authenticate(String userId, String password) throws AccessException {
        try {
            this.userProfile = ICardRegistry.getInstance().getUserProfileService().getUserProfile(RppsHelper.getCallbackHandler(userId, password));
            if (this.userProfile == null) {
                throw new AccessException("Don't found user profile for userId = <" + userId + ">");
            }
            this.handler = RppsHelper.getCallbackHandler(this.userProfile.getUserIdentifier());
        }
        catch (UserProfileAuthenticationException e) {
            throw new AccessException(e.getMessage(), (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new AccessException(e.getMessage(), e);
        }
    }

    public ICardTO createICard(String id, String[] properties) throws RppsException {
        ICard card = null;
        try {
            card = this.createICard(URI.create(id), RppsHelper.loadProperties(properties));
            return this.convertICard_To_ICardTO(card, false, null);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected ICard createICard(URI id, Properties properties) throws RppsException {
        Iterator it = ICardRegistry.getInstance().getICardProviders();
        while (it.hasNext()) {
            ICardProvider provider = (ICardProvider)it.next();
            if (!provider.canCreateCard(this.getHandler(), id.toString(), properties)) continue;
            try {
                return provider.createCard(this.getHandler(), id.toString(), properties);
            }
            catch (Exception ex) {
                throw new RppsException(ex);
            }
        }
        throw new RppsException("There is not a registered provider for this type of i-card.");
    }

    public ICardTO createICard(ICardTemplateTO template) throws RppsException {
        ICard card = null;
        try {
            ICardTemplate[] templates = this.getICardCreationTemplateByProvider(template.getProviderID());
            card = this.createICard(RppsHelper.fillICardTemplate_from_ICardTemplateTO(templates, template));
            return this.convertICard_To_ICardTO(card, false, null);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected ICard createICard(ICardTemplate template) throws RppsException {
        try {
            if (template != null) {
                String extID = template.getProviderID();
                ICardProvider provider = ICardRegistry.getInstance().getICardProvider(extID);
                if (provider != null && provider.getCardCreationTemplates(this.getHandler()) != null) {
                    try {
                        return provider.createCard(this.getHandler(), template);
                    }
                    catch (Exception ex) {
                        throw new RppsException(ex);
                    }
                }
                throw new RppsException("There is not a registered provider for this id.");
            }
            throw new RppsException("Paramenter <<template>> is null");
        }
        catch (RppsException e) {
            log.error((Object)e, (Throwable)e);
            throw e;
        }
    }

    public ICardTO createDuplicateICard(String cardName, String cuid, String pinCode) throws RppsException {
        ICard card = null;
        try {
            card = this.createDuplicateICard(cardName, new CUID(cuid), pinCode);
            return this.convertICard_To_ICardTO(card, false, null);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected ICard createDuplicateICard(String cardName, CUID cuid, String pinCode) throws RppsException, UserProfileException {
        try {
            ICard card = ICardRegistry.getInstance().getICardByCUID(this.getHandler(), cuid);
            if (!(card instanceof IPersonalInformationCard)) {
                throw new RppsException("You can not create dublicate this card.");
            }
            if (card.getRequiredCredentials() != null && card.getRequiredCredentials().length > 0) {
                PinCodeCredential credential = null;
                if (pinCode != null && pinCode.trim().length() > 0) {
                    credential = new PinCodeCredential();
                    try {
                        credential.setPinCode(pinCode.getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        credential.setPinCode(pinCode.getBytes());
                    }
                } else {
                    CardInformationRPPS cardInformation = this.getCardInformationByCuid(cuid);
                    if (cardInformation != null && cardInformation.getCardCredential() != null) {
                        credential = ConvertHelper.convertCardCredential_to_ICredential(card, cardInformation.getCardCredential());
                    } else {
                        throw new RppsException("Rpps can not retrieve card. You have to send pin code.");
                    }
                }
                card = card.getProvider().getICardByCUID(this.getHandler(), cuid, (ICredential)credential);
            }
            ICardTemplate[] cardTemplates = card.getProvider().getCardCreationTemplates(this.getHandler());
            ICardTemplate cardTemplate = null;
            int i = 0;
            while (i < cardTemplates.length) {
                if (cardTemplates[i].getCardType().isInstance(card)) {
                    cardTemplate = cardTemplates[i];
                    if (cardTemplate.getTemplateElementByID("cardName") != null) {
                        ((ITemplateValue)cardTemplate.getTemplateElementByID("cardName")).setValue(cardName);
                    }
                    if (cardTemplate.getTemplateElementByID("cardPicture") != null && card.getImage() != null) {
                        ((ITemplateValue)cardTemplate.getTemplateElementByID("cardPicture")).setValue(Base64.encode((byte[])card.getImage()));
                    }
                    if (cardTemplate.getTemplateElementByID("claimList") == null) break;
                    Iterator iter = ((ITemplateContainer)cardTemplate.getTemplateElementByID("claimList")).getTemplateElements();
                    while (iter.hasNext()) {
                        ITemplateElement element = (ITemplateElement)iter.next();
                        IClaim claim = card.getClaim(element.getID());
                        if (claim == null || ((ISimpleClaim)claim).getValues().size() <= 0) continue;
                        ((ITemplateValue)element).setValue((String)((ISimpleClaim)claim).getValues().get(0));
                    }
                    break;
                }
                ++i;
            }
            if (cardTemplate != null) {
                return this.createICard(cardTemplate);
            }
        }
        catch (CardException e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        return null;
    }

    public String createICardFromHBX(String cardname) throws RppsException {
        String ret = null;
        try {
            ICardTemplate template = this.getICardCreationTemplateByTUID(new TUID("org.eclipse.higgins.icard.provider.cardspace.personal.db", "PersonalCardTemplate"));
            template = RppsHelper.fillPersonalCardTemplate(template, cardname, "", "", "", "", "", "", "", "", "", "", "", "", "", "");
            ret = this.createICard(template).getCUID().toString();
        }
        catch (Exception e) {
            throw new RppsException(e);
        }
        return ret;
    }

    public ICardTO getICardByCUID(String cuid) throws RppsException {
        try {
            ICard card = this.getICardByCUID(new CUID(cuid));
            return this.convertICard_To_ICardTO(card, false, null);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected ICard getICardByCUID(CUID cuid) throws RppsException {
        try {
            return ICardRegistry.getInstance().getICardByCUID(this.getHandler(), cuid);
        }
        catch (CardException e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public ICardTO getICardByCUIDAndTokenServiceCredential(String cuid, UITokenServiceCredentialTO tokenCredential) throws RppsException {
        try {
            ICard card = this.getICardByCUID(new CUID(cuid));
            if (card == null) {
                throw new RppsException("Can't find card with CUID " + cuid);
            }
            CardInformationRPPS cardInformation = this.getCardInformationByCuid(new CUID(cuid));
            ICredential credential = null;
            if (cardInformation.getCardCredential() != null) {
                credential = ConvertHelper.convertCardCredential_to_ICredential(card, cardInformation.getCardCredential());
            } else if (tokenCredential != null) {
                credential = ConvertHelper.convertUITokenServiceCredentialTO_to_ICredentials(card, tokenCredential);
            }
            if (credential != null) {
                card = card.getProvider().getICardByCUID(this.getHandler(), card.getCUID(), credential);
            }
            return this.convertICard_To_ICardTO(card, true, null);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public UIResponseCardTO getICardClaims(String cuid, String policy, String typeofCredential, String[] credentialKey, String[] credentialValue) throws RppsException {
        try {
            ICard card;
            RppsService.AllowSelfSignedSSL();
            Hashtable<String, String> table = new Hashtable<String, String>();
            int i = 0;
            while (i < credentialKey.length) {
                if (credentialKey[i] != null && credentialValue[i] != null) {
                    table.put(credentialKey[i], credentialValue[i]);
                }
                ++i;
            }
            URI url = null;
            if (table.get("url") != null) {
                String urlStr = (String)table.get("url");
                url = ConvertHelper.convertString_to_URI(urlStr);
            }
            if ((card = this.getICardByCUID(new CUID(cuid))) != null) {
                CardInformationRPPS cardCredentialInfo = this.getCardInformationByCuid(new CUID(cuid));
                ICredential credential = cardCredentialInfo != null && cardCredentialInfo.getCardCredential() != null ? ConvertHelper.convertCardCredential_to_ICredential(card, cardCredentialInfo.getCardCredential()) : ConvertHelper.convertHashtable_to_Credential(card, typeofCredential, table);
                if (credential != null) {
                    card = card.getProvider().getICardByCUID(this.getHandler(), card.getCUID(), credential);
                }
                ICardSpacePolicy policy_ = (ICardSpacePolicy)ICardSelectorService.getInstance().parsePolicy(policy);
                return this.convertICard_To_UIResponseCardTO(card, url, (IPolicy)policy_, cardCredentialInfo);
            }
            throw new RppsException("Didn't find card with cuid=" + cuid);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public ICardResponseTO getICardsByUser() {
        ICardResponseTO cardResponceTO = new ICardResponseTO();
        try {
            List cards = null;
            cards = this.getICardsByUser(this.getHandler());
            if (cards != null) {
                cardResponceTO = this.convertICards_To_CardResponceTO(cards);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return cardResponceTO;
    }

    private ICardResponseTO convertICards_To_CardResponceTO(List cards) {
        ICardResponseTO cardResponceTO;
        ICardTO[] iCardList;
        Hashtable icardMap;
        block7: {
            icardMap = new Hashtable();
            iCardList = new ICardTO[]{};
            cardResponceTO = new ICardResponseTO();
            try {
                if (cards == null) break block7;
                iCardList = new ICardTO[cards.size()];
                int i = 0;
                while (i < cards.size()) {
                    try {
                        ICard card = (ICard)cards.get(i);
                        iCardList[i] = this.convertICard_To_ICardTO(card, false, icardMap);
                    }
                    catch (Exception e) {
                        log.error((Object)e, (Throwable)e);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        ArrayList<MapTO> relationList = new ArrayList<MapTO>();
        if (!icardMap.isEmpty()) {
            Iterator iter = icardMap.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                List value = (List)icardMap.get(key);
                relationList.add(new MapTO(key, value.toArray(new String[value.size()])));
            }
        }
        cardResponceTO.setICardList(iCardList);
        cardResponceTO.setRelationList(relationList.toArray(new MapTO[relationList.size()]));
        return cardResponceTO;
    }

    protected List getICardsByUser(CallbackHandler handler) {
        ArrayList cards = new ArrayList();
        Iterator pit = ICardRegistry.getInstance().getICardProviders();
        while (pit.hasNext()) {
            ICardProvider provider = (ICardProvider)pit.next();
            try {
                Iterator icards = provider.getICards(handler);
                while (icards.hasNext()) {
                    cards.add(icards.next());
                }
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return cards;
    }

    public ICardsAndCategoryTO getICardsAndCategoriesByUser() throws RppsException {
        ICardsAndCategoryTO cardsAndCategoryTO = new ICardsAndCategoryTO();
        try {
            ICardResponseTO cardResponceTO = this.getICardsByUser();
            cardsAndCategoryTO.setRelationList(cardResponceTO.getRelationList());
            cardsAndCategoryTO.setICardList(cardResponceTO.getICardList());
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        try {
            cardsAndCategoryTO.setCategoryList(this.getCategory());
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return cardsAndCategoryTO;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICardTO updateICard(ICardTO icardTO) throws RppsException {
        ICardTO iCardTO;
        ICardUsageManager cardUsageManager = null;
        try {
            try {
                cardUsageManager = ICardRegistry.getInstance().getUserProfileService().getCardUsageManager(this.getHandler());
                iCardTO = this.updateICard(icardTO, cardUsageManager);
                Object var4_4 = null;
                if (cardUsageManager == null) return iCardTO;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                throw new RppsException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (cardUsageManager == null) throw throwable;
            try {
                cardUsageManager.close();
                throw throwable;
            }
            catch (UserProfileException e2) {
                log.error((Object)e2, (Throwable)e2);
                throw throwable;
            }
        }
        try {}
        catch (UserProfileException e2) {
            log.error((Object)e2, (Throwable)e2);
            return iCardTO;
        }
        cardUsageManager.close();
        return iCardTO;
    }

    private ICardTO updateICard(ICardTO icardTO, ICardUsageManager cardUsageManager) throws RppsException {
        ICard card = null;
        try {
            card = this.getICardByCUID(new CUID(icardTO.getCuid()));
            CardInformationRPPS cardInformation = this.getCardInformationByCuid(card.getCUID());
            ICredential credential = null;
            if (cardInformation.getCardCredential() != null) {
                credential = ConvertHelper.convertCardCredential_to_ICredential(card, cardInformation.getCardCredential());
            } else if (icardTO.getTokenServiceCredentials() != null && icardTO.getTokenServiceCredentials().length != 0) {
                credential = ConvertHelper.convertUITokenServiceCredentialTO_to_ICredentials(card, icardTO.getTokenServiceCredentials()[0]);
            }
            if (credential != null) {
                card = card.getProvider().getICardByCUID(this.getHandler(), card.getCUID(), credential);
            }
            card.beginUpdates();
            if (!RppsHelper.equalsObject(card.getName(), icardTO.getName())) {
                card.setName(icardTO.getName());
            }
            try {
                if (!RppsHelper.equalsObject(card.getIssuerName(), icardTO.getIssuerName())) {
                    card.setIssuerName(icardTO.getIssuerName());
                }
            }
            catch (Exception exc) {
                log.error((Object)exc, (Throwable)exc);
            }
            if (!RppsHelper.equalsObject(card.getImageType(), icardTO.getImageType()) || !RppsHelper.equalsObject(card.getImage(), icardTO.getImage())) {
                card.setImage(icardTO.getImage(), icardTO.getImageType());
            }
            if (card instanceof IPersonalInformationCard) {
                try {
                    if (!RppsHelper.equalsObject(card.getTimeExpires(), icardTO.getExpiredTime())) {
                        card.setTimeExpires(icardTO.getExpiredTime());
                    }
                }
                catch (Exception exc) {
                    log.error((Object)exc, (Throwable)exc);
                }
                if (icardTO.getProperties() != null) {
                    int size = icardTO.getProperties().length;
                    int index = 0;
                    while (index < size) {
                        PropertyTO propTO = icardTO.getProperties()[index];
                        IClaim claim = card.getClaim(propTO.getClaimType());
                        if (claim == null) {
                            claim = card.createClaim(propTO.getClaimType());
                        }
                        if (propTO.getComplexValue() == null) {
                            this.setSimpleValues(claim, propTO, cardUsageManager);
                        } else {
                            this.setComplexValues(claim, propTO, cardUsageManager);
                        }
                        ++index;
                    }
                }
            }
            card.applyUpdates();
            card = this.getICardByCUID(new CUID(icardTO.getCuid()));
            return this.convertICard_To_ICardTO(card, false, null);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            try {
                if (card != null && card.isEditMode()) {
                    card.cancelUpdates();
                }
            }
            catch (Throwable throwable) {}
            throw new RppsException(e);
        }
    }

    private void setSimpleValues(IClaim claim, PropertyTO value, ICardUsageManager cardUsageManager) throws Exception {
        if (claim != null && claim instanceof ISimpleClaim && ((ISimpleClaimType)claim.getType()).getDataType().getName().equals(value.getValueType())) {
            ArrayList<String> newValues = new ArrayList<String>();
            int index = 0;
            while (index < value.getValue().length) {
                newValues.add(value.getValue()[index]);
                try {
                    this.addClaimValuesMRU(claim.getType().getType(), value.getValue()[index], cardUsageManager);
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
                ++index;
            }
            ((ISimpleClaim)claim).setValues(newValues);
        }
    }

    private void setComplexValues(IClaim claim, PropertyTO value, ICardUsageManager cardUsageManager) throws Exception {
        if (claim != null && claim instanceof IComplexClaim) {
            int size = value.getComplexValue().length;
            int index = 0;
            while (index < size) {
                PropertyTO propTO = value.getComplexValue()[index];
                IClaim claimValue = ((IComplexClaim)claim).getClaim(propTO.getClaimType());
                if (claimValue == null) {
                    claimValue = ((IComplexClaim)claim).createClaim(propTO.getClaimType());
                }
                if (propTO.getValueType() != null) {
                    this.setSimpleValues(claimValue, propTO, cardUsageManager);
                } else {
                    this.setComplexValues(claimValue, propTO, cardUsageManager);
                }
                ++index;
            }
        }
    }

    public ICardUpdateResponseTO[] updateClaimAcrossCards(String claimType, String claimValue, ICardUpdateTO[] cardUpdate) throws RppsException {
        ICard card = null;
        if (cardUpdate == null) {
            return new ICardUpdateResponseTO[0];
        }
        ICardUpdateResponseTO[] result = new ICardUpdateResponseTO[cardUpdate.length];
        int i = 0;
        while (i < cardUpdate.length) {
            block15: {
                try {
                    card = this.getICardByCUID(new CUID(cardUpdate[i].getCuid()));
                    if (!(card instanceof IPersonalInformationCard)) break block15;
                    CardInformationRPPS cardInformation = this.getCardInformationByCuid(card.getCUID());
                    ICredential credential = null;
                    if (cardInformation.getCardCredential() != null) {
                        credential = ConvertHelper.convertCardCredential_to_ICredential(card, cardInformation.getCardCredential());
                    } else if (cardUpdate[i].getTokenServiceCredential() != null) {
                        credential = ConvertHelper.convertUITokenServiceCredentialTO_to_ICredentials(card, cardUpdate[i].getTokenServiceCredential());
                    }
                    if (credential != null) {
                        card = card.getProvider().getICardByCUID(this.getHandler(), card.getCUID(), credential);
                    }
                    card.beginUpdates();
                    IClaim claim = card.getClaim(claimType);
                    if (claim == null) {
                        claim = card.createClaim(claimType);
                    }
                    if (claim != null && claim instanceof ISimpleClaim) {
                        ArrayList<String> newValues = new ArrayList<String>();
                        newValues.add(claimValue);
                        ((ISimpleClaim)claim).setValues(newValues);
                        try {
                            this.addClaimValuesMRU(claimType, claimValue);
                        }
                        catch (Exception e) {
                            log.error((Object)e, (Throwable)e);
                        }
                    }
                    card.applyUpdates();
                    result[i] = new ICardUpdateResponseTO(card.getCUID().toString());
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                    result[i] = new ICardUpdateResponseTO(-1, e.getMessage());
                    try {
                        if (card != null && card.isEditMode()) {
                            card.cancelUpdates();
                        }
                    }
                    catch (Throwable tr) {
                        log.error((Object)tr, tr);
                    }
                }
            }
            ++i;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MapTO[] getClaimValuesMRU() throws RppsException {
        MapTO[] mapTOArray;
        ICardUsageManager cardUsageManager = null;
        try {
            try {
                cardUsageManager = ICardRegistry.getInstance().getUserProfileService().getCardUsageManager(this.getHandler());
                Map claimValuesMRU = cardUsageManager.getClaimValuesMRU();
                if (claimValuesMRU != null && claimValuesMRU.keySet() != null) {
                    ArrayList<MapTO> result = new ArrayList<MapTO>();
                    Iterator iter = claimValuesMRU.keySet().iterator();
                    while (true) {
                        String[] values;
                        if (!iter.hasNext()) break;
                        MapTO mruTO = new MapTO();
                        String key = (String)iter.next();
                        Set valuesSet = (Set)claimValuesMRU.get(key);
                        if (valuesSet == null || (values = new String[valuesSet.size()]) == null || values.length <= 0) continue;
                        valuesSet.toArray(values);
                        if (values != null) {
                            Arrays.sort(values, new StringComparator());
                        }
                        mruTO.setKey(key);
                        mruTO.setValues(values);
                        result.add(mruTO);
                    }
                    MapTO[] resultMRU = new MapTO[result.size()];
                    result.toArray(resultMRU);
                    MapTO[] mapTOArray2 = resultMRU;
                    Object var9_12 = null;
                    if (cardUsageManager == null) return mapTOArray2;
                    try {
                        cardUsageManager.close();
                        return mapTOArray2;
                    }
                    catch (UserProfileException e2) {
                        log.error((Object)e2, (Throwable)e2);
                    }
                    return mapTOArray2;
                }
                mapTOArray = new MapTO[]{};
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                throw new RppsException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (cardUsageManager == null) throw throwable;
            try {}
            catch (UserProfileException e2) {
                log.error((Object)e2, (Throwable)e2);
                throw throwable;
            }
            cardUsageManager.close();
            throw throwable;
        }
        Object var9_13 = null;
        if (cardUsageManager == null) return mapTOArray;
        try {}
        catch (UserProfileException e2) {
            log.error((Object)e2, (Throwable)e2);
            return mapTOArray;
        }
        cardUsageManager.close();
        return mapTOArray;
    }

    /*
     * Exception decompiling
     */
    public void addClaimValuesMRU(String claimType, String claimValue) throws RppsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 91->95)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addClaimValuesMRU(String claimType, String claimValue, ICardUsageManager cardUsageManager) throws RppsException {
        try {
            Set claimValuesMRU;
            if (claimValue != null && !"".equals(claimValue.trim()) && !(claimValuesMRU = cardUsageManager.getClaimValuesMRU(claimType)).contains(claimValue)) {
                claimValuesMRU.add(claimValue);
                cardUsageManager.setClaimValuesMRU(claimType, claimValuesMRU);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public void removeClaimValuesMRU(String claimType, String claimValue) throws RppsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 122->126)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ICardResponseTO importICards(byte[] crd) throws RppsException {
        return this.importICards(crd, null, null);
    }

    public ICardResponseTO importICards(byte[] crd, String formatID, UITokenServiceCredentialTO credential) throws RppsException {
        try {
            List cards = null;
            cards = this.importICards(new ByteArrayInputStream(crd), formatID, ConvertHelper.convertUITokenServiceCredentialTO_to_ICredentials(credential));
            return this.convertICards_To_CardResponceTO(cards);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected List importICards(InputStream in, String formatID, ICredential credential) throws RppsException {
        try {
            ArrayList result = new ArrayList();
            Iterator iter = ICardRegistry.getInstance().importICards(this.getHandler(), in, formatID, credential);
            while (iter.hasNext()) {
                result.add(iter.next());
            }
            return result;
        }
        catch (CardException e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public FormatDescriptorTO checkImportStream(byte[] crd) throws RppsException {
        try {
            IFormatDescriptor formatDescriptor = ICardRegistry.getInstance().checkInput((InputStream)new ByteArrayInputStream(crd));
            return this.convertIFormatDescriptor_to_FormatDescriptorTO(formatDescriptor);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public byte[] exportICards(String formatID, String[] cards, UITokenServiceCredentialTO credential) throws RppsException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (cards != null && cards.length > 0) {
                CUID[] cuids = new CUID[cards.length];
                int i = 0;
                while (i < cards.length) {
                    cuids[i] = new CUID(cards[i]);
                    ++i;
                }
                ICredential credential_ = ConvertHelper.convertUITokenServiceCredentialTO_to_ICredentials(credential);
                ICardRegistry.getInstance().exportICards(this.getHandler(), (OutputStream)out, formatID, cuids, credential_);
                return out.toByteArray();
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        return null;
    }

    public ICardTO[] getICardsByFormat(String formatID) throws RppsException {
        ICardTO[] icards;
        block10: {
            icards = new ICardTO[]{};
            try {
                ArrayList cards = new ArrayList();
                try {
                    Iterator iter = ICardRegistry.getInstance().getICardsByFormat(this.getHandler(), formatID);
                    while (iter.hasNext()) {
                        try {
                            cards.add(iter.next());
                        }
                        catch (Exception e) {
                            log.error((Object)e, (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
                if (cards == null) break block10;
                icards = new ICardTO[cards.size()];
                int i = 0;
                while (i < cards.size()) {
                    try {
                        icards[i] = this.convertICard_To_ICardTO((ICard)cards.get(i), false, null);
                    }
                    catch (Exception e) {
                        log.error((Object)e, (Throwable)e);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return icards;
    }

    public FormatDescriptorTO[] getOutputFormats() throws RppsException {
        try {
            IFormatDescriptor[] formatDescriptor = ICardRegistry.getInstance().getOutputFormats();
            if (formatDescriptor != null && formatDescriptor.length > 0) {
                FormatDescriptorTO[] formatDescriptorTO = new FormatDescriptorTO[formatDescriptor.length];
                int i = 0;
                while (i < formatDescriptor.length) {
                    formatDescriptorTO[i] = this.convertIFormatDescriptor_to_FormatDescriptorTO(formatDescriptor[i]);
                    ++i;
                }
                return formatDescriptorTO;
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public ICardUpdateResponseTO deleteICard(String cuid) throws RppsException {
        ICard personalCard = null;
        try {
            ICard icard = this.getICardByCUID(new CUID(cuid));
            ICredentialDescriptor[] credDescriptor = icard.getRequiredCredentials();
            if (credDescriptor != null) {
                int i = 0;
                while (i < credDescriptor.length) {
                    if (credDescriptor[i].getCredential() != null && credDescriptor[i].getCredential() instanceof ITSSelfIssuedCredential) {
                        ITSSelfIssuedCredential credential = (ITSSelfIssuedCredential)credDescriptor[i].getCredential();
                        personalCard = this.getICardByPPID(credential.getCertificate(), credential.getPPID(), credential.getAddress());
                    }
                    ++i;
                }
            }
            this.deleteICardOnly(cuid);
        }
        catch (RppsException e) {
            return new ICardUpdateResponseTO(-1, e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return new ICardUpdateResponseTO(-1, e.getMessage());
        }
        if (personalCard != null) {
            return new ICardUpdateResponseTO(personalCard.getCUID().toString());
        }
        return new ICardUpdateResponseTO(0, "");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteICardOnly(String cuid) throws RppsException {
        try {
            CallbackHandler handler = this.getHandler();
            CUID cuid_ = new CUID(cuid);
            ICardRegistry.getInstance().getUserProfileService().clearCardCredential(this.getHandler(), cuid_);
            ICardUsageManager cardUsageManager = null;
            try {
                cardUsageManager = ICardRegistry.getInstance().getUserProfileService().getCardUsageManager(handler);
                cardUsageManager.clearUsedAlwaysURLs(cuid_);
                cardUsageManager.clearCardHistory(cuid_);
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                cardUsageManager.close();
                throw throwable;
            }
            {
                Object var5_9 = null;
            }
            cardUsageManager.close();
            ICardRegistry.getInstance().deleteICard(this.getHandler(), new CUID(cuid));
            return;
        }
        catch (CardException e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        catch (UserProfileException e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public void deleteAllICard() throws RppsException {
        List icards = this.getICardsByUser(this.getHandler());
        Iterator iter = icards.iterator();
        while (iter.hasNext()) {
            this.deleteICardOnly(((ICard)iter.next()).getCUID().toString());
        }
    }

    public UIResponseTO getUserInterface(String url, String target, String sslCert, String policytype, String policy) throws RppsException {
        UserInterfaceResponse uir;
        block11: {
            uir = new UserInterfaceResponse();
            try {
                IICardSelector selector = ICardSelectorService.getInstance().getICardSelector(this.getHandler(), policy);
                uir.setUCL(selector.getUserChoice());
                X509Certificate[] sslCerts = RppsHelper.parseSSLCert(sslCert);
                if (sslCerts == null) break block11;
                X509Certificate cert = null;
                if (sslCerts != null && sslCerts.length > 0) {
                    cert = KeyStoreRegistry.getInstance().getSecurityService().findLeafFromCertificates(sslCerts);
                }
                uir.setRequestorInformation(cert);
                IKeyStoreService securityService = KeyStoreRegistry.getInstance().getSecurityService();
                boolean isValid = false;
                boolean isExtendedValid = false;
                try {
                    sslCerts = securityService.getValidateCertificateChain(this.getHandler(), sslCerts, new URI(url));
                    if (sslCerts != null) {
                        isValid = true;
                    }
                }
                catch (CertificateException e) {
                    log.error((Object)e, (Throwable)e);
                }
                catch (CertStoreException e) {
                    log.error((Object)e, (Throwable)e);
                }
                if (isValid) {
                    isExtendedValid = securityService.extendendValidationCertificateChain(this.getHandler(), sslCerts, new URI(url));
                }
                uir.setValid(isValid);
                uir.setExtendedValid(isExtendedValid);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                throw new RppsException(e);
            }
        }
        UIResponseTO uirto = new UIResponseTO();
        try {
            URI url_ = ConvertHelper.convertString_to_URI(url);
            if (uir != null) {
                uirto.setStatus("ok");
                UIResponseRPTO rp = new UIResponseRPTO();
                rp.setName(uir.getName());
                rp.setAddr1(uir.getAddr1());
                rp.setAddr2(uir.getAddr2());
                rp.setPhone(uir.getPhone());
                rp.setVerifier(uir.getVerifier());
                rp.setValid(uir.isValid());
                rp.setExtendedValid(uir.isExtendedValid());
                uirto.setRP(rp);
                uirto.setAnd(this.getAnds(uir.getUCL(), url_));
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        return uirto;
    }

    protected ICredential getICredentialByPPID(X509Certificate x509cert, String ppid, URI address) throws RppsException {
        ICredentialDescriptor[] der;
        block7: {
            block6: {
                ICard card;
                block5: {
                    try {
                        card = this.getICardByPPID(x509cert, ppid, address);
                        if (card != null) break block5;
                        return null;
                    }
                    catch (Exception e) {
                        log.error((Object)e, (Throwable)e);
                        throw new RppsException(e);
                    }
                }
                der = card.getRequiredCredentials();
                if (der != null) break block6;
                return null;
            }
            if (der.length != 0) break block7;
            return null;
        }
        return der[0].getCredential();
    }

    protected ICard getICardByPPID(X509Certificate x509cert, String ppid, URI address) throws RppsException {
        try {
            byte[] bppid = Base64.decode((String)ppid);
            IKeyStoreService securityService = KeyStoreRegistry.getInstance().getSecurityService();
            X509Certificate[] chainOriginal = new X509Certificate[]{x509cert};
            X509Certificate[] chain = null;
            if (chainOriginal != null) {
                try {
                    chain = securityService.getValidateCertificateChain(this.getHandler(), chainOriginal, address);
                }
                catch (CertificateException e) {
                    log.error((Object)e, (Throwable)e);
                }
                catch (CertStoreException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
            if (chain == null) {
                chain = chainOriginal;
            }
            PPIDCardSpacePolicy policy = new PPIDCardSpacePolicy(chain, securityService.getCertStore(this.getHandler()), bppid);
            IICardSelector selector = ICardSelectorService.getInstance().getICardSelector(this.getHandler(), (IPolicy)policy);
            UserChoiceTree_ANDofORs uct = (UserChoiceTree_ANDofORs)selector.getUserChoice();
            SelectionANDofORs subselection = uct.getDefaultSelection();
            if (subselection.isEmpty()) {
                throw new RppsException("Cannot find the Personal card used to authenticate for this managed card.");
            }
            String cuid = ((SelectionANDofORsElm)subselection.getElements().get(0)).getUUID();
            return this.getICardByCUID(new CUID(cuid));
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public TokenResponseTO getTokenByClaims(String sslCert, String[] claimName, String[] claimValue) throws RppsException {
        try {
            Hashtable<String, String> claimHashtable = new Hashtable<String, String>();
            int i = 0;
            while (i < claimName.length) {
                try {
                    claimHashtable.put(claimName[i], claimValue[i]);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            X509Certificate cert = null;
            X509Certificate[] certChain = RppsHelper.parseSSLCert(sslCert);
            if (certChain != null && certChain.length > 0) {
                cert = KeyStoreRegistry.getInstance().getSecurityService().findLeafFromCertificates(certChain);
            }
            ISTSResponse resp = UserProfileTokenHelper.getToken(cert, claimHashtable);
            IdentityToken itoken = new IdentityToken(resp, Base64.encode((byte[])cert.getEncoded()));
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String tokenAsString = (String)itoken.getAs((Class)clazz);
            return ConvertHelper.createTokenResponse(tokenAsString);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public TokenResponseTO getTokenObject(String policy, String policytype, String sslCert, String[] cuids, String typeofCredential, String[] credentialKey, String[] credentialValue) throws RppsException {
        TokenResponseTO token;
        block11: {
            token = null;
            try {
                ICard card;
                RppsService.AllowSelfSignedSSL();
                Hashtable<String, String> table = new Hashtable<String, String>();
                boolean saveCard = false;
                boolean saveCredential = false;
                String urlStr = null;
                int i = 0;
                while (i < credentialKey.length) {
                    if (credentialKey[i] != null && credentialValue[i] != null) {
                        table.put(credentialKey[i], credentialValue[i]);
                        log.debug((Object)("Put in table key='" + credentialKey[i] + "' with value='" + credentialValue[i] + "'"));
                    }
                    ++i;
                }
                if (table.get("saveCard") != null && "true".equalsIgnoreCase((String)table.get("saveCard"))) {
                    saveCard = true;
                }
                if (table.get("saveCredential") != null && "true".equalsIgnoreCase((String)table.get("saveCredential"))) {
                    saveCredential = true;
                }
                if (table.get("url") != null) {
                    urlStr = (String)table.get("url");
                }
                if (urlStr != null && urlStr.indexOf("?") > -1) {
                    urlStr = urlStr.substring(0, urlStr.indexOf("?"));
                }
                log.debug((Object)("CUID parameter is " + cuids[0]));
                log.debug((Object)("SaveCard parameter is " + Boolean.toString(saveCard)));
                log.debug((Object)("SaveCredential parameter is " + Boolean.toString(saveCredential)));
                log.debug((Object)("Url parameter is " + urlStr));
                URI url = null;
                if (urlStr != null && urlStr.length() > 0) {
                    url = ConvertHelper.convertString_to_URI(urlStr);
                }
                if ((card = this.getICardByCUID(new CUID(cuids[0]))) != null) {
                    CardInformationRPPS cardCredentialInfo = null;
                    CUID cuidUrl = this.getCuidByUrl(url);
                    if (cuidUrl != null && cuidUrl.equals((Object)card.getCUID()) && !saveCard) {
                        this.deleteUrlCardRelation(card.getCUID(), url);
                    }
                    ICredential credential = (cardCredentialInfo = this.getCardInformationByCuid(card.getCUID())) != null && cardCredentialInfo.getCardCredential() != null ? ConvertHelper.convertCardCredential_to_ICredential(card, cardCredentialInfo.getCardCredential()) : ConvertHelper.convertHashtable_to_Credential(card, typeofCredential, table);
                    token = this.getTokenObject(policy, policytype, sslCert, cuids, credential, cardCredentialInfo, url, saveCard, saveCredential);
                    break block11;
                }
                throw new RppsException("Didn't find card with cuid=" + cuids[0]);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                throw new RppsException(e);
            }
        }
        return token;
    }

    protected TokenResponseTO getTokenObject(String policy, String policytype, String sslCert, String[] cuids, ICredential credential, CardInformationRPPS cardCredentialInfo, URI url, boolean saveCard, boolean saveCredential) throws RppsException {
        TokenResponseTO token = null;
        try {
            CUID cuid = new CUID(cuids[0]);
            if (!saveCredential && cardCredentialInfo != null && cardCredentialInfo.getCardCredential() != null) {
                this.clearCardCredential(cuid);
            }
            if ((token = this.getTokenObject(policy, policytype, sslCert, cuids, credential, url)) != null && token.getTkn() != null && token.getTkn().length() > 0) {
                if (url != null) {
                    List claimTypeList;
                    this.addCardHistory(cuid, url);
                    IPolicy iPolicy = ICardSelectorService.getInstance().parsePolicy(policy);
                    if (iPolicy instanceof CardSpacePolicy && (claimTypeList = ((CardSpacePolicy)iPolicy).getOptionalClaims()) != null && claimTypeList.size() > 0) {
                        this.saveUsersChoiceOfOptionalClaims(cuid, url, claimTypeList);
                    }
                }
                if (saveCard && url != null) {
                    this.addUrlCardRelation(cuid, url, cardCredentialInfo);
                }
                if (saveCredential) {
                    CardCredential cardCredential = ConvertHelper.convertICredential_to_CardCredential(credential);
                    this.setCardCredential(cuid, cardCredential);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        return token;
    }

    protected TokenResponseTO getTokenObject(String policy, String policytype, String sslCert, String[] cuids, ICredential credential, URI uri) throws RppsException {
        String token = null;
        IKeyStoreService securityService = KeyStoreRegistry.getInstance().getSecurityService();
        SelectionANDofORs selection = new SelectionANDofORs();
        if (uri != null) {
            selection.action = uri.toString();
        }
        selection.idemix_credential_db_uri = "credentials.db";
        selection.cardspace_credential_db_uri = "infocards.properties";
        selection.publickey_db_uri = "pk.db";
        X509Certificate[] chainOriginal = RppsHelper.parseSSLCert(sslCert);
        X509Certificate[] chain = null;
        if (chainOriginal != null) {
            try {
                chain = securityService.getValidateCertificateChain(this.getHandler(), chainOriginal, uri);
            }
            catch (CertificateException e) {
                log.error((Object)e, (Throwable)e);
            }
            catch (CertStoreException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        if (chain == null) {
            chain = chainOriginal;
        }
        selection.sslCertChain = chain;
        selection.setCredential(credential);
        int i = 0;
        while (i < cuids.length) {
            String uid = cuids[i];
            int ui = 0;
            try {
                if (i < cuids.length - 1) {
                    ui = Integer.parseInt(cuids[++i]);
                }
            }
            catch (Exception ew) {
                ew.printStackTrace();
            }
            SelectionANDofORsElm se = new SelectionANDofORsElm(uid, ui, 0);
            selection.add(se);
            ++i;
        }
        try {
            IICardSelector selector = ICardSelectorService.getInstance().getICardSelector(this.getHandler(), policy);
            IIdentityToken iToken = selector.getIdentityToken(selection);
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            token = (String)iToken.getAs((Class)clazz);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        return ConvertHelper.createTokenResponse(token);
    }

    public TokenResponseTO getTokenByUrl(String policy, String policytype, String sslCert, String url) throws RppsException {
        CUID cuidUrl;
        URI url_;
        TokenResponseTO token;
        block7: {
            token = null;
            url_ = ConvertHelper.convertString_to_URI(url);
            cuidUrl = this.getCuidByUrl(url_);
            if (cuidUrl != null) break block7;
            return null;
        }
        try {
            CardInformationRPPS cardInformation = this.getCardInformationByCuid(cuidUrl);
            if (cardInformation != null) {
                String[] cuids = new String[]{cuidUrl.toString()};
                ICard card = this.getICardByCUID(cuidUrl);
                if (card == null) {
                    new RppsException("Does not find card with cuid " + cuidUrl.toString());
                }
                ICredential credential = null;
                credential = ConvertHelper.convertCardCredential_to_ICredential(card, cardInformation.getCardCredential());
                List optionalClaims = this.getUsersChoiceOfOptionalClaims(card.getCUID(), url_);
                IPolicy iPolicy = ICardSelectorService.getInstance().parsePolicy(policy);
                if (iPolicy instanceof CardSpacePolicy && optionalClaims != null && optionalClaims.size() > 0) {
                    ((CardSpacePolicy)iPolicy).setOptionalClaims(optionalClaims);
                }
                if ((token = this.getTokenObject(policy, policytype, sslCert, cuids, credential, url_)) != null && token.getTkn() != null && token.getTkn().length() > 0 && url_ != null) {
                    this.addCardHistory(card.getCUID(), url_);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return token;
    }

    public ExtraTokenResponseTO getTokenExtraByUrl(String policy, String policytype, String sslCert, String url) throws RppsException {
        CUID cuidUrl;
        URI url_;
        ExtraTokenResponseTO token;
        block7: {
            token = null;
            url_ = ConvertHelper.convertString_to_URI(url);
            cuidUrl = this.getCuidByUrl(url_);
            if (cuidUrl != null) break block7;
            return null;
        }
        try {
            CardInformationRPPS cardCredentialInfo = this.getCardInformationByCuid(cuidUrl);
            if (cardCredentialInfo != null) {
                TokenResponseTO tokenTO;
                String[] cuids = new String[]{cardCredentialInfo.getCuid().toString()};
                ICard card = this.getICardByCUID(cardCredentialInfo.getCuid());
                if (card == null) {
                    new RppsException("Does not find card with cuid " + cardCredentialInfo.getCuid().toString());
                }
                ICredential credential = null;
                credential = ConvertHelper.convertCardCredential_to_ICredential(card, cardCredentialInfo.getCardCredential());
                List optionalClaims = this.getUsersChoiceOfOptionalClaims(card.getCUID(), url_);
                IPolicy iPolicy = ICardSelectorService.getInstance().parsePolicy(policy);
                if (iPolicy instanceof CardSpacePolicy && optionalClaims != null && optionalClaims.size() > 0) {
                    ((CardSpacePolicy)iPolicy).setOptionalClaims(optionalClaims);
                }
                if ((tokenTO = this.getTokenObject(policy, policytype, sslCert, cuids, credential, url_)) != null && tokenTO.getTkn() != null && tokenTO.getTkn().length() > 0 && url_ != null) {
                    this.addCardHistory(card.getCUID(), url_);
                }
                token = new ExtraTokenResponseTO();
                token.setTkn(tokenTO.getTkn());
                token.setCardName(card.getName());
                token.setCardDescription(card.getDescription());
                token.setCardImage(card.getImage());
                token.setCardImageType(card.getImageType());
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return token;
    }

    protected List getICardCreationTemplate(CallbackHandler handler) throws RppsException {
        return ICardRegistry.getInstance().getCardCreationTemplates(handler);
    }

    public ICardTemplateTO[] getICardCreationTemplate() {
        List templates = null;
        templates = this.getICardCreationTemplate(this.getHandler());
        ICardTemplateTO[] telmplateList = new ICardTemplateTO[]{};
        if (templates != null) {
            telmplateList = new ICardTemplateTO[templates.size()];
            int index = 0;
            while (index < templates.size()) {
                telmplateList[index] = ConvertHelper.convertICardTemplate_to_ICardTemplateTO((ICardTemplate)templates.get(index));
                ++index;
            }
        }
        return telmplateList;
    }

    public ICardTemplateTO getICardCreationTemplateByTUID(String tuid) throws RppsException {
        ICardTemplate template = null;
        try {
            template = this.getICardCreationTemplateByTUID(new TUID(tuid));
        }
        catch (CardException e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
        if (template != null) {
            return ConvertHelper.convertICardTemplate_to_ICardTemplateTO(template);
        }
        return null;
    }

    public ICardTemplate getICardCreationTemplateByTUID(TUID tuid) throws CardException {
        return ICardRegistry.getInstance().getCardCreationTemplatesByTUID(this.getHandler(), tuid);
    }

    public ICardTemplate[] getICardCreationTemplateByProvider(String extID) throws RppsException {
        ICardProvider provider = ICardRegistry.getInstance().getICardProvider(extID);
        return provider.getCardCreationTemplates(this.getHandler());
    }

    public ICardTO setPinCode(String cuid, String pinCode) throws RppsException {
        ICard card = null;
        try {
            card = ICardRegistry.getInstance().getICardByCUID(this.getHandler(), cuid);
            if (!(card instanceof IPersonalInformationCard)) {
                new RppsException("This card is not personal");
            }
            card = this.setPinCode((IPersonalInformationCard)card, pinCode.getBytes("UTF-8"));
            return this.convertICard_To_ICardTO(card, false, null);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected ICard setPinCode(IPersonalInformationCard card, byte[] pinCode) throws RppsException {
        try {
            PinCodeCredential pinCodeCredential = new PinCodeCredential();
            try {
                card.beginUpdates();
                pinCodeCredential.setPinCode(pinCode);
                card.setPinCode((IPinCodeCredential)pinCodeCredential);
                card.applyUpdates();
            }
            catch (CardException e) {
                if (card.isEditMode()) {
                    card.cancelUpdates();
                }
                throw new RppsException(e);
            }
            pinCodeCredential = new PinCodeCredential();
            pinCodeCredential.setPinCode(pinCode);
            return card.getProvider().getICardByCUID(this.getHandler(), card.getCUID(), (ICredential)pinCodeCredential);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public ICardTO resetPinCode(String cuid, String oldPinCode) throws RppsException {
        ICard card = null;
        byte[] oldPinCode_ = null;
        try {
            card = this.getICardByCUID(new CUID(cuid));
            if (card == null) {
                throw new RppsException("Can't find card with CUID " + cuid);
            }
            if (!(card instanceof IPersonalInformationCard)) {
                new RppsException("This card is not personal");
            }
            CardInformationRPPS cardInformation = null;
            if (oldPinCode == null) {
                cardInformation = this.getCardInformationByCuid(new CUID(cuid));
                if (cardInformation.getCardCredential() != null && "IPinCodeCredential".equals(cardInformation.getCardCredential().getCredentialType())) {
                    oldPinCode_ = cardInformation.getCardCredential().getPinCode();
                }
            } else {
                oldPinCode_ = oldPinCode.getBytes("UTF-8");
            }
            card = this.resetPinCode((IPersonalInformationCard)card, oldPinCode_);
            if (cardInformation != null) {
                this.clearCardCredential(card.getCUID());
            }
            return this.convertICard_To_ICardTO(card, false, null);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected ICard resetPinCode(IPersonalInformationCard card, byte[] oldPinCode) throws RppsException {
        try {
            PinCodeCredential pinCodeCredential = new PinCodeCredential();
            pinCodeCredential.setPinCode(oldPinCode);
            card = (IPersonalInformationCard)card.getProvider().getICardByCUID(this.getHandler(), card.getCUID(), (ICredential)pinCodeCredential);
            try {
                PinCodeCredential pinCodeCredentialNew = new PinCodeCredential();
                pinCodeCredentialNew.setPinCode(null);
                card.beginUpdates();
                card.setPinCode((IPinCodeCredential)pinCodeCredentialNew);
                card.applyUpdates();
            }
            catch (CardException e) {
                if (card.isEditMode()) {
                    card.cancelUpdates();
                }
                throw new RppsException(e);
            }
            return ICardRegistry.getInstance().getICardByCUID(this.getHandler(), card.getCUID());
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public ICardTO editPinCode(String cuid, String oldPinCode, String newPinCode) throws RppsException {
        ICard card = null;
        byte[] oldPinCode_ = null;
        try {
            card = this.getICardByCUID(new CUID(cuid));
            if (card == null) {
                throw new RppsException("Can't find card with CUID " + cuid);
            }
            if (!(card instanceof IPersonalInformationCard)) {
                new RppsException("This card is not personal");
            }
            CardInformationRPPS cardInformation = null;
            if (oldPinCode == null) {
                cardInformation = this.getCardInformationByCuid(new CUID(cuid));
                if (cardInformation.getCardCredential() != null && "IPinCodeCredential".equals(cardInformation.getCardCredential().getCredentialType())) {
                    oldPinCode_ = cardInformation.getCardCredential().getPinCode();
                }
            } else {
                oldPinCode_ = oldPinCode.getBytes("UTF-8");
            }
            card = this.resetPinCode((IPersonalInformationCard)card, oldPinCode_);
            card = this.setPinCode((IPersonalInformationCard)card, newPinCode.getBytes("UTF-8"));
            if (cardInformation != null) {
                try {
                    if (cardInformation.getCardCredential() != null) {
                        CardCredential cardCredential = cardInformation.getCardCredential();
                        cardCredential.setPinCode(newPinCode.getBytes("UTF-8"));
                        this.setCardCredential(new CUID(cuid), cardCredential);
                    }
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
            return this.convertICard_To_ICardTO(card, false, null);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public void addCardHistory(CUID cuid, URI site) throws UserProfileException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 76->80)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected void clearCardHistory(CUID cuid) throws UserProfileException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 70->74)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean clearCardHistory(String cuid) {
        try {
            this.clearCardHistory(new CUID(cuid));
            List list = this.getCardHistoryLog(new CUID(cuid));
            return list == null || list != null && list.size() == 0;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    private List getCardHistoryLog(CUID cuid) throws UserProfileException {
        List list;
        block4: {
            ICardUsageManager cardUsageManager = null;
            try {
                cardUsageManager = ICardRegistry.getInstance().getUserProfileService().getCardUsageManager(this.getHandler());
                list = cardUsageManager.getCardHistory(cuid);
                Object var4_4 = null;
                if (cardUsageManager == null) break block4;
            }
            catch (Exception e) {
                try {
                    log.error((Object)e, (Throwable)e);
                    throw new RppsException(e);
                }
                catch (Throwable throwable) {
                    block5: {
                        Object var4_5 = null;
                        if (cardUsageManager == null) break block5;
                        cardUsageManager.close();
                    }
                    throw throwable;
                }
            }
            cardUsageManager.close();
        }
        return list;
    }

    public CardUsageTO[] getCardHistoryLog(String cuid, int startFrom, int size, String orderBy, String orderDirection) {
        boolean desc = orderDirection.equalsIgnoreCase("desc");
        String order = "site";
        if ("date".equalsIgnoreCase(orderBy)) {
            order = "date";
        } else if ("site".equalsIgnoreCase(orderBy)) {
            order = "useAlways";
        }
        try {
            List list = this.getCardHistoryLog(new CUID(cuid), startFrom, size, order, desc);
            CardUsageTO[] arrayUsage = new CardUsageTO[list.size()];
            int i = 0;
            while (i < list.size()) {
                CardUsage cardUsage = (CardUsage)list.get(i);
                arrayUsage[i] = ConvertHelper.convertCardUsage_to_CardUsageTO(cardUsage);
                ++i;
            }
            return arrayUsage;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    private List getCardHistoryLog(CUID cuid, int startFrom, int size, String orderBy, boolean desc) throws RppsException, UserProfileException {
        List list;
        block4: {
            ICardUsageManager cardUsageManager = null;
            try {
                cardUsageManager = ICardRegistry.getInstance().getUserProfileService().getCardUsageManager(this.getHandler());
                list = cardUsageManager.getCardHistory(cuid);
                Object var8_8 = null;
                if (cardUsageManager == null) break block4;
            }
            catch (Exception e) {
                try {
                    log.error((Object)e, (Throwable)e);
                    throw new RppsException(e);
                }
                catch (Throwable throwable) {
                    block5: {
                        Object var8_9 = null;
                        if (cardUsageManager == null) break block5;
                        cardUsageManager.close();
                    }
                    throw throwable;
                }
            }
            cardUsageManager.close();
        }
        return list;
    }

    protected List getCardHistory(CUID cuid) throws RppsException, UserProfileException {
        List list;
        block4: {
            ICardUsageManager cardUsageManager = null;
            try {
                cardUsageManager = ICardRegistry.getInstance().getUserProfileService().getCardUsageManager(this.getHandler());
                list = cardUsageManager.getCardUsageSummary(cuid);
                Object var4_4 = null;
                if (cardUsageManager == null) break block4;
            }
            catch (Exception e) {
                try {
                    log.error((Object)e, (Throwable)e);
                    throw new RppsException(e);
                }
                catch (Throwable throwable) {
                    block5: {
                        Object var4_5 = null;
                        if (cardUsageManager == null) break block5;
                        cardUsageManager.close();
                    }
                    throw throwable;
                }
            }
            cardUsageManager.close();
        }
        return list;
    }

    public CardUsageTO[] getCardHistory(String cuid, int startFrom, int size, String orderBy, String orderDirection) {
        boolean desc = orderDirection.equalsIgnoreCase("desc");
        String order = "site";
        if ("date".equalsIgnoreCase(orderBy)) {
            order = "date";
        } else if ("site".equalsIgnoreCase(orderBy)) {
            order = "useAlways";
        }
        try {
            List list = this.getCardHistory(new CUID(cuid), startFrom, size, order, desc);
            CardUsageTO[] arrayUsage = new CardUsageTO[list.size()];
            int i = 0;
            while (i < list.size()) {
                CardUsage cardUsage = (CardUsage)list.get(i);
                arrayUsage[i] = ConvertHelper.convertCardUsage_to_CardUsageTO(cardUsage);
                ++i;
            }
            return arrayUsage;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected List getCardHistory(CUID cuid, int startFrom, int size, String orderBy, boolean desc) throws RppsException, UserProfileException {
        List list;
        block4: {
            ICardUsageManager cardUsageManager = null;
            try {
                cardUsageManager = ICardRegistry.getInstance().getUserProfileService().getCardUsageManager(this.getHandler());
                list = cardUsageManager.getCardUsageSummary(cuid, startFrom, size, orderBy, desc);
                Object var8_8 = null;
                if (cardUsageManager == null) break block4;
            }
            catch (Exception e) {
                try {
                    log.error((Object)e, (Throwable)e);
                    throw new RppsException(e);
                }
                catch (Throwable throwable) {
                    block5: {
                        Object var8_9 = null;
                        if (cardUsageManager == null) break block5;
                        cardUsageManager.close();
                    }
                    throw throwable;
                }
            }
            cardUsageManager.close();
        }
        return list;
    }

    private List getUsedCards(URI url) throws RppsException, UserProfileException {
        List list;
        block4: {
            ICardUsageManager cardUsageManager = null;
            try {
                cardUsageManager = ICardRegistry.getInstance().getUserProfileService().getCardUsageManager(this.getHandler());
                list = cardUsageManager.getUsedCards(url);
                Object var4_4 = null;
                if (cardUsageManager == null) break block4;
            }
            catch (Exception e) {
                try {
                    log.error((Object)e, (Throwable)e);
                    throw new RppsException(e);
                }
                catch (Throwable throwable) {
                    block5: {
                        Object var4_5 = null;
                        if (cardUsageManager == null) break block5;
                        cardUsageManager.close();
                    }
                    throw throwable;
                }
            }
            cardUsageManager.close();
        }
        return list;
    }

    /*
     * Exception decompiling
     */
    private void saveUsersChoiceOfOptionalClaims(CUID cuid, URI site, List claims) throws UserProfileException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 92->96)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List getUsersChoiceOfOptionalClaims(CUID cuid, URI site) throws UserProfileException {
        ArrayList arrayList;
        block4: {
            Object cardUsageManager = null;
            try {
                Set optionalClaims = cardUsageManager.getOptionalClaims(cuid, site);
                arrayList = new ArrayList(optionalClaims);
                Object var5_7 = null;
                if (cardUsageManager == null) break block4;
            }
            catch (Exception e) {
                try {
                    log.error((Object)e, (Throwable)e);
                    throw new RppsException(e);
                }
                catch (Throwable throwable) {
                    block5: {
                        Object var5_8 = null;
                        if (cardUsageManager == null) break block5;
                        cardUsageManager.close();
                    }
                    throw throwable;
                }
            }
            cardUsageManager.close();
        }
        return arrayList;
    }

    public CategoryTO[] getCategory() throws RppsException {
        try {
            List category = this.getCategories(this.getHandler());
            CategoryTO[] categorysTO = new CategoryTO[]{};
            if (category != null) {
                categorysTO = new CategoryTO[category.size()];
                int i = 0;
                while (i < category.size()) {
                    categorysTO[i] = ConvertHelper.convertCategory_to_CategoryTO((Category)category.get(i));
                    ++i;
                }
            }
            return categorysTO;
        }
        catch (RppsException e) {
            log.error((Object)e, (Throwable)e);
            throw e;
        }
    }

    protected List getCategories(CallbackHandler handler) throws RppsException {
        try {
            List list = ICardRegistry.getInstance().getUserProfileService().getCategories(handler);
            Collections.sort(list, new CategoryComparator());
            return list;
        }
        catch (UserProfileException e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public CategoryTO addCategory(CategoryTO categoryTO) throws RppsException {
        try {
            Category category = ICardRegistry.getInstance().getUserProfileService().addCategory(this.getHandler(), ConvertHelper.convertCategoryTO_to_Category(categoryTO));
            return ConvertHelper.convertCategory_to_CategoryTO(category);
        }
        catch (UserProfileException e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public void deleteCategory(String categoryId) throws RppsException {
        try {
            ICardRegistry.getInstance().getUserProfileService().deleteCategory(this.getHandler(), categoryId);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public CategoryTO modifyCategory(CategoryTO categoryTO) throws RppsException {
        try {
            Category category = ICardRegistry.getInstance().getUserProfileService().modifyCategory(this.getHandler(), ConvertHelper.convertCategoryTO_to_Category(categoryTO));
            return ConvertHelper.convertCategory_to_CategoryTO(category);
        }
        catch (UserProfileException e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public ResponseMessage modifyCategories(CategoryTO[] categoriesTO) throws RppsException {
        try {
            int i = 0;
            while (i < categoriesTO.length) {
                ICardRegistry.getInstance().getUserProfileService().modifyCategory(this.getHandler(), ConvertHelper.convertCategoryTO_to_Category(categoriesTO[i]));
                ++i;
            }
            return new ResponseMessage(0, "");
        }
        catch (UserProfileException e) {
            log.error((Object)e, (Throwable)e);
            return new ResponseMessage(-1, e.getMessage());
        }
    }

    public UserProfileTO getUserProfile() throws RppsException, AccessException {
        UserProfile userProfile = this.getUserProfile(this.getHandler());
        return ConvertHelper.convertUserProfile_to_UserProfileTO(userProfile);
    }

    private UserProfile getUserProfile(CallbackHandler handler) throws RppsException, AccessException {
        try {
            if (this.userProfile == null) {
                this.userProfile = ICardRegistry.getInstance().getUserProfileService().getUserProfile(handler);
            }
            return this.userProfile;
        }
        catch (UserProfileAuthenticationException e) {
            log.error((Object)e, (Throwable)e);
            throw new AccessException(e.getMessage(), (Exception)((Object)e));
        }
        catch (UserProfileException e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e.getMessage(), e);
        }
    }

    public void addUserProfileFromHBX(String userId, String password) throws RppsException {
        UserProfileTO userProfile = new UserProfileTO();
        userProfile.setLoginName(userId);
        userProfile.setPassword(password);
        ResponseMessage responseMessage = this.addUserProfile(userProfile);
        if (responseMessage.getCode() != 0) {
            throw new RppsException(responseMessage.getMessage());
        }
    }

    public ResponseMessage addUserProfile(UserProfileTO userProfile) throws RppsException {
        try {
            CallbackHandler handler = RppsHelper.getCallbackHandler(userProfile.getLoginName(), userProfile.getPassword());
            ICardRegistry.getInstance().getUserProfileService().addUserProfile(handler, ConvertHelper.convertUserProfileTO_to_UserProfile(userProfile));
            return new ResponseMessage(0);
        }
        catch (UserProfileException e) {
            log.error((Object)e, (Throwable)e);
            return new ResponseMessage(-1, e.getMessage());
        }
    }

    public ResponseMessage deleteUserProfile() throws RppsException {
        try {
            this.deleteUserProfile(this.getHandler());
            return new ResponseMessage(0);
        }
        catch (RppsException e) {
            log.error((Object)e, (Throwable)e);
            return new ResponseMessage(-1, e.getMessage());
        }
    }

    protected void deleteUserProfile(CallbackHandler handler) throws RppsException {
        try {
            this.deleteAllICard();
            ICardRegistry.getInstance().getUserProfileService().deleteUserProfile(handler);
        }
        catch (UserProfileException e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public boolean userIdentifierExists(String userIdentifier) {
        try {
            return ICardRegistry.getInstance().getUserProfileService().userIdentifierExists(userIdentifier);
        }
        catch (UserProfileException userProfileException) {
            return false;
        }
    }

    public UserProfileTO modifyUserProfile(UserProfileTO userProfile) throws RppsException {
        try {
            this.userProfile = ICardRegistry.getInstance().getUserProfileService().modifyUserProfile(this.getHandler(), ConvertHelper.convertUserProfileTO_to_UserProfile(userProfile));
            return this.getUserProfile();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public CardInformationTO getCardInformation(String cuid, int size) throws RppsException {
        try {
            List cardHistory = this.getCardHistory(new CUID(cuid));
            int sizeAll = 0;
            if (cardHistory != null) {
                sizeAll = cardHistory.size();
            }
            cardHistory = this.getCardHistory(new CUID(cuid), 0, size, "date", false);
            return ConvertHelper.createCardInformationTO(cardHistory, sizeAll);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected CUID getCuidByUrl(URI url) throws RppsException, UserProfileException {
        CUID cUID;
        block4: {
            ICardUsageManager cardUsageManager = null;
            try {
                cardUsageManager = ICardRegistry.getInstance().getUserProfileService().getCardUsageManager(this.getHandler());
                cUID = cardUsageManager.getUsedAlwaysCard(url);
                Object var4_4 = null;
                if (cardUsageManager == null) break block4;
            }
            catch (Exception e) {
                try {
                    log.error((Object)e, (Throwable)e);
                    throw new RppsException(e);
                }
                catch (Throwable throwable) {
                    block5: {
                        Object var4_5 = null;
                        if (cardUsageManager == null) break block5;
                        cardUsageManager.close();
                    }
                    throw throwable;
                }
            }
            cardUsageManager.close();
        }
        return cUID;
    }

    /*
     * Exception decompiling
     */
    protected CardInformationRPPS getCardInformationByCuid(CUID cuid) throws RppsException, UserProfileException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 165->168)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ICardTO clearCardCredential(String cuid) throws RppsException {
        try {
            this.clearCardCredential(new CUID(cuid));
            return this.getICardByCUID(cuid);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected void clearCardCredential(CUID cuid) throws RppsException {
        try {
            ICardRegistry.getInstance().getUserProfileService().clearCardCredential(this.getHandler(), cuid);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    public boolean setCardCredential(String cuid, UITokenServiceCredentialTO tokenCredential) throws RppsException {
        block5: {
            try {
                ICard card = this.getICardByCUID(new CUID(cuid));
                if (card == null) {
                    throw new RppsException("Can't find card with CUID " + cuid);
                }
                ICredential credential = ConvertHelper.convertUITokenServiceCredentialTO_to_ICredentials(card, tokenCredential);
                ICardProvider provider = card.getProvider();
                card = null;
                if (credential != null) {
                    card = provider.getICardByCUID(this.getHandler(), new CUID(cuid), credential);
                }
                if (card == null) break block5;
                CardCredential cardCredential = ConvertHelper.convertUITokenServiceCredentialTO_to_CardCredential(tokenCredential);
                boolean result = this.setCardCredential(new CUID(cuid), cardCredential);
                return result;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                throw new RppsException(e.getMessage(), e);
            }
        }
        throw new RppsException("Didn't set card credential.");
    }

    protected boolean setCardCredential(CUID cuid, CardCredential cardCredential) throws RppsException {
        try {
            CardInformationRPPS cardInformation = new CardInformationRPPS(ICardRegistry.getInstance().getUserProfileService().setCardCredential(this.getHandler(), cuid, cardCredential));
            return cardInformation.getCardCredential() != null && cardCredential != null || cardInformation.getCardCredential() == null && cardCredential == null;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    /*
     * Exception decompiling
     */
    protected void addUrlCardRelation(CUID cuid, URI url, CardInformationRPPS cardInformation) throws RppsException, UserProfileException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 139->143)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean deleteUrlCardRelation(String cuid, String url) throws RppsException {
        try {
            if (url != null) {
                this.deleteUrlCardRelation(new CUID(cuid), new URI(url));
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RppsException(e);
        }
    }

    protected CardUsage deleteUrlCardRelation(CUID cuid, URI url) throws RppsException, UserProfileException {
        CardUsage cardUsage;
        block4: {
            ICardUsageManager cardUsageManager = null;
            try {
                cardUsageManager = ICardRegistry.getInstance().getUserProfileService().getCardUsageManager(this.getHandler());
                cardUsage = cardUsageManager.deleteUsedAlways(cuid, url);
                Object var5_5 = null;
                if (cardUsageManager == null) break block4;
            }
            catch (Exception e) {
                try {
                    log.error((Object)e, (Throwable)e);
                    throw new RppsException(e);
                }
                catch (Throwable throwable) {
                    block5: {
                        Object var5_6 = null;
                        if (cardUsageManager == null) break block5;
                        cardUsageManager.close();
                    }
                    throw throwable;
                }
            }
            cardUsageManager.close();
        }
        return cardUsage;
    }

    public static void AllowSelfSignedSSL() {
        if (Security.getProvider("Dummy") == null) {
            Security.insertProviderAt(new DummySecurityProvider(), 2);
            Security.setProperty("ssl.TrustManagerFactory.algorithm", DummyTrustManagerFactory.getAlgorithm());
        }
    }

    public String getHigginsServiceGlobalIName() {
        return System.getProperty("higgins.service.global.name", "=parity");
    }

    protected UIResponseAndTO[] getAnds(UserChoiceTree uct, URI url) throws RppsException, UserProfileException {
        ArrayList<UIResponseAndTO> andList = new ArrayList<UIResponseAndTO>();
        if (uct != null) {
            ListIterator li = uct.getListIterator();
            while (li.hasNext()) {
                Object child = li.next();
                UIResponseAndTO and = new UIResponseAndTO();
                if (child instanceof UserChoiceTree) {
                    ArrayList<UIResponseOrTO> orList = new ArrayList<UIResponseOrTO>();
                    ListIterator li2 = ((UserChoiceTree)child).getListIterator();
                    while (li2.hasNext()) {
                        Object child2 = li2.next();
                        UIResponseOrTO or = new UIResponseOrTO();
                        if (child2 instanceof UserChoiceTree) {
                            ArrayList<UIResponseAndTO> andList2 = new ArrayList<UIResponseAndTO>();
                            ListIterator li3 = ((UserChoiceTree)child2).getListIterator();
                            while (li3.hasNext()) {
                                Object child3 = li3.next();
                                UIResponseAndTO and2 = new UIResponseAndTO();
                                boolean cfr_ignored_0 = child3 instanceof UCTelm;
                                andList2.add(and2);
                            }
                        } else if (child2 instanceof UCTelm) {
                            IPolicy atom = ((UCTelm)child2).getAtom();
                            UIResponseClauseTO clause = new UIResponseClauseTO();
                            if (atom instanceof ICardSpacePolicy) {
                                ICardSpacePolicy icp = (ICardSpacePolicy)atom;
                                clause.setLabel(icp.getSummary());
                                clause.setLonglabel(icp.getSummary().toString());
                                List requiredClaims = icp.getRequiredClaims();
                                String[] summary = new String[requiredClaims.size()];
                                ListIterator iter = requiredClaims.listIterator();
                                int i = 0;
                                while (iter.hasNext()) {
                                    summary[i++] = iter.next().toString();
                                }
                                clause.setLabelType(summary);
                                clause.setOptional(icp.getOptionalClaimSummary());
                                clause.setLongOptional(icp.getOptionalClaimSummary().toString());
                                List optionalClaims = icp.getOptionalClaims();
                                summary = new String[optionalClaims.size()];
                                iter = optionalClaims.listIterator();
                                i = 0;
                                while (iter.hasNext()) {
                                    summary[i++] = iter.next().toString();
                                }
                                clause.setOptionalType(summary);
                            } else {
                                clause.setLabel(atom.getSummary());
                                clause.setLonglabel(atom.getSummary().toString());
                                clause.setLabelType(new String[0]);
                            }
                            UIResponseUsableCardsTO uc = new UIResponseUsableCardsTO();
                            ArrayList<UIResponseCardTO> cardList = new ArrayList<UIResponseCardTO>();
                            Iterator it = ((UCTelm)child2).getCredsIterator();
                            while (it != null && it.hasNext()) {
                                URI[] urls;
                                UIResponseCardTO card = new UIResponseCardTO();
                                CredentialContainer cc = (CredentialContainer)it.next();
                                ICard cred = cc.getCredential();
                                CardInformationRPPS cardInformation = this.getCardInformationByCuid(cred.getCUID());
                                card = this.convertICard_To_UIResponseCardTO(cred, url, atom, cardInformation);
                                card.setUid(cc.key);
                                if (cardInformation != null && (urls = cardInformation.getUris()) != null) {
                                    int i = 0;
                                    while (i < urls.length) {
                                        if (urls[i].equals(url)) {
                                            card.setSaveCard(true);
                                        }
                                        ++i;
                                    }
                                }
                                cardList.add(card);
                            }
                            UIResponseCardTO[] cards = new UIResponseCardTO[cardList.size()];
                            cardList.toArray(cards);
                            uc.setCard(cards);
                            clause.setUsableCards(uc);
                            List usedCard = this.getUsedCards(url);
                            String[] usedCardCuids = new String[usedCard.size()];
                            int index = 0;
                            while (index < usedCard.size()) {
                                usedCardCuids[index] = ((CardUsage)usedCard.get(index)).getCuid().toString();
                                ++index;
                            }
                            clause.setUsedCardCuids(usedCardCuids);
                            or.setClause(clause);
                        }
                        orList.add(or);
                    }
                    UIResponseOrTO[] ors = new UIResponseOrTO[orList.size()];
                    orList.toArray(ors);
                    and.setOr(ors);
                } else {
                    boolean cfr_ignored_1 = child instanceof UCTelm;
                }
                andList.add(and);
            }
        }
        UIResponseAndTO[] ands = new UIResponseAndTO[andList.size()];
        andList.toArray(ands);
        return ands;
    }

    protected UITokenServiceCredentialTO[] convertICredentials_to_UITokenServiceCredentialTO(ICard card, CardCredential cardCredential, Map icardMap) {
        ICredentialDescriptor[] der;
        ArrayList<UITokenServiceCredentialTO> credList = new ArrayList<UITokenServiceCredentialTO>();
        if (card != null && (der = card.getRequiredCredentials()) != null) {
            int i = 0;
            while (i < der.length) {
                ICredential credential = der[i].getCredential();
                UITokenServiceCredentialTO credentialTO = this.convertICredentials_to_UITokenServiceCredentialTO(credential, icardMap, card);
                if (credentialTO != null) {
                    if (cardCredential != null && credentialTO.getType().equals(cardCredential.getCredentialType())) {
                        credentialTO.setSaveCredential(true);
                    }
                    credList.add(credentialTO);
                }
                ++i;
            }
        }
        UITokenServiceCredentialTO[] array = new UITokenServiceCredentialTO[credList.size()];
        credList.toArray(array);
        return array;
    }

    protected UITokenServiceCredentialTO convertICredentials_to_UITokenServiceCredentialTO(ICredential credential, Map icardMap, ICard icard) {
        UITokenServiceCredentialTO tokenService;
        block27: {
            tokenService = null;
            if (credential != null) {
                tokenService = new UITokenServiceCredentialTO();
                if (credential instanceof ITokenServiceCredential) {
                    tokenService.setAddress(((ITokenServiceCredential)credential).getAddress().toString());
                    tokenService.setMetadataAddress(((ITokenServiceCredential)credential).getMetadataAddress().toString());
                    if (credential instanceof ITSUsernamePasswordCredential) {
                        tokenService.setPassword(((ITSUsernamePasswordCredential)credential).getPassword());
                        tokenService.setUsername(((ITSUsernamePasswordCredential)credential).getUsername());
                        tokenService.setType("ITSUsernamePasswordCredential");
                    } else if (credential instanceof ITSSelfIssuedCredential) {
                        tokenService.setType("ITSSelfIssuedNonPinCredential");
                        try {
                            ICard personalCard = this.getICardByPPID(((ITSSelfIssuedCredential)credential).getCertificate(), ((ITSSelfIssuedCredential)credential).getPPID(), ((ITSSelfIssuedCredential)credential).getAddress());
                            if (personalCard == null) {
                                throw new RppsException("Cannot find the Personal card used to authenticate for this managed card.");
                            }
                            if (icardMap != null && icard != null) {
                                List<String> relationCUIDs = null;
                                if (icardMap.containsKey(personalCard.getCUID().toString())) {
                                    relationCUIDs = (List)icardMap.get(personalCard.getCUID().toString());
                                }
                                if (relationCUIDs == null) {
                                    relationCUIDs = new ArrayList();
                                }
                                if (!relationCUIDs.contains(icard.getCUID().toString())) {
                                    relationCUIDs.add(icard.getCUID().toString());
                                }
                                icardMap.put(personalCard.getCUID().toString(), relationCUIDs);
                            }
                            tokenService.setAssociatedCardName(personalCard.getName());
                            tokenService.setAssociatedCardImage(personalCard.getImage());
                            tokenService.setAssociatedCardImageType(personalCard.getDescription());
                            tokenService.setAssociatedCardDescription(personalCard.getDescription());
                            ICredential subCredential = null;
                            ICredentialDescriptor[] derPersonal = personalCard.getRequiredCredentials();
                            if (derPersonal != null && derPersonal.length > 0) {
                                subCredential = derPersonal[0].getCredential();
                            }
                            if (subCredential == null) break block27;
                            int index = 0;
                            while (index < subCredential.getCallbacks().length) {
                                if (subCredential.getCallbacks()[index] instanceof PinCodeCallback) {
                                    tokenService.setType("ITSSelfIssuedCredential");
                                    break;
                                }
                                ++index;
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)e, (Throwable)e);
                        }
                    } else if (credential instanceof ITSKerberosV5Credential) {
                        tokenService.setType("ITSKerberosV5Credential");
                    } else if (credential instanceof ITSX509V3Credential) {
                        tokenService.setType("ITSX509V3Credential");
                    } else {
                        tokenService = null;
                    }
                } else if (credential instanceof IPinCodeCredential) {
                    tokenService.setType("IPinCodeCredential");
                } else if (credential instanceof IUsernamePasswordCredential) {
                    tokenService.setType("IUsernamePasswordCredential");
                    tokenService.setUsername(((IUsernamePasswordCredential)credential).getUsername());
                } else if (credential instanceof IPasswordCredential) {
                    tokenService.setType("IPasswordCredential");
                } else {
                    tokenService = null;
                }
            }
        }
        return tokenService;
    }

    protected UIResponseCardTO convertICard_To_UIResponseCardTO(ICard icard, URI url, IPolicy policy, CardInformationRPPS cardInformation) {
        UIResponseCardTO cardTO = new UIResponseCardTO();
        if (icard != null) {
            URI[] urls;
            cardTO.setUid(icard.getCUID().toString());
            String nm = icard.getName();
            int k = nm.lastIndexOf(47);
            nm = k > 0 ? nm.substring(k + 1) : nm;
            cardTO.setName(nm);
            cardTO.setDescription(icard.getDescription());
            cardTO.setImage(icard.getImage());
            cardTO.setImagetype(icard.getImageType());
            List supportedClaimTypeList = icard.getSupportedClaimTypesUris();
            if (supportedClaimTypeList != null && supportedClaimTypeList.size() > 0) {
                String[] supportedClaimType = new String[supportedClaimTypeList.size()];
                supportedClaimTypeList.toArray(supportedClaimType);
                cardTO.setSupportedClaimTypes(supportedClaimType);
            }
            UITokenServiceCredentialTO[] tokenservices = this.convertICredentials_to_UITokenServiceCredentialTO(icard, cardInformation != null ? cardInformation.getCardCredential() : null, null);
            cardTO.setTokenservices(tokenservices);
            if (cardInformation != null && (urls = cardInformation.getUris()) != null) {
                int i = 0;
                while (i < urls.length) {
                    if (urls[i].equals(url)) {
                        cardTO.setSaveCard(true);
                    }
                    ++i;
                }
            }
            if (policy instanceof ICardSpacePolicy) {
                ICardSpacePolicy policyCS = (ICardSpacePolicy)policy;
                try {
                    if (policyCS.getRequiredClaims() != null && policyCS.getRequiredClaims().size() > 0) {
                        cardTO.setProperties(ConvertHelper.convertClaims_to_PropertyTO(icard, false, policyCS.getRequiredClaims().iterator()));
                    }
                    if (policyCS.getOptionalClaims() != null && policyCS.getOptionalClaims().size() > 0) {
                        cardTO.setOptionalClaims(ConvertHelper.convertClaims_to_PropertyTO(icard, false, policyCS.getOptionalClaims().iterator()));
                    }
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
            } else {
                try {
                    if (policy.getSummary() != null && policy.getSummary().length > 0) {
                        cardTO.setProperties(ConvertHelper.convertClaims_to_PropertyTO(icard, false, Arrays.asList(policy.getSummary()).iterator()));
                    }
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
        return cardTO;
    }

    protected ICardTO convertICard_To_ICardTO(ICard card, boolean isCatchAuthentication, Map icardMap) throws CardException, InvalidTypeException, RppsException, UserProfileException {
        ICardTO icard = new ICardTO();
        if (card != null) {
            UITokenServiceCredentialTO[] tokenServiceCredentials;
            icard.setId(card.getID());
            icard.setCuid(card.getCUID().toString());
            icard.setName(card.getName());
            icard.setIssuerName(card.getIssuerName());
            icard.setImage(card.getImage());
            icard.setImageType(card.getImageType());
            icard.setSelfIssued(card.isSelfIssued());
            icard.setType(card.getType());
            if ("IPersonalInformationCard".equals(card.getType())) {
                icard.setDeleteable(false);
            }
            CardCredential cardCredential = null;
            CardInformationRPPS cardInformation = this.getCardInformationByCuid(card.getCUID());
            if (cardInformation != null) {
                cardCredential = cardInformation.getCardCredential();
            }
            if ((tokenServiceCredentials = this.convertICredentials_to_UITokenServiceCredentialTO(card, cardCredential, icardMap)).length > 0) {
                icard.setTokenServiceCredentials(tokenServiceCredentials);
            }
            icard.setProperties(ConvertHelper.convertClaims_to_PropertyTO(card, isCatchAuthentication, card.getSupportedClaimTypes()));
        }
        return icard;
    }

    protected FormatDescriptorTO convertIFormatDescriptor_to_FormatDescriptorTO(IFormatDescriptor descriptor) {
        FormatDescriptorTO descriptorTO = null;
        if (descriptor != null) {
            descriptorTO = new FormatDescriptorTO();
            descriptorTO.setFormatID(descriptor.getID());
            descriptorTO.setName(descriptor.getDescription());
            descriptorTO.setFileExtension(descriptor.getFileExtension());
            if (descriptor.getCredentialDescriptor() != null && descriptor.getCredentialDescriptor().getCredential() != null) {
                UITokenServiceCredentialTO credential = this.convertICredentials_to_UITokenServiceCredentialTO(descriptor.getCredentialDescriptor().getCredential(), null, null);
                descriptorTO.setCredential(credential);
            }
        }
        return descriptorTO;
    }

    public static synchronized void ConfigureCache(String configurationBase, String configurationFile) {
        CacheProviderFactory.setConfigurationBase((String)configurationBase);
        CacheProviderFactory.setFileName((String)configurationFile);
        CacheProviderFactory.getCacheProvider();
    }

    static final class DummySecurityProvider
    extends Provider {
        private static final long serialVersionUID = 594145003249139851L;

        public DummySecurityProvider() {
            super("Dummy", 1.0, "");
            AccessController.doPrivileged(new PrivilegedAction(this){
                final /* synthetic */ DummySecurityProvider this$1;
                {
                    this.this$1 = dummySecurityProvider;
                }

                public Object run() {
                    String string = "TrustManagerFactory." + DummyTrustManagerFactory.getAlgorithm();
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.higgins.rpps.core.impl.RppsService$DummyTrustManagerFactory");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    this.this$1.put(string, clazz.getName());
                    return null;
                }
            });
        }
    }

    public static final class DummyTrustManagerFactory
    extends TrustManagerFactorySpi {
        public static String getAlgorithm() {
            return "XTrust509";
        }

        protected void engineInit(KeyStore keystore) throws KeyStoreException {
        }

        protected TrustManager[] engineGetTrustManagers() {
            return new TrustManager[]{new X509TrustManager(this){
                final /* synthetic */ DummyTrustManagerFactory this$1;
                {
                    this.this$1 = dummyTrustManagerFactory;
                }

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    int i = 0;
                    while (i < certs.length) {
                        System.out.println("  >>> Checking certificate " + certs[i]);
                        ++i;
                    }
                }
            }};
        }

        protected void engineInit(ManagerFactoryParameters arg0) throws InvalidAlgorithmParameterException {
        }
    }
}

