/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Artem Verhovets - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.rpps.core.tobj;

import java.io.Serializable;


public class ResponseMessage implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 8603714779703505244L;
	
	public static final int noError=0;
	public static final int unknownError=-1;
	
	private int code;
	private String message;
	
	public ResponseMessage()
	{		
	}
	
	public ResponseMessage(int code)
	{		
		setCode(code);
	}
	
	public ResponseMessage(int code,String message)
	{
		this(code);
		setMessage(message);
	}
	
	public int getCode() {
		return code;
	}

	public void setCode(int code) {
		this.code = code;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}
}