/*
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Sergei Yakovlev - initial API and implementation
 */

package org.eclipse.higgins.rpps.core.tobj;

import java.io.Serializable;

/**
 * The transfer object for the CARD element of UserInterfaceResponse. A transfer object is a serializable class that groups related attributes, forming a composite value. This class is used as the return type of a WS business method.
 * 
 * @author Sergei Yakovlev
 */
public class UIResponseCardTO extends BaseTransferObject implements Serializable {

	private static final long serialVersionUID = -8628665910350011063L;

	private String uid;

	private String description;

	private byte[] image;

	private String imagetype;

	private boolean saveCard = false;

	private PropertyTO[] properties;

	private PropertyTO[] optionalClaims;

	private UITokenServiceCredentialTO[] tokenservices;

	private String[] supportedClaimTypes;

	/** Creates a new instance of UIResponseCardTO */
	public UIResponseCardTO() {
		super();
	}

	/**
	 * Gets the UID property value.
	 * 
	 * @return the UID property value.
	 */
	public String getUid() {
		return uid;
	}

	/**
	 * Sets the UID property value.
	 * 
	 * @param uid the UID property value.
	 */
	public void setUid(String uid) {
		this.uid = uid;
	}

	/**
	 * Gets the description property value.
	 * 
	 * @return the description property value.
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * Sets the description property value.
	 * 
	 * @param description the description property value.
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * Gets the image as a byte array.
	 * 
	 * @return the image as a byte array.
	 */
	public byte[] getImage() {
		return image;
	}

	/**
	 * Sets the image as a byte array.
	 * 
	 * @param image the image as a byte array.
	 */
	public void setImage(byte[] image) {
		this.image = image;
	}

	/**
	 * Gets the image type.
	 * 
	 * @return the image type.
	 */
	public String getImagetype() {
		return imagetype;
	}

	/**
	 * Sets the image type.
	 * 
	 * @param imagetype the image type.
	 */
	public void setImagetype(String imagetype) {
		this.imagetype = imagetype;
	}

	public UITokenServiceCredentialTO[] getTokenservices() {
		return tokenservices;
	}

	public void setTokenservices(UITokenServiceCredentialTO[] tokenservices) {
		this.tokenservices = tokenservices;
	}

	public boolean isSaveCard() {
		return saveCard;
	}

	public void setSaveCard(boolean saveCard) {
		this.saveCard = saveCard;
	}

	public PropertyTO[] getProperties() {
		return properties;
	}

	public void setProperties(PropertyTO[] properties) {
		this.properties = properties;
	}

	public PropertyTO[] getOptionalClaims() {
		return optionalClaims;
	}

	public void setOptionalClaims(PropertyTO[] optionalClaims) {
		this.optionalClaims = optionalClaims;
	}

	public String[] getSupportedClaimTypes() {
		return supportedClaimTypes;
	}

	public void setSupportedClaimTypes(String[] supportedClaimTypes) {
		this.supportedClaimTypes = supportedClaimTypes;
	}
}