/*
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Sergei Yakovlev - initial API and implementation
 */

package org.eclipse.higgins.rpps.core.tobj;

import java.io.Serializable;
import java.util.Date;

/**
 * The transfer object for the i-card. A transfer object is a serializable class that groups related
 * attributes, forming a composite value. This class is used as the return type of a WS business
 * method.
 * 
 * @author Sergei Yakovlev
 */
public class ICardTO extends BaseTransferObject implements Serializable {
	
	private static final long				serialVersionUID	= 3924677175433968754L;
	
	private String							id;
	private String							cuid;
	private String							issuerName;
	private byte[]							image;
	private String							imageType;
	private Date							expiredTime;
	private boolean							selfIssued;
	private boolean							deleteable;
    private String type;
	private PropertyTO[]					properties;
	private UITokenServiceCredentialTO[]	tokenServiceCredentials;

	private String	name;
	
	// private String name;
	
	/** Creates a new instance of ICardTO */
	public ICardTO() {
		super();
	}
	
	/**
	 * Gets id property
	 * 
	 * @return the id as a string.
	 */
	public String getId() {
		return id;
	}
	
	/**
	 * Sets id property
	 * 
	 * @param id
	 *            the id as a string
	 */
	public void setId(String id) {
		this.id = id;
	}
	
	/**
	 * Gets issuer name property
	 * 
	 * @return the issuer name.
	 */
	public String getIssuerName() {
		return issuerName;
	}
	
	/**
	 * Sets issuer name property
	 * 
	 * @param issuerName
	 *            the issuer name.
	 */
	public void setIssuerName(String issuerName) {
		this.issuerName = issuerName;
	}
	
	public Date getExpiredTime() {
		return expiredTime;
	}
	
	public void setExpiredTime(Date expiredTime) {
		this.expiredTime = expiredTime;
	}
	
	/**
	 * Gets image property.
	 * 
	 * @return the image as a byte array.
	 */
	public byte[] getImage() {
		return image;
	}
	
	/**
	 * Sets image property
	 * 
	 * @param image
	 *            the image as a byte array.
	 */
	public void setImage(byte[] image) {
		this.image = image;
	}
	
	/**
	 * Gets icard property array.
	 * 
	 * @return the icard property array.
	 */
	public PropertyTO[] getProperties() {
		return properties;
	}
	
	/**
	 * Sets icard property array.
	 * 
	 * @param properties
	 *            the icard property array.
	 */
	public void setProperties(PropertyTO[] properties) {
		this.properties = properties;
	}
	
	/**
	 * Gets image type.
	 * 
	 * @return the image type as a string.
	 */
	public String getImageType() {
		return imageType;
	}
	
	/**
	 * Sets image type.
	 * 
	 * @param imageType
	 *            the image type as a string.
	 */
	public void setImageType(String imageType) {
		this.imageType = imageType;
	}
	
	/**
	 * Gets CUID.
	 * 
	 * @return the CUID as a string.
	 */
	public String getCuid() {
		return cuid;
	}
	
	/**
	 * Sets CUID
	 * 
	 * @param cuid
	 *            the CUID as a string.
	 */
	public void setCuid(String cuid) {
		this.cuid = cuid;
	}
	
	/**
	 * Gets 'self-issued' flag
	 * 
	 * @return the self-issued flag (true if icard is self-issued).
	 */
	public boolean isSelfIssued() {
		return selfIssued;
	}
	
	/**
	 * Sets 'self-issued' flag.
	 * 
	 * @param selfIssued
	 *            the self-issued flag value.
	 */
	public void setSelfIssued(boolean selfIssued) {
		this.selfIssued = selfIssued;
	}
	
	public UITokenServiceCredentialTO[] getTokenServiceCredentials() {
		return tokenServiceCredentials;
	}
	
	public void setTokenServiceCredentials(UITokenServiceCredentialTO[] tokenServiceCredentials) {
		this.tokenServiceCredentials = tokenServiceCredentials;
	}
	
	public boolean isDeleteable() {
		return deleteable;
	}
	
	public void setDeleteable(boolean deleteable) {
		this.deleteable = deleteable;
	}
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	/**
	 * Gets the name of transfer object.
	 * 
	 * @return the name of transfer object.
	 */
	public String getName() {
		return name;
	}

	/**
	 * Sets the name of transfer object
	 * 
	 * @param name
	 *            the name of transfer object.
	 */
	public void setName(String name) {
		this.name = name;
	}
	
}
