/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Artem Verkhovets - initial API and implementation
 */
package org.eclipse.higgins.rpps.core.tobj;

import java.io.Serializable;

public class RPPolicy extends BaseTransferObject implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 3032985234731163893L;

	private String[] label;

	private String longlabel;

	private String[] labelType;

	private String[] optional;

	private String longoptional;

	private String[] optionalType;
	
	private String privacyVersion;

	public RPPolicy()
	{
		setLabelType(new String[0]);
		setLabel(new String[0]);
		setLonglabel("");
		setOptional(new String[0]);
		setLongOptional("");
		setOptionalType(new String[0]);
	}
	/**
	 * Gets the string array of values of LABEL elements.
	 * 
	 * @return the string array of values of LABEL elements.
	 */
	public String[] getLabel() {
		return label;
	}

	/**
	 * Sets the string array of values of LABEL elements.
	 * 
	 * @param label the string array of values of LABEL elements.
	 */
	public void setLabel(String[] label) {
		this.label = label;
	}

	/**
	 * Gets the value of LONGLABEL element.
	 * 
	 * @return the value of LONGLABEL element.
	 */
	public String getLonglabel() {
		return longlabel;
	}

	/**
	 * Sets the value of LONGLABEL element.
	 * 
	 * @param longlabel the value of LONGLABEL element.
	 */
	public void setLonglabel(String longlabel) {
		this.longlabel = longlabel;
	}

	public String[] getOptional() {
		return optional;
	}

	public void setOptional(String[] optional) {
		this.optional = optional;
	}

	public String getLongOptional() {
		return longoptional;
	}

	public void setLongOptional(String longoptional) {
		this.longoptional = longoptional;
	}
	
	public String[] getLabelType() {
		return labelType;
	}

	public void setLabelType(String[] labelType) {
		this.labelType = labelType;
	}

	public String[] getOptionalType() {
		return optionalType;
	}

	public void setOptionalType(String[] optionalType) {
		this.optionalType = optionalType;
	}

	public String getPrivacyVersion() {
		return privacyVersion;
	}

	public void setPrivacyVersion(String privacyVersion) {
		this.privacyVersion = privacyVersion;
	}
}
