/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.rpps.core.impl;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.AuthenticationException;
import org.eclipse.higgins.icard.AuthenticationRequiredException;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IClaimType;
import org.eclipse.higgins.icard.IComplexClaim;
import org.eclipse.higgins.icard.IComplexClaimType;
import org.eclipse.higgins.icard.IPolicy;
import org.eclipse.higgins.icard.ISimpleClaim;
import org.eclipse.higgins.icard.ISimpleClaimType;
import org.eclipse.higgins.icard.ITemplateContainer;
import org.eclipse.higgins.icard.ITemplateElement;
import org.eclipse.higgins.icard.ITemplateValue;
import org.eclipse.higgins.icard.IUIDescriptor;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.ICredentialDescriptor;
import org.eclipse.higgins.icard.auth.IPinCodeCredential;
import org.eclipse.higgins.icard.auth.ITSKerberosV5Credential;
import org.eclipse.higgins.icard.auth.ITSSelfIssuedCredential;
import org.eclipse.higgins.icard.auth.ITSUsernamePasswordCredential;
import org.eclipse.higgins.icard.auth.ITSX509V3Credential;
import org.eclipse.higgins.icard.auth.ITokenServiceCredential;
import org.eclipse.higgins.icard.common.auth.PasswordCredential;
import org.eclipse.higgins.icard.common.auth.PinCodeCredential;
import org.eclipse.higgins.icard.common.auth.UsernamePasswordCredential;
import org.eclipse.higgins.icard.policy.ICardSpacePolicy;
import org.eclipse.higgins.rpps.core.tobj.CardInformationTO;
import org.eclipse.higgins.rpps.core.tobj.CardUsageTO;
import org.eclipse.higgins.rpps.core.tobj.CategoryTO;
import org.eclipse.higgins.rpps.core.tobj.ICardTemplateTO;
import org.eclipse.higgins.rpps.core.tobj.ITemplateElementTO;
import org.eclipse.higgins.rpps.core.tobj.PropertyTO;
import org.eclipse.higgins.rpps.core.tobj.RPEndPointTO;
import org.eclipse.higgins.rpps.core.tobj.RPPolicy;
import org.eclipse.higgins.rpps.core.tobj.TokenResponseTO;
import org.eclipse.higgins.rpps.core.tobj.UITokenServiceCredentialTO;
import org.eclipse.higgins.rpps.core.tobj.UserProfileTO;
import org.eclipse.higgins.userprofile.entity.CardCredential;
import org.eclipse.higgins.userprofile.entity.CardUsage;
import org.eclipse.higgins.userprofile.entity.Category;
import org.eclipse.higgins.userprofile.entity.UserProfile;

public class ConvertHelper {
    private static Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$rpps$core$impl$ConvertHelper == null ? (class$org$eclipse$higgins$rpps$core$impl$ConvertHelper = ConvertHelper.class$("org.eclipse.higgins.rpps.core.impl.ConvertHelper")) : class$org$eclipse$higgins$rpps$core$impl$ConvertHelper));
    static /* synthetic */ Class class$org$eclipse$higgins$rpps$core$impl$ConvertHelper;

    public static ICredential convertUITokenServiceCredentialTO_to_ICredentials(ICard card, UITokenServiceCredentialTO siteCredential) {
        ICredential credential = null;
        ICredentialDescriptor[] userCredential = card.getRequiredCredentials();
        if (userCredential != null && siteCredential != null) {
            for (int index = 0; index < userCredential.length; ++index) {
                credential = userCredential[index].getCredential();
                if (credential instanceof IPinCodeCredential && "IPinCodeCredential".equals(siteCredential.getType())) {
                    if (siteCredential.getPinCode() == null || siteCredential.getPinCode().length() <= 0) break;
                    try {
                        ((IPinCodeCredential)credential).setPinCode(siteCredential.getPinCode().getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException exc) {
                        ((IPinCodeCredential)credential).setPinCode(siteCredential.getPinCode().getBytes());
                    }
                    break;
                }
                if (!(credential instanceof ITokenServiceCredential) || !((ITokenServiceCredential)credential).getAddress().toString().equals(siteCredential.getAddress()) || !((ITokenServiceCredential)credential).getMetadataAddress().toString().equals(siteCredential.getMetadataAddress())) continue;
                if ("ITSUsernamePasswordCredential".equals(siteCredential.getType()) && credential instanceof ITSUsernamePasswordCredential) {
                    if (!((ITSUsernamePasswordCredential)credential).isUsernamePredefined()) {
                        ((ITSUsernamePasswordCredential)credential).setUsername(siteCredential.getUsername());
                    }
                    ((ITSUsernamePasswordCredential)credential).setPassword(siteCredential.getPassword());
                    break;
                }
                if ("ITSSelfIssuedCredential".equals(siteCredential.getType()) && credential instanceof ITSSelfIssuedCredential) {
                    if (siteCredential.getPinCode() == null || siteCredential.getPinCode().length() <= 0) break;
                    PinCodeCredential subCredentional = new PinCodeCredential();
                    try {
                        subCredentional.setPinCode(siteCredential.getPinCode().getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException exc) {
                        subCredentional.setPinCode(siteCredential.getPinCode().getBytes());
                    }
                    ((ITSSelfIssuedCredential)credential).setPinCodeCredential((IPinCodeCredential)subCredentional);
                    break;
                }
                if (!("ITSSelfIssuedNonPinCredential".equals(siteCredential.getType()) && credential instanceof ITSSelfIssuedCredential || "ITSKerberosV5Credential".equals(siteCredential.getType()) && credential instanceof ITSKerberosV5Credential || "ITSX509V3Credential".equals(siteCredential.getType()) && credential instanceof ITSX509V3Credential)) {
                    continue;
                }
                break;
            }
        } else if (userCredential != null) {
            for (int index = 0; index < userCredential.length && !((credential = userCredential[index].getCredential()) instanceof ITSSelfIssuedCredential); ++index) {
            }
        }
        return credential;
    }

    public static ICredential convertUITokenServiceCredentialTO_to_ICredentials(UITokenServiceCredentialTO siteCredential) {
        PinCodeCredential credential = null;
        if (siteCredential != null) {
            if ("IPinCodeCredential".equals(siteCredential.getType())) {
                credential = new PinCodeCredential();
                try {
                    credential.setPinCode(siteCredential.getPinCode().getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException exc) {
                    credential.setPinCode(siteCredential.getPinCode().getBytes());
                }
            } else if ("IUsernamePasswordCredential".equals(siteCredential.getType())) {
                credential = new UsernamePasswordCredential(siteCredential.getUsername());
                ((UsernamePasswordCredential)credential).setPassword(siteCredential.getPassword());
            } else if ("IPasswordCredential".equals(siteCredential.getType())) {
                credential = new PasswordCredential();
                ((PasswordCredential)credential).setPassword(siteCredential.getPassword());
            }
        }
        return credential;
    }

    public static ICredential convertCardCredential_to_ICredential(ICard card, CardCredential siteCredential) {
        UITokenServiceCredentialTO credential = null;
        if (siteCredential != null) {
            credential = new UITokenServiceCredentialTO();
            credential.setType(siteCredential.getCredentialType() != null ? siteCredential.getCredentialType() : "");
            credential.setAddress(siteCredential.getTsAddress() != null ? siteCredential.getTsAddress() : "");
            credential.setMetadataAddress(siteCredential.getTsMetadataAddress() != null ? siteCredential.getTsMetadataAddress() : "");
            credential.setPassword(siteCredential.getPassword() != null ? siteCredential.getPassword() : "");
            credential.setUsername(siteCredential.getUsername() != null ? siteCredential.getUsername() : "");
            try {
                credential.setPinCode(siteCredential.getPinCode() != null ? new String(siteCredential.getPinCode(), "UTF-8") : "");
            }
            catch (Exception exc) {
                credential.setPinCode(siteCredential.getPinCode() != null ? new String(siteCredential.getPinCode()) : "");
            }
        }
        return ConvertHelper.convertUITokenServiceCredentialTO_to_ICredentials(card, credential);
    }

    public static CardCredential convertICredential_to_CardCredential(ICredential credential) {
        CardCredential siteCredential = null;
        if (credential != null) {
            siteCredential = new CardCredential();
            if (credential instanceof IPinCodeCredential) {
                byte[] pinCode = ((IPinCodeCredential)credential).getPinCode();
                siteCredential.setPinCode(pinCode);
                siteCredential.setCredentialType("IPinCodeCredential");
            } else {
                if (credential instanceof ITokenServiceCredential) {
                    siteCredential.setTsAddress(((ITokenServiceCredential)credential).getAddress().toString());
                    siteCredential.setTsMetadataAddress(((ITokenServiceCredential)credential).getMetadataAddress().toString());
                }
                if (credential instanceof ITSUsernamePasswordCredential) {
                    siteCredential.setCredentialType("ITSUsernamePasswordCredential");
                    siteCredential.setUsername(((ITSUsernamePasswordCredential)credential).getUsername());
                    siteCredential.setPassword(((ITSUsernamePasswordCredential)credential).getPassword());
                } else if (credential instanceof ITSSelfIssuedCredential) {
                    siteCredential.setCredentialType("ITSSelfIssuedCredential");
                    if (((ITSSelfIssuedCredential)credential).getPinCodeCredential() != null) {
                        byte[] pinCode = ((ITSSelfIssuedCredential)credential).getPinCodeCredential().getPinCode();
                        siteCredential.setPinCode(pinCode);
                    }
                } else if (credential instanceof ITSKerberosV5Credential) {
                    siteCredential.setCredentialType("ITSKerberosV5Credential");
                } else if (credential instanceof ITSX509V3Credential) {
                    siteCredential.setCredentialType("ITSX509V3Credential");
                }
            }
        }
        return siteCredential;
    }

    public static CardCredential convertUITokenServiceCredentialTO_to_CardCredential(UITokenServiceCredentialTO credential) {
        CardCredential cardCredential = null;
        if (credential != null) {
            cardCredential = new CardCredential();
            cardCredential.setCredentialType(credential.getType());
            cardCredential.setTsAddress(credential.getAddress() != null ? credential.getAddress() : "");
            cardCredential.setTsMetadataAddress(credential.getMetadataAddress() != null ? credential.getMetadataAddress() : "");
            cardCredential.setPassword(credential.getPassword() != null ? credential.getPassword() : "");
            cardCredential.setUsername(credential.getUsername() != null ? credential.getUsername() : "");
            if (credential.getPinCode() != null) {
                try {
                    cardCredential.setPinCode(credential.getPinCode().getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException exc) {
                    cardCredential.setPinCode(credential.getPinCode().getBytes());
                }
            } else {
                cardCredential.setPinCode(null);
            }
        }
        return cardCredential;
    }

    public static ICredential convertHashtable_to_Credential(ICard card, String typeofCredential, Hashtable table) throws CardException, UnsupportedEncodingException {
        UITokenServiceCredentialTO credential = null;
        if (typeofCredential != null && typeofCredential.trim().length() > 0) {
            credential = new UITokenServiceCredentialTO();
            credential.setType(typeofCredential);
            credential.setAddress(table.get("address") != null ? table.get("address").toString() : "");
            credential.setMetadataAddress(table.get("metadataAddress") != null ? table.get("metadataAddress").toString() : "");
            credential.setPassword(table.get("password") != null ? table.get("password").toString() : "");
            credential.setUsername(table.get("username") != null ? table.get("username").toString() : "");
            credential.setPinCode(table.get("pin") != null ? table.get("pin").toString() : "");
        }
        return ConvertHelper.convertUITokenServiceCredentialTO_to_ICredentials(card, credential);
    }

    public static Map convertClaims_to_PropertyTO(ICard card, boolean isCatchAuthentication, Iterator claimIterator) throws AuthenticationRequiredException, CardException {
        LinkedHashMap<String, PropertyTO> props = new LinkedHashMap<String, PropertyTO>();
        if (card != null) {
            Iterator it = claimIterator;
            while (it != null && it.hasNext()) {
                IClaim claim;
                String claimTypeString;
                IClaimType claimType;
                block13: {
                    Object claimTypeObject = it.next();
                    claimType = null;
                    if (claimTypeObject instanceof IClaimType) {
                        claimTypeString = ((IClaimType)claimTypeObject).getType();
                        claimType = (IClaimType)claimTypeObject;
                    } else {
                        claimTypeString = claimTypeObject.toString();
                    }
                    claim = null;
                    try {
                        claim = card.getClaim(claimTypeString);
                        if (claim == null) break block13;
                        claimType = claim.getType();
                    }
                    catch (InvalidTypeException e) {
                        log.info((Object)e);
                    }
                    catch (AuthenticationRequiredException e) {
                        if (isCatchAuthentication) {
                            throw e;
                        }
                    }
                    catch (AuthenticationException e) {
                        if (isCatchAuthentication) {
                            throw e;
                        }
                    }
                    catch (CardException e) {
                        log.error((Object)e);
                        break;
                    }
                }
                if (claimType == null) continue;
                if (claimType.isSimple()) {
                    IUIDescriptor uiDesc = ((ISimpleClaimType)claimType).getUIDescriptor();
                    String[] optionalValues = null;
                    if (uiDesc.getOptionalValues() != null && uiDesc.getOptionalValues().size() > 0) {
                        optionalValues = uiDesc.getOptionalValues().toArray(new String[uiDesc.getOptionalValues().size()]);
                    }
                    props.put(claimTypeString, new PropertyTO(claimType.getDisplayName(), claimType.getType(), ((ISimpleClaimType)claimType).getDataType().getName(), ConvertHelper.getSimpleValues(claim, ((ISimpleClaimType)claimType).getMaxCardinality()), claimType.isVisible(), uiDesc.getType(), optionalValues, uiDesc.getPattern(), uiDesc.getInputMask()));
                    continue;
                }
                props.put(claimTypeString, new PropertyTO(claimType.getDisplayName(), claimType.getType(), ConvertHelper.getComplexValues((IComplexClaimType)claimType, (IComplexClaim)claim, isCatchAuthentication, ((IComplexClaimType)claimType).getSupportedClaimTypes()), claimType.isVisible()));
            }
        }
        return props;
    }

    public static String[] getSimpleValues(IClaim claim, int size) {
        String[] values = new String[size];
        if (claim != null && claim instanceof ISimpleClaim) {
            List claimValues = ((ISimpleClaim)claim).getValues();
            for (int i = 0; i < claimValues.size(); ++i) {
                values[i] = claimValues.get(i).toString();
            }
        }
        return values;
    }

    public static PropertyTO[] getComplexValues(IComplexClaimType rootClaimType, IComplexClaim rootClaim, boolean isCatchAuthentication, Iterator claimIterator) throws CardException, InvalidTypeException {
        ArrayList<PropertyTO> claimValues = new ArrayList<PropertyTO>();
        Iterator it = claimIterator;
        while (it != null && it.hasNext()) {
            IClaim claim;
            IClaimType claimType;
            block8: {
                claimType = (IClaimType)it.next();
                claim = null;
                try {
                    if (rootClaim != null) {
                        claim = rootClaim.getClaim(claimType.getType());
                    }
                }
                catch (AuthenticationRequiredException e) {
                    if (isCatchAuthentication) {
                        throw e;
                    }
                }
                catch (AuthenticationException e) {
                    if (!isCatchAuthentication) break block8;
                    throw e;
                }
            }
            if (claimType.isSimple()) {
                IUIDescriptor uiDesc = ((ISimpleClaimType)claimType).getUIDescriptor();
                String[] optionalValues = null;
                if (uiDesc.getOptionalValues() != null && uiDesc.getOptionalValues().size() > 0) {
                    optionalValues = uiDesc.getOptionalValues().toArray(new String[uiDesc.getOptionalValues().size()]);
                }
                claimValues.add(new PropertyTO(claimType.getDisplayName(), claimType.getType(), ((ISimpleClaimType)claimType).getDataType().getName(), ConvertHelper.getSimpleValues(claim, ((ISimpleClaimType)claimType).getMaxCardinality()), claimType.isVisible(), uiDesc.getType(), optionalValues, uiDesc.getPattern(), uiDesc.getInputMask()));
                continue;
            }
            claimValues.add(new PropertyTO(claimType.getDisplayName(), claimType.getType(), ConvertHelper.getComplexValues((IComplexClaimType)claimType, (IComplexClaim)claim, isCatchAuthentication, ((IComplexClaimType)claimType).getSupportedClaimTypes()), claimType.isVisible()));
        }
        PropertyTO[] values = new PropertyTO[claimValues.size()];
        claimValues.toArray(values);
        return values;
    }

    public static UserProfileTO convertUserProfile_to_UserProfileTO(UserProfile userProfile) {
        UserProfileTO userProfileTO = null;
        if (userProfile != null) {
            userProfileTO = new UserProfileTO();
            userProfileTO.setCreated(userProfile.getCreated());
            userProfileTO.setEmail(userProfile.getEmail());
            userProfileTO.setFirstName(userProfile.getFirstName());
            userProfileTO.setLastName(userProfile.getLastName());
            userProfileTO.setLoginName(userProfile.getLoginName());
            userProfileTO.setModified(userProfile.getModified());
            userProfileTO.setStatus(userProfile.getStatus());
            userProfileTO.setUsedFrom(userProfile.getUsedFrom());
            if (userProfile.getOneTimePasswords() != null) {
                userProfileTO.setOneTimePasswords(userProfile.getOneTimePasswords().toArray(new String[userProfile.getOneTimePasswords().size()]));
            }
            userProfileTO.setSms(userProfile.getSms());
            userProfileTO.setPasswordIsapMd5(userProfile.getPasswordIsapMd5());
            userProfileTO.setPrivateUserINumber(userProfile.getPrivateUserINumber());
            if (userProfile.getPrivateKey() != null) {
                userProfileTO.setPrivateKey(userProfile.getPrivateKey());
            }
            if (userProfile.getPrivateSelectorINumbers() != null) {
                String[] privateSelectorINumbers = new String[userProfile.getPrivateSelectorINumbers().size()];
                userProfile.getPrivateSelectorINumbers().toArray(privateSelectorINumbers);
                userProfileTO.setPrivateSelectorINumbers(privateSelectorINumbers);
            }
        }
        return userProfileTO;
    }

    public static UserProfile convertUserProfileTO_to_UserProfile(UserProfile userProfile, UserProfileTO userProfileTO) {
        if (userProfileTO != null) {
            if (userProfile == null) {
                userProfile = new UserProfile();
            }
            userProfile.setCreated(userProfileTO.getCreated());
            userProfile.setEmail(userProfileTO.getEmail());
            userProfile.setFirstName(userProfileTO.getFirstName());
            userProfile.setLastName(userProfileTO.getLastName());
            userProfile.setLoginName(userProfileTO.getLoginName());
            userProfile.setModified(userProfileTO.getModified());
            userProfile.setStatus(userProfileTO.getStatus());
            userProfile.setUsedFrom(userProfileTO.getUsedFrom());
            if (userProfileTO.getOneTimePasswords() != null) {
                userProfile.setOneTimePasswords(Arrays.asList(userProfileTO.getOneTimePasswords()));
            }
            userProfile.setPrivateUserINumber(userProfileTO.getPrivateUserINumber());
            userProfile.setSms(userProfileTO.getSms());
            userProfile.setPasswordIsapMd5(userProfileTO.getPasswordIsapMd5());
            if (userProfileTO.getPrivateKey() != null) {
                userProfile.setPrivateKey(userProfileTO.getPrivateKey());
            } else {
                userProfile.setPrivateKey(new byte[0]);
            }
            if (userProfileTO.getPrivateSelectorINumbers() != null) {
                userProfile.setPrivateSelectorINumbers(Arrays.asList(userProfileTO.getPrivateSelectorINumbers()));
            }
        }
        return userProfile;
    }

    public static CategoryTO convertCategory_to_CategoryTO(Category category) {
        CategoryTO categoryTO = null;
        if (category != null) {
            categoryTO = new CategoryTO();
            if (category.getIcon() != null) {
                categoryTO.setIcon(category.getIcon());
            }
            if (category.getId() != null) {
                categoryTO.setId(category.getId());
            }
            if (category.getName() != null) {
                categoryTO.setName(category.getName());
            }
            if (category.getParentId() != null) {
                categoryTO.setParentId(category.getParentId());
            }
            if (category.getSelectedIcon() != null) {
                categoryTO.setSelectedIcon(category.getSelectedIcon());
            }
            if (category.getCardList() != null) {
                String[] cuids = new String[category.getCardList().size()];
                category.getCardList().toArray(cuids);
                categoryTO.setCardList(cuids);
            }
            if (category.getType() != null) {
                categoryTO.setType(category.getType());
            }
            categoryTO.setIdx(category.getIdx());
        }
        return categoryTO;
    }

    public static Category convertCategoryTO_to_Category(CategoryTO categoryTO) {
        Category category = null;
        if (categoryTO != null) {
            category = new Category();
            if (categoryTO.getIcon() != null) {
                category.setIcon(categoryTO.getIcon());
            }
            if (categoryTO.getId() != null) {
                category.setId(categoryTO.getId());
            }
            if (categoryTO.getName() != null) {
                category.setName(categoryTO.getName());
            }
            if (categoryTO.getParentId() != null) {
                category.setParentId(categoryTO.getParentId());
            }
            if (categoryTO.getSelectedIcon() != null) {
                category.setSelectedIcon(categoryTO.getSelectedIcon());
            }
            if (categoryTO.getCardList() != null) {
                ArrayList<String> list = new ArrayList<String>(categoryTO.getCardList().length);
                for (int i = 0; i < categoryTO.getCardList().length; ++i) {
                    list.add(categoryTO.getCardList()[i]);
                }
                category.setCardList(list);
            }
            if (categoryTO.getType() != null) {
                category.setType(categoryTO.getType());
            }
            category.setIdx(categoryTO.getIdx());
        }
        return category;
    }

    public static CardInformationTO createCardInformationTO(List cardHistory, int sizeHistory) {
        CardInformationTO cardInformationTO = null;
        if (cardHistory != null) {
            if (cardInformationTO == null) {
                cardInformationTO = new CardInformationTO();
            }
            cardInformationTO.setSizeHistory(sizeHistory);
            int size = cardHistory.size();
            CardUsageTO[] arrayUsage = new CardUsageTO[size];
            for (int i = 0; i < size; ++i) {
                CardUsage cardUsage = (CardUsage)cardHistory.get(i);
                arrayUsage[i] = ConvertHelper.convertCardUsage_to_CardUsageTO(cardUsage);
            }
            cardInformationTO.setCardHistory(arrayUsage);
        }
        return cardInformationTO;
    }

    public static ICardTemplate loadTemplate(ICardTemplate[] templates, ICardTemplateTO templeteTO) {
        ICardTemplate template = null;
        if (templates != null) {
            for (int index = 0; index < templates.length; ++index) {
                if (!templates[index].getCardType().getName().equalsIgnoreCase(templeteTO.getCardType())) continue;
                template = templates[index];
                template.setDescription(templeteTO.getDescription());
                template.setDisplayName(templeteTO.getName());
                int size = templeteTO.getElements().length;
                for (int i = 0; i < size; ++i) {
                    ITemplateElement element = template.getTemplateElementByID(templeteTO.getElements()[i].getId());
                    if (element == null) continue;
                    if (element instanceof ITemplateValue) {
                        ConvertHelper.setITemplateValue((ITemplateValue)element, templeteTO.getElements()[i].getValue());
                        continue;
                    }
                    ConvertHelper.setITemplateContainer((ITemplateContainer)element, templeteTO.getElements()[i].getContainerValue());
                }
            }
        }
        return template;
    }

    public static void setITemplateValue(ITemplateValue element, String elementTOValue) {
        if (element != null) {
            element.setValue(elementTOValue);
        }
    }

    public static void setITemplateContainer(ITemplateContainer root, ITemplateElementTO[] elementsTO) {
        if (root != null) {
            int size = elementsTO.length;
            for (int i = 0; i < size; ++i) {
                ITemplateElement element = root.getTemplateElementByID(elementsTO[i].getId());
                if (element == null) continue;
                if (element instanceof ITemplateValue) {
                    ConvertHelper.setITemplateValue((ITemplateValue)element, elementsTO[i].getValue());
                    continue;
                }
                ConvertHelper.setITemplateContainer((ITemplateContainer)element, elementsTO[i].getContainerValue());
            }
        }
    }

    public static TokenResponseTO createTokenResponse(String token) {
        TokenResponseTO trto = new TokenResponseTO();
        if (token != null) {
            trto.setTkn(token);
        }
        return trto;
    }

    public static ICardTemplateTO convertICardTemplate_to_ICardTemplateTO(ICardTemplate template) {
        ICardTemplateTO templateTO = new ICardTemplateTO();
        templateTO.setName(template.getDisplayName());
        templateTO.setDescription(template.getDescription());
        templateTO.setId(template.getTUID().toString());
        templateTO.setProviderDescription(template.getProviderDescription());
        templateTO.setProviderID(template.getProviderID());
        templateTO.setProviderName(template.getProviderName());
        templateTO.setCardType(template.getCardType().getName());
        ArrayList<ITemplateElementTO> elementValues = new ArrayList<ITemplateElementTO>();
        Iterator iter = template.getTemplateElements();
        while (iter != null && iter.hasNext()) {
            ITemplateElement elementValue = (ITemplateElement)iter.next();
            ITemplateElementTO elementTOValue = null;
            if (elementValue != null) {
                elementTOValue = elementValue instanceof ITemplateValue ? ConvertHelper.getITemplateValue(elementValue) : ConvertHelper.getITemplateContainer(elementValue);
            }
            if (elementTOValue == null) continue;
            elementValues.add(elementTOValue);
        }
        ITemplateElementTO[] values = new ITemplateElementTO[elementValues.size()];
        elementValues.toArray(values);
        templateTO.setElements(values);
        return templateTO;
    }

    private static ITemplateElementTO getITemplateValue(ITemplateElement element) {
        if (element != null && element instanceof ITemplateValue) {
            ITemplateElementTO elementTO = new ITemplateElementTO();
            ITemplateValue tempElement = (ITemplateValue)element;
            if (tempElement.getDisplayName() != null) {
                elementTO.setName(tempElement.getDisplayName());
            }
            if (tempElement.getDescription() != null) {
                elementTO.setDescription(tempElement.getDescription());
            }
            if (tempElement.getID() != null) {
                elementTO.setId(tempElement.getID());
            }
            if (tempElement.getUIDescriptor() != null) {
                if (tempElement.getUIDescriptor().getInputMask() != null) {
                    elementTO.setInputMask(tempElement.getUIDescriptor().getInputMask());
                }
                if (tempElement.getUIDescriptor().getOptionalValues() != null) {
                    String[] values = new String[tempElement.getUIDescriptor().getOptionalValues().size()];
                    tempElement.getUIDescriptor().getOptionalValues().toArray(values);
                    elementTO.setOptionalValues(values);
                }
                if (tempElement.getUIDescriptor().getPattern() != null) {
                    elementTO.setPattern(tempElement.getUIDescriptor().getPattern());
                }
                elementTO.setType(tempElement.getUIDescriptor().getType());
            }
            if (tempElement.getValue() != null) {
                elementTO.setValue(tempElement.getValue());
            }
            return elementTO;
        }
        return null;
    }

    private static ITemplateElementTO getITemplateContainer(ITemplateElement element) {
        ITemplateElementTO container = null;
        if (element != null && element instanceof ITemplateContainer) {
            container = new ITemplateElementTO();
            container.setName(element.getDisplayName());
            container.setDescription(element.getDescription());
            container.setId(element.getID());
            ArrayList<ITemplateElementTO> elementValues = new ArrayList<ITemplateElementTO>();
            Iterator iter = ((ITemplateContainer)element).getTemplateElements();
            while (iter != null && iter.hasNext()) {
                ITemplateElement elementValue = (ITemplateElement)iter.next();
                ITemplateElementTO elementTOValue = null;
                if (elementValue != null) {
                    elementTOValue = elementValue instanceof ITemplateValue ? ConvertHelper.getITemplateValue(elementValue) : ConvertHelper.getITemplateContainer(elementValue);
                }
                if (elementTOValue == null) continue;
                elementValues.add(elementTOValue);
            }
            ITemplateElementTO[] values = new ITemplateElementTO[elementValues.size()];
            elementValues.toArray(values);
            container.setContainerValue(values);
        }
        return container;
    }

    public static URI convertString_to_URI(String url) throws MalformedURLException, URISyntaxException {
        URI urlObj = new URI("http://demo.com/demo.html");
        try {
            String url_ = url.indexOf("?") > -1 ? url.substring(0, url.indexOf("?")) : url;
            urlObj = new URI(url_);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return urlObj;
    }

    public static CardUsageTO convertCardUsage_to_CardUsageTO(CardUsage cardUsage) {
        CardUsageTO cardUsageTO = null;
        if (cardUsage != null) {
            cardUsageTO = new CardUsageTO();
            cardUsageTO.setDate(cardUsage.getDate());
            if (cardUsage.getForm() != null) {
                cardUsageTO.setRpEndPointTO(new RPEndPointTO(cardUsage.getForm()));
            }
            if (cardUsage.getSite() != null) {
                cardUsageTO.setSite(cardUsage.getSite().toString());
            }
            if (cardUsage.getUseAlways() != null) {
                cardUsageTO.setUseAlways(cardUsage.getUseAlways());
            }
        }
        return cardUsageTO;
    }

    public static RPPolicy convertIPolicyToRPPolicy(IPolicy atom) {
        ICardSpacePolicy icp;
        RPPolicy policy = new RPPolicy();
        if (atom.getRequiredClaims() != null) {
            policy.setLabel(atom.getSummary());
            policy.setLonglabel(Arrays.asList(atom.getSummary()).toString());
            List requiredClaims = atom.getRequiredClaims();
            String[] summary = new String[requiredClaims.size()];
            ListIterator iter = requiredClaims.listIterator();
            int i = 0;
            while (iter.hasNext()) {
                summary[i++] = iter.next().toString();
            }
            policy.setLabelType(summary);
        }
        if (atom instanceof ICardSpacePolicy && (icp = (ICardSpacePolicy)atom).getOptionalClaims() != null) {
            policy.setOptional(icp.getOptionalClaimSummary());
            policy.setLongOptional(Arrays.asList(icp.getOptionalClaimSummary()).toString());
            List optionalClaims = icp.getOptionalClaims();
            String[] summary = new String[optionalClaims.size()];
            ListIterator iter = optionalClaims.listIterator();
            int i = 0;
            while (iter.hasNext()) {
                summary[i++] = iter.next().toString();
            }
            policy.setOptionalType(summary);
        }
        return policy;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

