/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergei Yakovlev - initial API and implementation
 */

package org.eclipse.higgins.rpps.core;

/**
 * RppsException is an exception that extends the standard Exception. This is thrown by the the signon component when there is some failure because of user error
 * 
 * @author Sergei Yakovlev
 * 
 */
public class RppsException extends RuntimeException {

	private static final long serialVersionUID = 2413130242462118294L;

	/**
	 * Constructs a new rpps exception with null as its detail message.
	 */
	public RppsException() {
	}

	/**
	 * Constructs a new rpps exception with the specified detail message.
	 * 
	 * @param str the detail message. The detail message is saved for later retrieval by the Throwable.getMessage() method.
	 */
	public RppsException(String str) {
		super(str);
	}

	/**
	 * Constructs a new rpps exception with the specified cause and a detail message of (cause==null ? null : cause.toString()) (which typically contains the class and detail message of cause).
	 * 
	 * @param cause the cause (which is saved for later retrieval by the Throwable.getCause() method). (A null value is permitted, and indicates that the cause is nonexistent or unknown.)
	 */
	public RppsException(Throwable cause) {
		super(cause);
	}

	/**
	 * Constructs a new rpps exception with the specified detail message and cause.
	 * 
	 * @param str the detail message (which is saved for later retrieval by the Throwable.getMessage() method).
	 * @param cause the cause (which is saved for later retrieval by the Throwable.getCause() method). (A null value is permitted, and indicates that the cause is nonexistent or unknown.)
	 */
	public RppsException(String str, Throwable cause) {
		super(str, cause);
	}

}
