/**
 * Copyright (c) 2008 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html
 *  
 * Contributors: 
 * Alexander Yuhimenko -  initial API and implementation
 * 
 */
package org.eclipse.higgins.rpps.core.tobj;

import java.io.Serializable;

/**
 * The following faults MAY occur when requesting Security Tokens from an IdP using M-Information Cards.
 * 
 * @author Alexander Yuhimenko
 * 
 */
public class StsFaultException extends Exception implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * SOAP action
	 */
	private String action;
	/**
	 *SOAP code.
	 */
	private String code;

	/**
	 * SOAP 1.2 subcode.
	 */
	private String subcode;

	/**
	 *SOAP reason
	 */
	private String reason;

	public String getAction() {
		return action;
	}

	public void setAction(String action) {
		this.action = action;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getSubcode() {
		return subcode;
	}

	public void setSubcode(String subcode) {
		this.subcode = subcode;
	}

	public String getReason() {
		return reason;
	}

	public void setReason(String reason) {
		this.reason = reason;
	}

	public String getDetail() {
		return detail;
	}

	public void setDetail(String detail) {
		this.detail = detail;
	}

	private String detail;

	/**
	 * default constructor
	 */
	public StsFaultException() {
	}

}
