/*
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Sergei Yakovlev - initial API and implementation
 */

package org.eclipse.higgins.rpps.core.tobj;

import java.io.Serializable;

/**
 * The transfer object for the CLAUSE element of UserInterfaceResponse. A transfer object is a serializable class that groups related attributes, forming a composite value. This class is used as the return type of a WS business method.
 * 
 * @author Sergei Yakovlev
 */
public class UIResponseClauseTO implements Serializable {

	private static final long serialVersionUID = 4958502589053883293L;

	private String[] label;

	private String longlabel;

	private String[] labelType;

	private String[] optional;

	private String longOptional;

	private String[] optionalType;

	private UIResponseUsableCardsTO usableCards;

	private String[] usedCardCuids;

	private String	name;
	
	private RPPolicy oldPolicy;

	/** Creates a new instance of UIResponseClauseTO */
	public UIResponseClauseTO() {
		super();
	}

	/**
	 * Gets the string array of values of LABEL elements.
	 * 
	 * @return the string array of values of LABEL elements.
	 */
	public String[] getLabel() {
		return label;
	}

	/**
	 * Sets the string array of values of LABEL elements.
	 * 
	 * @param label the string array of values of LABEL elements.
	 */
	public void setLabel(String[] label) {
		this.label = label;
	}

	/**
	 * Gets the value of LONGLABEL element.
	 * 
	 * @return the value of LONGLABEL element.
	 */
	public String getLonglabel() {
		return longlabel;
	}

	/**
	 * Sets the value of LONGLABEL element.
	 * 
	 * @param longlabel the value of LONGLABEL element.
	 */
	public void setLonglabel(String longlabel) {
		this.longlabel = longlabel;
	}

	public String[] getOptional() {
		return optional;
	}

	public void setOptional(String[] optional) {
		this.optional = optional;
	}

	public String getLongOptional() {
		return longOptional;
	}

	public void setLongOptional(String longoptional) {
		this.longOptional = longoptional;
	}

	/**
	 * Gets the USABLECARDS element.
	 * 
	 * @return the USABLECARDS element.
	 */
	public UIResponseUsableCardsTO getUsableCards() {
		return usableCards;
	}

	/**
	 * Sets the USABLECARDS element.
	 * 
	 * @param usableCards the USABLECARDS element.
	 */
	public void setUsableCards(UIResponseUsableCardsTO usableCards) {
		this.usableCards = usableCards;
	}

	public String[] getLabelType() {
		return labelType;
	}

	public void setLabelType(String[] labelType) {
		this.labelType = labelType;
	}

	public String[] getOptionalType() {
		return optionalType;
	}

	public void setOptionalType(String[] optionalType) {
		this.optionalType = optionalType;
	}

	public String[] getUsedCardCuids() {
		return usedCardCuids;
	}

	public void setUsedCardCuids(String[] usedCardCuids) {
		this.usedCardCuids = usedCardCuids;
	}

	/**
	 * Gets the name of transfer object.
	 * 
	 * @return the name of transfer object.
	 */
	public String getName() {
		return name;
	}

	/**
	 * Sets the name of transfer object
	 * 
	 * @param name
	 *            the name of transfer object.
	 */
	public void setName(String name) {
		this.name = name;
	}

	public RPPolicy getOldPolicy() {
		return oldPolicy;
	}

	public void setOldPolicy(RPPolicy oldPolicy) {
		this.oldPolicy = oldPolicy;
	}
}