/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 *		Artem Verkhovets - API and implementation 
 * 
 */
package org.eclipse.higgins.rpps.core.impl;

import java.net.URI;

import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.userprofile.entity.CardInformation;
import org.eclipse.higgins.userprofile.entity.WebForm;

/**
 * 
 * @author Artem Verkhovets
 * 
 * 
 */
public class CardInformationRPPS extends CardInformation{
	
	private WebForm[] webForms;

	public CardInformationRPPS() {
		super();
	}
	
	public CardInformationRPPS(CardInformation cardInformation, CUID cuid ) {
		super();
		if (cardInformation!=null)
		{
			this.setCardCredential(cardInformation.getCardCredential());
			this.setCuid(cardInformation.getCuid());
		}
		if (this.getCuid()==null)
			this.setCuid(cuid);
	}

	public WebForm[] getWebForms() {
		return webForms;
	}

	public void setWebForms(WebForm[] webForms) {
		this.webForms = webForms;
	}
}
