/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *
 *     Artem Verkhovets - initial API and implementation
 */
package org.eclipse.higgins.rpps.core.tobj;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;

import org.eclipse.higgins.userprofile.UserProfileException;
import org.eclipse.higgins.userprofile.entity.WebForm;


/**
 * @author Artem Verkhovets
 *
 */
public class RPEndPointTO implements Serializable {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -97932491944738945L;
	private String		url;
	private String	formName;
	private String	formId;
	private String	formAction;
	
	public RPEndPointTO() {
	}
	public RPEndPointTO(String url, String formName, String formId, String formAction) {
		this.url = url;
		this.formName = formName;
		this.formId = formId;
		this.formAction = formAction;
	}
	
	public RPEndPointTO(WebForm webForm) {
		this.url = webForm.getUrl().toString();
		this.formName = webForm.getFormName();
		this.formId = webForm.getFormId();
		this.formAction = webForm.getFormAction();
	}
	
	public String getUrl() {
		return url;
	}
	public void setUrl(String url) {
		this.url = url;
	}
	public String getFormName() {
		return formName;
	}
	public void setFormName(String formName) {
		this.formName = formName;
	}
	public String getFormId() {
		return formId;
	}
	public void setFormId(String formId) {
		this.formId = formId;
	}
	public String getFormAction() {
		return formAction;
	}
	public void setFormAction(String formAction) {
		this.formAction = formAction;
	}	
	public WebForm toWebForm() throws URISyntaxException, UserProfileException
	{
		return new WebForm(new URI(this.url),this.formName,this.formId,this.formAction);
	}
}
