/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.rpps.core.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.ITemplateContainer;
import org.eclipse.higgins.icard.ITemplateElement;
import org.eclipse.higgins.icard.ITemplateValue;
import org.eclipse.higgins.rpps.core.tobj.ICardTemplateTO;
import org.eclipse.higgins.rpps.core.tobj.ITemplateElementTO;

public class RppsHelper {
    private static final Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$rpps$core$impl$RppsHelper == null ? (class$org$eclipse$higgins$rpps$core$impl$RppsHelper = RppsHelper.class$("org.eclipse.higgins.rpps.core.impl.RppsHelper")) : class$org$eclipse$higgins$rpps$core$impl$RppsHelper));
    static /* synthetic */ Class class$org$eclipse$higgins$rpps$core$impl$RppsHelper;

    public static X509Certificate[] parseSSLCert(String soapval) {
        X509Certificate[] sslCert = null;
        if (soapval == null || soapval.trim().length() == 0) {
            return null;
        }
        String[] a = soapval.split(",");
        if (a != null) {
            try {
                byte[] ssl = new byte[a.length];
                for (int j = 0; j < a.length; ++j) {
                    ssl[j] = (byte)Integer.parseInt(a[j]);
                }
                ByteArrayInputStream bis = new ByteArrayInputStream(ssl);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                Collection<? extends Certificate> colSert = cf.generateCertificates(bis);
                int index = 0;
                sslCert = new X509Certificate[colSert.size()];
                Iterator<? extends Certificate> iter = colSert.iterator();
                while (iter.hasNext()) {
                    sslCert[index] = (X509Certificate)iter.next();
                    ++index;
                }
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return sslCert;
    }

    public static CallbackHandler getCallbackHandler(final String userId, final String password) {
        return new CallbackHandler(){

            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] instanceof NameCallback) {
                        NameCallback n = (NameCallback)callbacks[i];
                        n.setName(userId);
                        continue;
                    }
                    if (!(callbacks[i] instanceof PasswordCallback)) continue;
                    PasswordCallback p = (PasswordCallback)callbacks[i];
                    p.setPassword(password.toCharArray());
                }
            }
        };
    }

    public static CallbackHandler getCallbackHandler(final String userId) {
        return new CallbackHandler(){

            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (!(callbacks[i] instanceof NameCallback)) continue;
                    NameCallback n = (NameCallback)callbacks[i];
                    n.setName(userId);
                }
            }
        };
    }

    public static Properties loadProperties(String[] properties) {
        Properties props = new Properties();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            for (int i = 0; i < properties.length; ++i) {
                os.write(properties[i].getBytes());
                os.write(13);
                os.write(10);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            props.load(new ByteArrayInputStream(os.toByteArray()));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return props;
    }

    public static ICardTemplate fillICardTemplate_from_ICardTemplateTO(ICardTemplate[] templates, ICardTemplateTO templeteTO) {
        ICardTemplate template = null;
        if (templates != null) {
            for (int index = 0; index < templates.length; ++index) {
                if (!templates[index].getCardType().getName().equalsIgnoreCase(templeteTO.getCardType())) continue;
                template = templates[index];
                template.setDescription(templeteTO.getDescription());
                template.setDisplayName(templeteTO.getName());
                int size = templeteTO.getElements().length;
                for (int i = 0; i < size; ++i) {
                    ITemplateElement element = template.getTemplateElementByID(templeteTO.getElements()[i].getId());
                    if (element == null) continue;
                    if (element instanceof ITemplateValue) {
                        RppsHelper.fillITemplateValue((ITemplateValue)element, templeteTO.getElements()[i].getValue());
                        continue;
                    }
                    RppsHelper.fillITemplateContainer((ITemplateContainer)element, templeteTO.getElements()[i].getContainerValue());
                }
            }
        }
        return template;
    }

    public static void fillITemplateValue(ITemplateValue element, String elementTOValue) {
        if (element != null) {
            element.setValue(elementTOValue);
        }
    }

    public static void fillITemplateContainer(ITemplateContainer root, ITemplateElementTO[] elementsTO) {
        if (root != null) {
            int size = elementsTO.length;
            for (int i = 0; i < size; ++i) {
                ITemplateElement element = root.getTemplateElementByID(elementsTO[i].getId());
                if (element == null) continue;
                if (element instanceof ITemplateValue) {
                    RppsHelper.fillITemplateValue((ITemplateValue)element, elementsTO[i].getValue());
                    continue;
                }
                RppsHelper.fillITemplateContainer((ITemplateContainer)element, elementsTO[i].getContainerValue());
            }
        }
    }

    public static ICardTemplate fillPersonalCardTemplate(ICardTemplate template, String cardname, String surname, String givenname, String emailaddress, String streetaddress, String locality, String stateorprovince, String postalcode, String country, String homephone, String otherphone, String mobilephone, String dateofbirth, String gender, String webpage) {
        if (template != null) {
            ITemplateValue elementCardName = (ITemplateValue)template.getTemplateElementByID("cardName");
            elementCardName.setValue(cardname);
            ITemplateContainer elementClaimList = (ITemplateContainer)template.getTemplateElementByID("claimList");
            ITemplateValue elementSurName = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname");
            elementSurName.setValue(surname);
            ITemplateValue elementGivenName = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname");
            elementGivenName.setValue(givenname);
            ITemplateValue elementEmailAddress = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress");
            elementEmailAddress.setValue(emailaddress);
            ITemplateValue elementStreetAddress = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/streetaddress");
            elementStreetAddress.setValue(streetaddress);
            ITemplateValue elementlocality = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/locality");
            elementlocality.setValue(locality);
            ITemplateValue elementstateorprovince = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/stateorprovince");
            elementstateorprovince.setValue(stateorprovince);
            ITemplateValue elementpostalcode = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/postalcode");
            elementpostalcode.setValue(postalcode);
            ITemplateValue elementcountry = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/country");
            elementcountry.setValue(country);
            ITemplateValue elementhomephone = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/homephone");
            elementhomephone.setValue(homephone);
            ITemplateValue elementotherphone = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/otherphone");
            elementotherphone.setValue(otherphone);
            ITemplateValue elementmobilephone = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/mobilephone");
            elementmobilephone.setValue(mobilephone);
            ITemplateValue elementdateofbirth = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/dateofbirth");
            elementdateofbirth.setValue(dateofbirth);
            ITemplateValue elementgender = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/gender");
            elementgender.setValue(gender);
            ITemplateValue elementwebpage = (ITemplateValue)elementClaimList.getTemplateElementByID("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/webpage");
            elementwebpage.setValue(webpage);
        }
        return template;
    }

    public static boolean equalsObject(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 != null && obj2 == null || obj1 == null && obj2 != null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public static KeyStore loadKeyStore(String filename) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        FileInputStream is = new FileInputStream(filename);
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        String password = "changeit";
        keystore.load(is, password.toCharArray());
        return keystore;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

