/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.rpps.core.utils;

import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class EmailUtils {
    private static final String BUNDLE_NAME = "org.eclipse.higgins.rpps.core.utils.email";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("org.eclipse.higgins.rpps.core.utils.email");

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return String.valueOf('!') + key + '!';
        }
    }

    public void sendPasswordResetCode(String emailAddres, String code) throws UnsupportedEncodingException, MessagingException {
        Properties props = this.getSMTPPropertie(EmailUtils.getString("email.smtp.host"), EmailUtils.getString("email.smtp.port"));
        Session session = this.getEmailSession(EmailUtils.getString("email.smtp.user"), EmailUtils.getString("email.smtp.password"), props);
        this.sendEmailMessage(EmailUtils.getString("email.header.from"), EmailUtils.getString("email.header.personal.from"), emailAddres, EmailUtils.getString("email.header.subj.reset_code"), MessageFormat.format(EmailUtils.getString("email.body.reset_code"), code), EmailUtils.getString("email.encoding"), session);
    }

    public void sendPasswordUpdatedEmail(String emailAddres) throws UnsupportedEncodingException, MessagingException {
        if (emailAddres != null) {
            Properties props = this.getSMTPPropertie(EmailUtils.getString("email.smtp.host"), EmailUtils.getString("email.smtp.port"));
            Session session = this.getEmailSession(EmailUtils.getString("email.smtp.user"), EmailUtils.getString("email.smtp.password"), props);
            this.sendEmailMessage(EmailUtils.getString("email.header.from"), EmailUtils.getString("email.header.personal.from"), emailAddres, EmailUtils.getString("email.header.subj.password_updated"), EmailUtils.getString("email.body.password_updated"), EmailUtils.getString("email.encoding"), session);
        }
    }

    private Properties getSMTPPropertie(String host, String port) {
        Properties props = new Properties();
        props.put("mail.smtp.host", host);
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.auth", "true");
        props.put("mail.debug", "false");
        props.put("mail.smtp.port", port);
        return props;
    }

    private Session getEmailSession(final String smtpUserName, final String smtpPassword, Properties props) {
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(smtpUserName, smtpPassword);
            }
        });
        return session;
    }

    private void sendEmailMessage(String from, String personalFrom, String to, String subject, String body, String encoding, Session session) throws UnsupportedEncodingException, MessagingException {
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(from, personalFrom, encoding));
        msg.setRecipients(Message.RecipientType.TO, (Address[])EmailUtils.convertStringToInternetAddress(to));
        msg.setSentDate(new Date());
        msg.setSubject(subject, encoding);
        msg.setContent((Object)body, "text/html; charset=" + encoding);
        session.getTransport("smtp");
        Transport.send((Message)msg);
    }

    private static InternetAddress[] convertStringToInternetAddress(String emailAddress) {
        ArrayList<InternetAddress> addressList = new ArrayList<InternetAddress>();
        StringTokenizer st = new StringTokenizer(emailAddress, " ,;");
        while (st.hasMoreTokens()) {
            try {
                addressList.add(new InternetAddress(st.nextToken()));
            }
            catch (AddressException ae) {
                ae.printStackTrace();
            }
        }
        InternetAddress[] address = new InternetAddress[addressList.size()];
        addressList.toArray(address);
        return address;
    }
}

