/*
 * Copyright (c) 2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Artem Verkhovets - initial API and implementation
 */

package org.eclipse.higgins.rpps.core.tobj;

import java.io.Serializable;

/**
 * The transfer object for the token response. A transfer object is a serializable class that groups related attributes, 
 * forming a composite value. This class is used as the return type of a WS business method.
 * @author Sergei Yakovlev
 */
public class ExtraTokenResponseTO implements Serializable {
	
	private static final long serialVersionUID = -7407593829356382227L;
	
	private byte[] cardImage;
	private String cardImageType;
	private String cardName;
	private String cardDescription;
	private String tkn;
	private String	name;
	
	/** Creates a new instance of TokenResponseTO */
	public ExtraTokenResponseTO() {
		super();
	}

	public byte[] getCardImage() {
		return cardImage;
	}

	public void setCardImage(byte[] cardImage) {
		this.cardImage = cardImage;
	}

	public String getCardImageType() {
		return cardImageType;
	}

	public void setCardImageType(String cardImageType) {
		this.cardImageType = cardImageType;
	}

	public String getCardDescription() {
		return cardDescription;
	}

	public void setCardDescription(String cardDescription) {
		this.cardDescription = cardDescription;
	}

	public String getCardName() {
		return cardName;
	}

	public void setCardName(String cardName) {
		this.cardName = cardName;
	}

	public String getTkn() {
		return tkn;
	}

	public void setTkn(String tkn) {
		this.tkn = tkn;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
}