/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Artem Verkhovets - initial API and implementation
 */
package org.eclipse.higgins.rpps.core.tobj;

import java.io.Serializable;

public class ICardResponseTO implements Serializable{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 412520621300793194L;
	private ICardTO[] iCardList=null;
	MapTO [] relationList=null;
	private int code;
	private String message;
	         
	public int getCode() {
		return code;
	}

	public void setCode(int code) {
		this.code = code;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public ICardResponseTO()
	{
		setICardList(new ICardTO[0]);
		setRelationList(new MapTO[0]);
	}
	
	public ICardResponseTO(ICardTO [] iCardList)
	{
		this();
		setICardList(iCardList);
	}
	
	public ICardResponseTO(ICardTO [] iCardList, MapTO [] relationList)
	{
		this(iCardList);
		setRelationList(relationList);
	}

	public ICardResponseTO(int code,String message)
	{
		setCode(code);
		setMessage(message);
	}

	public ICardTO[] getICardList() {
		return iCardList;
	}

	public void setICardList(ICardTO[] iCardList) {
		this.iCardList = iCardList;
	}

	public MapTO[] getRelationList() {
		return relationList;
	}

	public void setRelationList(MapTO[] relationList) {
		this.relationList = relationList;
	}
}
