/**
 * Copyright (c) 2008 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html
 *  
 * Contributors: 
 * Alexander Yuhimenko -  initial API and implementation
 * 
 */
package org.eclipse.higgins.rpps.core.tobj;

import java.io.Serializable;

import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;

/**
 * The following faults MAY occur when requesting Security Tokens from an IdP using M-Information Cards.
 * 
 * @author Alexander Yuhimenko
 * 
 */
public class StsFaultException extends SOAPFaultException implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * SOAP action
	 */
	private String action;

	/**
	 *SOAP code.
	 */
	private String code;

	/**
	 * SOAP 1.2 subcode.
	 */
	private String subcode;
	/**
	 *SOAP reason
	 */
	private String reason;

	/**
	 *SOAP detailMessage
	 */
	private String detailMessage;

	/**
	 * default constructor
	 */
	public StsFaultException() {
		super(new QName("urn:RPPSService/wsdlRPPSService", StsFaultException.class.getName()), "", "RPPSService", null);
	}

	public String getAction() {
		return action;
	}

	public String getCode() {
		return code;
	}

	public String getDetailMessage() {
		return detailMessage;
	}

	public String getReason() {
		return reason;
	}

	public String getSubcode() {
		return subcode;
	}

	public void setAction(String action) {
		this.action = action;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public void setDetailMessage(String detailMessage) {
		this.detailMessage = detailMessage;
	}

	public void setReason(String reason) {
		this.reason = reason;
	}

	public void setSubcode(String subcode) {
		this.subcode = subcode;
	}

}
