/*
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Sergei Yakovlev - initial API and implementation
 */

package org.eclipse.higgins.rpps.core.tobj;

import java.io.Serializable;

/**
 * The transfer object for the CARD element of UserInterfaceResponse. A transfer object is a serializable class that
 * groups related attributes, forming a composite value. This class is used as the return type of a WS business method.
 * 
 * @author Sergei Yakovlev
 */
public class UIResponseCardTO implements Serializable {

	private static final long serialVersionUID = -8628665910350011063L;

	private String cardId;
	/**
	 * Saved for compatibility with old version of selector. Must be deleted.
	 * 
	 * @deprecated
	 */
	private String uid;

	private String description;

	private byte[] image;

	private String imagetype;

	private boolean saveCard = false;

	private PropertyTO[] properties;

	private PropertyTO[] optionalClaims;

	private UITokenServiceCredentialTO[] tokenservices;

	private String[] supportedClaimTypes;

	private String	name;
	
	private String issuerName;
	
	private String	type;

	/** Creates a new instance of UIResponseCardTO */
	public UIResponseCardTO() {
		super();
	}

	/**
	 * Gets the UID property value.
	 * 
	 * @return the UID property value.
	 */
	public String getCardId() {
		return cardId;
	}

	/**
	 * Sets the UID property value.
	 * 
	 * @param uid the UID property value.
	 */
	public void setCardId(String uid) {
		this.cardId = uid;
	}

	/**
	 * Gets the description property value.
	 * 
	 * @return the description property value.
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * Sets the description property value.
	 * 
	 * @param description the description property value.
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * Gets the image as a byte array.
	 * 
	 * @return the image as a byte array.
	 */
	public byte[] getImage() {
		return image;
	}

	/**
	 * Sets the image as a byte array.
	 * 
	 * @param image the image as a byte array.
	 */
	public void setImage(byte[] image) {
		this.image = image;
	}

	/**
	 * Gets the image type.
	 * 
	 * @return the image type.
	 */
	public String getImagetype() {
		return imagetype;
	}

	/**
	 * Sets the image type.
	 * 
	 * @param imagetype the image type.
	 */
	public void setImagetype(String imagetype) {
		this.imagetype = imagetype;
	}

	public UITokenServiceCredentialTO[] getTokenservices() {
		return tokenservices;
	}

	public void setTokenservices(UITokenServiceCredentialTO[] tokenservices) {
		this.tokenservices = tokenservices;
	}

	public boolean isSaveCard() {
		return saveCard;
	}

	public void setSaveCard(boolean saveCard) {
		this.saveCard = saveCard;
	}

	public PropertyTO[] getProperties() {
		return properties;
	}

	public void setProperties(PropertyTO[] properties) {
		this.properties = properties;
	}

	public PropertyTO[] getOptionalClaims() {
		return optionalClaims;
	}

	public void setOptionalClaims(PropertyTO[] optionalClaims) {
		this.optionalClaims = optionalClaims;
	}

	public String[] getSupportedClaimTypes() {
		return supportedClaimTypes;
	}

	public void setSupportedClaimTypes(String[] supportedClaimTypes) {
		this.supportedClaimTypes = supportedClaimTypes;
	}

	/**
	 * Gets the name of transfer object.
	 * 
	 * @return the name of transfer object.
	 */
	public String getName() {
		return name;
	}

	/**
	 * Sets the name of transfer object
	 * 
	 * @param name
	 *            the name of transfer object.
	 */
	public void setName(String name) {
		this.name = name;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getIssuerName() {
		return issuerName;
	}

	public void setIssuerName(String issuerName) {
		this.issuerName = issuerName;
	}

	public String getUid() {
		return uid;
	}

	public void setUid(String uid) {
		this.uid = uid;
	}
}