/*
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Sergei Yakovlev - initial API and implementation
 */

package org.eclipse.higgins.rpps.core.tobj;

import java.io.Serializable;

/**
 * The transfer object for the USABLECARDS element of UserInterfaceResponse. A transfer object is a serializable class that groups related attributes, 
 * forming a composite value. This class is used as the return type of a WS business method.
 * @author Sergei Yakovlev
 */
public class UIResponseUsableCardsTO implements Serializable {
	
	private static final long serialVersionUID = -8239760614180039137L;
	private UIResponseCardTO[] card;
	private String	name;
	
	/** Creates a new instance of UIResponseUsableCardsTO */
	public UIResponseUsableCardsTO() {
		super();
	}

	/**
	 * Gets the array of CARD element.
	 * @return the array of CARD element.
	 */
	public UIResponseCardTO[] getCard() {
		return card;
	}
	
	/**
	 * Sets the array of CARD element.
	 * @param card the array of CARD element.
	 */
	public void setCard(UIResponseCardTO[] card) {
		this.card = card;
	}

	/**
	 * Gets the name of transfer object.
	 * 
	 * @return the name of transfer object.
	 */
	public String getName() {
		return name;
	}

	/**
	 * Sets the name of transfer object
	 * 
	 * @param name
	 *            the name of transfer object.
	 */
	public void setName(String name) {
		this.name = name;
	}
	
}