/** 
 * Copyright (c) 2008 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko -  initial API and implementation
 * 
 */
package org.eclipse.higgins.rpps.core.utils;

import java.net.URI;
import java.net.URLDecoder;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.userprofile.entity.WebForm;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class Utils {
	private static final Log LOG = LogFactory.getLog(Utils.class);

	/**
	 * Remove query from url
	 * 
	 * @param url
	 * @return url without query
	 */
	public static String cleanURLQuery(final String url) {
		// remove query from url
		try {
			LOG.trace("in URL:" + url);
			String decodedUrl = URLDecoder.decode(url, "utf-8");
			LOG.trace("decodedURL:" + decodedUrl);
			URI query = new URI(decodedUrl);
			if (null != query.getQuery()) {
				String res = decodedUrl.substring(0, decodedUrl.indexOf(query.getQuery()) - 1);
				LOG.trace("clean URL:" + res);
				return res;
			}
		} catch (Exception e) {
			LOG.error(e, e);
		}
		return url;
	}

	/**
	 * Remove query from url
	 * 
	 * @param webForm
	 */
	public static void cleanURLQuery(final WebForm webForm) {
		// remove query from url
		try {
			if (null != webForm && null != webForm.getUrl()) {
				String cleanUrl = cleanURLQuery((webForm.getUrl().toString()));
				webForm.setUrl(new URI(cleanUrl));
			}
		} catch (Exception e) {
			LOG.error(e, e);
		}
	}

}
