/**
 * Copyright (c) 2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Artem Verkhovets - initial API and implementation
 */
package org.eclipse.higgins.rpps.core.tobj;

import java.io.Serializable;

public class ICardsAndCategoryTO implements Serializable 
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 3121626147095451542L;
	
	private CategoryTO [] categoryList=null;
	private ICardTO[] iCardList=null;
	MapTO [] relationList=null;
	private int code;
	private String message;
	
	public ICardsAndCategoryTO()
	{
		setICardList(new ICardTO[0]);
		setCategoryList(new CategoryTO[0]);
	}
	
	public ICardsAndCategoryTO(ICardTO[] icardList, CategoryTO [] categoryList)
	{
		super();
		setICardList(icardList);
		setCategoryList(categoryList);
	}
	
	public CategoryTO[] getCategoryList() {
		return categoryList;
	}
	public void setCategoryList(CategoryTO[] categoryList) {
		this.categoryList = categoryList;
	}

	public ICardTO[] getICardList() {
		return iCardList;
	}

	public void setICardList(ICardTO[] cardList) {
		iCardList = cardList;
	}

	public int getCode() {
		return code;
	}

	public void setCode(int code) {
		this.code = code;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public MapTO[] getRelationList() {
		return relationList;
	}

	public void setRelationList(MapTO[] relationList) {
		this.relationList = relationList;
	}
}
