<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ page import="org.eclipse.higgins.saml2idp.saml2.SAMLAuthnRequest" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<!-- 
/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
 -->
<html>

<head>
	<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">
	<title>SAML2 IdP - LDAP Login</title>
	<link rel="stylesheet" type="text/css" href="css/main.css">
</head>

<body>

	<img id="logo" src="images/logo.png">

	<h1>SAML2 IdP - LDAP Login</h1>

	<!-- Any error message to display? -->
	
	<% if (request.getAttribute("error") != null) { %>
	
		<p class="error"><%= request.getAttribute("error") %></p>
	
	<% } %>
	
	<!-- Display some info about the request. -->

	<% if (request.getAttribute("authnrequest") != null) { %>

		<% SAMLAuthnRequest samlAuthnRequest = (SAMLAuthnRequest) request.getAttribute("authnrequest"); %>

		<p class="info"><strong>Request Issuer:</strong> <%= samlAuthnRequest.getIssuer() %></p>

	<% } %>
	
	<hr><div style="clear:both"></div>
	
	<!-- Higgins contexts require different so-called authentication materials. -->
	<!-- In this case (LDAP) we need a username and password. -->
	
	<form action="LDAPLogin" method="post">
	
		<% if (request.getAttribute("relaystate") != null) { %>
			<input type="hidden" name="relaystate" value="<%= request.getAttribute("relaystate") %>">
		<% } %>
	
		<% if (request.getAttribute("destination") != null) { %>
			<input type="hidden" name="destination" value="<%= request.getAttribute("destination") %>">
		<% } %>
	
		<p>
		Username:&nbsp;
		<input type="text" name="username">
		</p>
		
		<p>
		Password:&nbsp;
		<input type="password" name="password">
		</p>
	
		<p><input type="submit" value="Login"></p>
	
	</form>

</body>

</html>
