/*******************************************************************************
 * Copyright (c) 2007 Google
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.saml2idp.server.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.eclipse.higgins.saml2idp.server.Init;

public class ExtractUtil {

	/**
	 * Make constructor private since we only use static methods in this util class.
	 */
	private ExtractUtil() {

	}

	/**
	 * Extracts a username from a request. If one is found, no login forms are displayed,
	 * and the user is considered to be authenticated already.
	 * This is done by checking for parameters, headers and cookies with a certain name
	 * provided in the configuration.
	 * @param request The current HttpServletRequest object.
	 * @param response The current HttpServletResponse object.
	 * @return The username that was extracted from the request.
	 */
	public static String getUser(HttpServletRequest request, HttpServletResponse response) {

		String extractUsernameParameterName = Init.getExtractUsernameParameterName();
		String extractUsernameHeaderName = Init.getExtractUsernameHeaderName();
		String extractUsernameCookieName = Init.getExtractUsernameCookieName();

		// look for a username in the parameters

		if (extractUsernameParameterName != null && extractUsernameParameterName.length() > 0) {

			String username = request.getParameter(extractUsernameParameterName);
			if (username != null) return(username);
		}

		// look for a username in the headers

		if (extractUsernameHeaderName != null && extractUsernameHeaderName.length() > 0) {

			String username = request.getHeader(extractUsernameHeaderName);
			if (username != null) return(username);
		}

		// look for a username in the cookies

		if (extractUsernameCookieName != null && extractUsernameCookieName.length() > 0) {

			Cookie[] cookies = request.getCookies();
			
			if (cookies != null) {
				
				for (int i=0; i<cookies.length; i++) {
	
					Cookie cookie = cookies[i];
					if (cookie.getName().equals(extractUsernameCookieName)) {
	
						String username = cookie.getValue();
						if (username != null) return(username);
					}
				}
			}
		}

		// nothing found

		return(null);
	}
}
