package org.eclipse.higgins.saml2idp.server.card;

import java.util.Iterator;
import java.util.List;

import org.eclipse.higgins.rp.tokens.RPClaim;
import org.eclipse.higgins.rp.tokens.RPClaimType;
import org.eclipse.higgins.rp.tokens.RPSecurityToken;

public class SurNameCardHandler implements ICardHandler {

	public String getIssuer() {

		return("rh157.azigo.net");
	}

	public String getIssuerPolicy() {

		return(null);
	}

	public String getTokenType() {

		return("urn:oasis:names:tc:SAML:1.0:assertion");
	}

	public String getRequiredClaims() {

		return("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname");
	}

	public String getOptionalClaims() {

		return("");
	}

	public String getPrivacyUrl() {

		return(null);
	}

	public String getPrivacyVersion() {

		return(null);
	}

	public String handleCard(RPSecurityToken token) {

		List claims = token.getClaims();
		String surname = null;

		for (Iterator i=claims.iterator(); i.hasNext(); ) {

			RPClaim claim = (RPClaim) i.next();
			RPClaimType claimType = claim.getType();

			if (claimType.getDisplayName().equalsIgnoreCase("surname")) surname = ((String) claim.getValues().next());
		}

		if (surname == null) throw new RuntimeException("surname claim missing.");

		return(surname.toLowerCase());
	}
}
