/*******************************************************************************
 * Copyright (c) 2008 Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.saml2idp.server.util;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.rp.DispatchCallback;
import org.eclipse.higgins.rp.ResultCallback;
import org.eclipse.higgins.rp.icard.ICardProtocolHandler;
import org.eclipse.higgins.rp.icard.server.ICardConstants;
import org.eclipse.higgins.rp.servlet.impl.SessionContextImpl;
import org.eclipse.higgins.rp.tokens.RPSecurityToken;
import org.eclipse.higgins.saml2idp.server.Init;
import org.eclipse.higgins.saml2idp.server.card.CardLogin;

public class CardUtil {

	private static final Log log = LogFactory.getLog(CardLogin.class);

	private CardUtil() {

	}

	public static RPSecurityToken decodeToken(String xmlToken, HttpSession session) {

		log.info("Trying to decode token: " + xmlToken);

		if (xmlToken == null || xmlToken.trim().equals("")) return(null);

		Map processMap = new HashMap();
		processMap.put("xmlToken", new String[] { xmlToken });
		Map initMap = new HashMap();
		initMap.put(ICardConstants.KEYSTORENAME, Init.getKeyStoreName());
		initMap.put(ICardConstants.KEYSTOREPW, Init.getKeyStorePw());
		initMap.put(ICardConstants.KEYSTORETYPE, Init.getKeyStoreType());
		initMap.put(ICardConstants.KEYSTOREKEYALIAS, Init.getKeyStoreAlias());
		final Wrapper wrapper = new Wrapper();

		ICardProtocolHandler icardProtocolHandler = new ICardProtocolHandler();
		ICardProtocolHandler.init(initMap);
		icardProtocolHandler.registerCallbacks(new ResultCallback() {

			public void handleFailure(int errCode) {

				throw new RuntimeException("Exception: " + errCode);
			}

			public void handleFailure(int errorCode, Throwable rootCause) {

				throw new RuntimeException("Exception: " + errorCode, rootCause);
			}

			public void handleSuccess(String protectedResource, final RPSecurityToken authenticationResult) {

				wrapper.setObject(authenticationResult);
			}
		}, new DispatchCallback() {

			public void forward(String targetLocation) {

				throw new RuntimeException("Forward: " + targetLocation);
			}

			public void redirect(String externalLocation) {

				throw new RuntimeException("Redirect: " + externalLocation);
			}
		}, new SessionContextImpl(session));
		icardProtocolHandler.processUserToken(processMap);

		return((RPSecurityToken) wrapper.getObject());
	}

	private static class Wrapper {

		Object object;

		private void setObject(Object object) {

			this.object = object;
		}

		private Object getObject() {

			return(this.object);
		}
	}
}
