/**
 * 
 */
package org.eclipse.higgins.sts.api;

/**
 * @author mikemci
 */
public interface IClaim
{
	public abstract void setType
		(final IClaimType claimType);
	
	public abstract void setMetadata
		(final IMetadata metadata);
	
    /**
    * Type of a claim (e.g., principal, group, role, email, age, etc)
    */
	public abstract IClaimType getType();
	
    /**
     * Value(s) of the claim. It can be a string (eg name), or a complex object itself depending on the type (e.g., contact info claim can contain address, phone, etc which can be individual claims themselves)
     */
	public abstract java.util.Iterator getValues();

	public abstract void addValue
		(final String strValue);
	
    /**
     * This can contain the information about claim (e.g., source, authority who claimed it, validity information if any, etc)
     */
	public abstract IMetadata getMetadata();
	
	/**
	 * 
	 */
	public abstract Object getSerialized();
}
