/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.api;

/**
 * Interface representing a set of URI values
 * (representing specific specification/schema versions)
 * 
 * @author mikemci at us dot ibm dot com
 */
public interface IConstants
{	
	/**
	 * Gets the AsymmetricKey BinarySecretType URI
	 * 
	 * @return the AsymmetricKey BinarySecretType URI
	 */
	public abstract java.net.URI getAsymmetricKeyBinarySecretType();

	/**
	 * Gets the Asymmetric KeyType URI
	 *  
	 * @return the Asymmetric KeyType URI
	 */
	public abstract java.net.URI getAsymmetricKeyType();

	/**
	 * Gets the AuthenticationBadElements FaultCode
	 * 
	 * @return the AuthenticationBadElements FaultCode
	 */
	public abstract String getAuthenticationBadElementsFaultCode();

	/**
	 * Gets the BadRequest FaultCode 
	 * 
	 * @return the BadRequest FaultCode 
	 */
	public abstract String getBadRequestFaultCode();
	
	public abstract java.net.URI getIdentityClaimsNamespace();
	
	public abstract java.net.URI getIdentityClaimPrivatePersonalIdentifier();

	/**
	 * Gets the Cancel Request Action URI
	 * 
	 * @return the CancelRequest Action URI
	 */
	public abstract java.net.URI getCancelRequestAction();

	/**
	 * Gets the Cancel RequestType URI
	 * 
	 * @return the Cancel RequestType URI
	 */
	public abstract java.net.URI getCancelRequestType();

	/**
	 * Gets the Cancel Response Action URI
	 * 
	 * @return the Cancel Response Action URI
	 */
	public abstract java.net.URI getCancelResponseAction();

	/**
	 * Gets the ExpiredData FaultCode
	 * 
	 * @return the ExpiredData FaultCode
	 */
	public abstract String getExpiredDataFaultCode();

	/**
	 * Gets the FailedAuthentication FaultCode
	 * 
	 * @return the FailedAuthentication FaultCode
	 */
	public abstract String getFailedAuthenticationFaultCode();

	/**
	 * Gets the Hash ComputedKey URI
	 * 
	 * @return the Hash ComputedKey URI
	 */
	public abstract java.net.URI getHashComputedKey();

	/**
	 * Gets the InvalidRequest FaultCode
	 * 
	 * @return the InvalidRequest FaultCode
	 */
	public abstract String getInvalidRequestFaultCode();

	/**
	 * Gets the InvalidScope FaultCode
	 * 
	 * @return the InvalidScope FaultCode
	 */
	public abstract String getInvalidScopeFaultCode();

	/**
	 * Gets the InvalidSecurityToken FaultCode
	 * 
	 * @return the InvalidSecurityToken FaultCode
	 */
	public abstract String getInvalidSecurityTokenFaultCode();

	/**
	 * Gets the Invalid StatusCode URI
	 * 
	 * @return the Invalid StatusCode URI
	 */
	public abstract java.net.URI getInvalidStatusCode();

	/**
	 * Gets the InvalidTimeRange FaultCode
	 * 
	 * @return the InvalidTimeRange FaultCode
	 */
	public abstract String getInvalidTimeRangeFaultCode();

	/**
	 * Gets the Issue Request Action URI
	 * 
	 * @return the IssueRequest Action URI
	 */
	public abstract java.net.URI getIssueRequestAction();

	/**
	 * Gets the Issue RequestType URI
	 * 
	 * @return the Issue RequestType URI
	 */
	public abstract java.net.URI getIssueRequestType();

	/**
	 * Gets the Issue Response Action URI
	 * 
	 * @return the Issue Response Action URI
	 */
	public abstract java.net.URI getIssueResponseAction();

	/**
	 * Gets the Issuer Self URI
	 * 
	 * @return the Issuer Self URI
	 */
	public abstract java.net.URI getIssuerSelf();

	/**
	 * Gets the KeyExchange Request Action URI
	 * 
	 * @return the KeyExchange Request Action URI
	 */
	public abstract java.net.URI getKeyExchangeRequestAction();

	/**
	 * Gets the KeyExchange RequestType URI
	 * 
	 * @return the KeyExchange RequestType URI
	 */
	public abstract java.net.URI getKeyExchangeRequestType();

	/**
	 * Gets the KeyExchange Response Action URI
	 * 
	 * @return the KeyExchange Response Action URI
	 */
	public abstract java.net.URI getKeyExchangeResponseAction();

	/**
	 * Gets the Nonce BinarySecret Type URI
	 * 
	 * @return the Nonce BinarySecret Type URI
	 */
	public abstract java.net.URI getNonceBinarySecretType();

	/**
	 * Gets the PSHA1 ComputedKey URI
	 * 
	 * @return the PSHA1 ComputedKey URI
	 */
	public abstract java.net.URI getPSHA1ComputedKey();

	/**
	 * Gets the RenewNeeded FaultCode
	 * 
	 * @return the RenewNeeded FaultCode
	 */
	public abstract String getRenewNeededFaultCode();

	/**
	 * Gets the Renew Request Action URI
	 * 
	 * @return the Renew Request Action URI
	 */
	public abstract java.net.URI getRenewRequestAction();

	/**
	 * Gets the Renew RequestType URI
	 * 
	 * @return the Renew RequestType URI
	 */
	public abstract java.net.URI getRenewRequestType();

	/**
	 * Gets the Renew Response Action URI
	 * 
	 * @return the Renew Response Action URI
	 */
	public abstract java.net.URI getRenewResponseAction();

	/**
	 * Gets the RequestFailed FaultCode QName
	 * 
	 * @return RequestFailed FaultCode QName
	 */
	public abstract String getRequestFailedFaultCode();

	/**
	 * Gets the Status TokenType URI
	 * 
	 * @return the Status TokenType URI
	 */
	public abstract java.net.URI getStatusTokenType();

	/**
	 * Gets the SymmetricKey BinarySecretType URI
	 * 
	 * @return the SymmetricKey BinarySecretType URI
	 */
	public abstract java.net.URI getSymmetricKeyBinarySecretType();

	/**
	 * Gets the Symmetric KeyType URI
	 * 
	 * @return the Symmetric KeyType URI
	 */
	public abstract java.net.URI getSymmetricKeyType();

	/**
	 * Gets the UnableToRenew FaultCode
	 * 
	 * @return the UnableToRenew FaultCode 
	 */
	public abstract String getUnableToRenewFaultCode();

	/**
	 * Gets the Validate Request Action URI
	 * 
	 * @return the Validate Request Action URI
	 */
	public abstract java.net.URI getValidateRequestAction();

	/**
	 * Gets the Validate RequestType URI
	 * 
	 * @return the Validate RequestType URI
	 */
	public abstract java.net.URI getValidateRequestType();

	/**
	 * Gets the Validate Response Action URI
	 * 
	 * @return the Validate Response Action URI
	 */
	public abstract java.net.URI getValidateResponseAction();

	/**
	 * Gets the Valid StatusCode URI
	 * 
	 * @return the Valid StatusCode URI
	 */
	public abstract java.net.URI getValidStatusCode();

	/**
	 * Gets the WS-Addressing Namespace URI
	 * 
	 * @return the WS-Addressing Namespace URI
	 */
	public abstract java.net.URI getWSAddressingNamespace();

	/**
	 * Gets the WS-Policy Namespace URI
	 * 
	 * @return the WS-Policy Namespace URI
	 */
	public abstract java.net.URI getWSPolicyNamespace();
	
	/**
	 * Gets the WS-Security Namespace URI
	 * 
	 * @return the WS-Security Namespace URI
	 */
	public abstract java.net.URI getWSSecurityNamespace();

	/**
	 * Gets the WS-SecurityPolicy Namespace URI
	 * 
	 * @return the WS-SecurityPolicy Namespace URI
	 */
	public abstract java.net.URI getWSSecurityPolicyNamespace();

	/**
	 * Gets the WS-Security Utility Namespace URI
	 * 
	 * @return the WS-Security Utility Namespace URI
	 */
	public abstract java.net.URI getWSSecurityUtilityNamespace();

	/**
	 * Gets the WS-Trust Namespace URI
	 * 
	 * @return the WS-Trust Namespace URI
	 */
	public abstract java.net.URI getWSTrustNamespace();

	/**
	 * Gets the XML Encryption Namespace URI
	 * 
	 * @return the XML Encryption Namespace URI
	 */
	public abstract java.net.URI getXMLEncryptionNamespace();

	/**
	 * Gets the XML Signature Namespace URI
	 * 
	 * @return the XML Signature Namespace URI
	 */
	public abstract java.net.URI getXMLSignatureNamespace();

	public abstract java.net.URI getSAML10TokenType();
	
	public abstract java.net.URI getSAML10Namespace();
	
	public abstract java.net.URI getIdentityNamespace();
	
	public abstract java.net.URI getSAML10ConfirmationMethodHolderOfKey();

	public abstract java.net.URI getSAML10ConfirmationMethodBearer();

	public abstract java.net.URI getNoProofKeyKeyType();

	public abstract java.net.URI getAddressingIdentityNamespace();

	public abstract java.net.URI getSAML20Namespace();

	public abstract java.net.URI getSAML20TokenType();
}