/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.api;

import org.eclipse.higgins.sts.api.IProfile;

public interface IProfileService extends org.eclipse.higgins.configuration.api.IConfigurableComponent
{
	public abstract String decryptToken
		(final IConstants constants,
		final String strToken)
		throws Exception;
	
	public abstract String getManagedCard
		(final IConstants constants,
		final String strCardName,
		final String strUsername,
		final String strPassword,
		final String strCredentialType,
		final String strRequireAppliesTo,
		final String strToken)
		throws Exception;

	public abstract String createProfile
		(final IConstants constants,
		final String strUserIdentifier,
		final String strUserPassword)
		throws Exception;

	public abstract String getProfile
		(final IConstants constants,
		final String strUserIdentifier,
		final String strUserPassword,
		final IProfile profile)
		throws Exception;

	public abstract String deleteProfile
		(final IConstants constants,
		final String strUserIdentifier,
		final String strUserPassword)
		throws Exception;

	public abstract String modifyProfileSetCardKeyHash
		(final IConstants constants,
		final String strUserIdentifier,
		final String strUserPassword,
		final String strPPID,
		final String strModulus,
		final String strExponent)
		throws Exception;

	public abstract String modifyProfileSetX509SHA
	(final IConstants constants,
	final String strUserIdentifier,
	final String strUserPassword,
	final String strX509SHA)
	throws Exception;

	public abstract String modifyProfile
		(final IConstants constants,
		final String strUserIdentifier,
		final String strUserPassword,
		final IProfile profile)
		throws Exception;
}