/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.api;

/**
 * Interface representing the RequestSecurityToken 
 * 
 * @author mikemci at us dot ibm dot com
 */
public interface IRequestSecurityToken
{	
	public abstract IElement getClientPseudonym();
	
	public abstract void setClientPseudonym(final IElement clientPseudonym);
	
	public abstract IInformationCardReference getInformationCardReference();
	
	public abstract void setInformationCardReference(final IInformationCardReference informationCardReference);

	/**
	 * Gets the optional URI element that indicates desired algorithm to use when computed keys are used for issued tokens.
	 * 
	 * @return URI
	 */
	public abstract java.net.URI getComputedKeyAlgorithm();

	/**
	 * Gets the Digital Identity
	 * 
	 * @return the Digital Identity
	 */
	public abstract IDigitalIdentity getDigitalIdentity();
	
	/**
	 * Sets the Digital Identity
	 * 
	 * @param digitalSubject the Digital Identity
	 */
	public abstract void setDigitalIdentity(IDigitalIdentity digitalIdentity);

	/**
	 * Gets the optional URI that specifies an identifier/context for this request.
	 * 
	 * @return the Context URI
	 */
	public abstract String getContext();

	/**
	 * Gets the Base token
	 * 
	 * @return the Base
	 */
	public abstract IElement getBase();

	/**
	 * Gets the optional element that describes the type of security token requested, specified as a URI.
	 * 
	 * @return the TokenType
	 */
	public abstract java.net.URI getTokenType();
	
	/**
	 * Gets the RequestDisplayToken
	 * 
	 * @return the RequestDisplayToken
	 */
	public abstract IElement getRequestDisplayToken();

	/**
	 * Gets the required RequestType element that is used to indicate the type of function that is being requested, specified as a URI.  <br/>
	 * The values are defined by the WS-Trust specifications.
	 * 
	 * @return the RequestType
	 */
	public abstract java.net.URI getRequestType();

	/**
	 * Gets this optional element that specifies the scope for the service(s) to which this token applies.
	 * 
	 * @return the AppliesTo
	 */
	public abstract IAppliesTo getAppliesTo();

	/**
	 * Gets the required CancelTarget element that identifies the token to be cancelled.
	 * 
	 * @return the CancelTarget
	 */
	public abstract IElement getCancelTarget();

	/**
	 * Gets the required ValidateTarget element that identifies the token being validated. 
	 * 
	 * @return the ValidateTarget
	 */
	public abstract IElement getValidateTarget();

	/**
	 * Gets the required (when using a Renewal binding) RenewTarget element used when renewing an expired token.
	 * 
	 * @return the RenewTarget
	 */
	public abstract IElement getRenewTarget();

	/**
	 * Gets the Claims element that may be optional and/or required.  Optional or required is determined and defined by the requested service's policy.
	 * 
	 * @return the Claims
	 */
	public abstract IElement getClaims();

	/**
	 * Gets the optional Entropy element that allows a requestor to specify entropy that is to be used in creating the key.
	 * 
	 * @return the Entropy
	 */
	public abstract IElement getEntropy();

	/**
	 * Gets the Lifetime element that specifies the duration of time between creation and expiration that the request is valid.<br/>
	 * The issuer does not have to honour this and may return a more or less restrictive duration. 
	 * 
	 * @return the Lifetime
	 */
	public abstract ILifetime getLifetime();

	/**
	 * Gets the AllowPostdating element that indicates that returned tokens should allow requests for postdated tokens.
	 * 
	 * @return the AllowPostdating
	 */
	public abstract IElement getAllowPostdating();

	/**
	 * Gets optional Renewing element that is used to specify renew semantics for types that support this operation.
	 * 
	 * @return the Renewing
	 */
	public abstract IElement getRenewing();

	/**
	 * Gets the optional OnBehalfOf element that indicates that the requestor is making the request on behalf of another.
	 * 
	 * @return the OnBehalfOf
	 */
	public abstract IElement getOnBehalfOf();

	/**
	 * Gets the Issuer element EndpointReference of the issuer of the security token that is presented in the message.
	 * 
	 * @return the Issuer element EndpointReference
	 */
	public abstract IEndpointReference getIssuer();

	/**
	 * Gets the AuthenticationType
	 * 
	 * @return the AuthenticationType
	 */
	public abstract java.net.URI getAuthenticationType();

	/**
	 * Gets the optional URI element that indicates the type of key desired in this RequestSecurityToken.
	 * 
	 * @return the KeyType
	 */
	public abstract java.net.URI getKeyType();

	/**
	 * Gets the optional KeySize element that indicates the size of the key required specified in number of bits.
	 * 
	 * @return the KeySize
	 */
	public abstract Integer getKeySize();

	/**
	 * Gets optional URI element that indicates the desired SignatureAlgorithm used within the returned token.
	 * 
	 * @return the SignatureAlgorithm
	 */
	public abstract java.net.URI getSignatureAlgorithm();

	/**
	 * Gets the optional Encryption element that specifies that the requestor desires any returned secrets in issued 
	 * security tokens to be encrypted for the specified token.
	 * 
	 * @return the Encryption
	 */
	public abstract IElement getEncryption();

	/**
	 * Gets the optional EncryptionAlgorithm URI element that indicates the encryption algorithm used within the returned token.
	 * 
	 * @return the EncryptionAlgorithm
	 */
	public abstract java.net.URI getEncryptionAlgorithm();

	/**
	 * Gets the optional CanonicalizationAlgorithm URI element that indicates the canonicalization method used within the returned token.
	 * 
	 * @return the CanonicalizationAlgorithm
	 */
	public abstract java.net.URI getCanonicalizationAlgorithm();

	/**
	 * Gets the optional ProofEncryption element within the request.
	 * 
	 * @return the ProofEncryption
	 */
	public abstract IElement getProofEncryption();

	/**
	 * Gets the UseKey element that specifies which existing key to use, rather than creating a new one.
	 * 
	 * @return the UseKey
	 */
	public abstract IElement getUseKey();

	/**
	 * Gets the optional SignWith URI element that indicates the desired signature algorithm to be used with the issued security token.
	 * 
	 * @return the SignWith
	 */
	public abstract java.net.URI getSignWith();

	/**
	 * Gets the optional EncryptWith element that specifies the desired encryption algorithm to used with the issued security token.
	 * 
	 * @return the EncryptWith
	 */
	public abstract java.net.URI getEncryptWith();

	/**
	 * Gets the optional DelegateTo element.
	 * 
	 * @return the DelegateTo
	 */
	public abstract IElement getDelegateTo();

	/**
	 * Gets the Forwardable element
	 * 
	 * @return Boolean value representing whether the request is bound to the requestor's machine or service
	 */
	public abstract java.lang.Boolean getForwardable();

	/**
	 * Gets the Delegatable element which should be used in conjunction with the <code>&lt;wst:DelegateTo&gt;</code> element.
	 * 
	 * @return Boolean value representing whether the returned token MAY be delegated to another party
	 */
	public abstract java.lang.Boolean getDelegatable();

	/**
	 * Gets the optional Policy element that specifies a policy that indicates desired settings for the requested token.
	 * 
	 * @return the Policy
	 */
	public abstract IElement getPolicy();

	/**
	 * Gets the optional PolicyReference element that specifies a reference to a policy that indicates desired settings for the requested token.
	 * 
	 * @return the PolicyReference
	 */
	public abstract IElement getPolicyReference();

	/**
	 * Gets the list of any other elements (other than those explicitly named)
	 * 
	 * @return the list of any other elements (other than those explicitly named)
	 */
	public abstract java.util.List getAnyOtherElements();

	/**
	 * Gets the associated data object (this object is not serialized in the message)
	 * 
	 * @return the associated data object (this object is not serialized in the message)
	 */
	public abstract java.lang.Object getData();

	/**
	 * Sets the optional URI element that indicates desired algorithm to use when computed keys are used for issued tokens
	 * @param uriComputedKeyAlgorithm is the URI value of a defined computed key algorithm.<br/>
	 * Example URI:<br/>
	 * <code>new URI("http://schemas.xmlsoap.org/ws/2005/02/trust/CK/PSHA1")</code>
	 */
	public abstract void setComputedKeyAlgorithm(java.net.URI uriComputedKeyAlgorithm);

	/**
	 * Sets the Base token
	 * 
	 * @param elemBase the Base
	 */
	public abstract void setBase(IElement elemBase);

	/**
	 * Sets the optional element that describes the type of security token requested, specified as a URI.
	 * 
	 * @param uriTokenType is the URI of the TokenType<br/>
	 * An example of a SAML 1.0 TokenType URI:<br/>
	 * <code>urn:oasis:names:tc:SAML:1.0:assertion</code>
	 */
	public abstract void setTokenType(java.net.URI uriTokenType);

	/**
	 * Sets the RequestDisplayToken
	 * 
	 * @param elemRequestDisplayToken the RequestDisplayToken
	 */
	public abstract void setRequestDisplayToken(IElement elemRequestDisplayToken);

	/**
	 * Sets the required RequestType element that is used to indicate the type of function that is being requested, specified as a URI.  <br/>
	 * The values are defined by the WS-Trust specifications.<br/>
	 * An example of an 'Issue' RequestType URI, defined by the 2005-02 WS-Trust specification:<br/>
	 * <code>new URI("http://schemas.xmlsoap.org/ws/2005/02/trust/Issue")</code>
	 * 
	 * @param uriRequestType the RequestType
	 */
	public abstract void setRequestType(java.net.URI uriRequestType);

	/**
	 * Sets this optional element that specifies the scope for the service(s) to which this token applies.<br/>
	 * Note that at least, either this element (AppliesTo) or the TokenType element SHOULD be defined in a RequestSecurityToken message.<br/>
	 * 
	 * @param appliesTo the AppliesTo
	 */
	public abstract void setAppliesTo(IAppliesTo appliesTo);

	/**
	 * Sets the required (when using a Cancellation binding) CancelTarget element that identifies the token to be cancelled.
	 * 
	 * @param elemCancelTarget the CancelTarget
	 */
	public abstract void setCancelTarget(IElement elemCancelTarget);

	/**
	 * Sets the required (when using a Validation binding) ValidateTarget element that identifies the token being validated. 
	 * 
	 * @param elemValidateTarget is an IElement that typically contains <code>&lt;wsse:SecurityTokenReference&gt;</code> 
	 * pointing to the token, but may contain the token itself.
	 */
	public abstract void setValidateTarget(IElement elemValidateTarget);

	/**
	 * Sets the required (when using a Renewal binding) RenewTarget element used when renewing an expired token.
	 * 
	 * @param elemRenewTarget the RenewTarget
	 */
	public abstract void setRenewTarget(IElement elemRenewTarget);

	/**
	 * Sets the Claims element that may be optional and/or required.  Optional or required is determined and defined by the requested service's policy.<br/>
	 * Example of setting Claims:<br/>
	 * <code>
	 * String claims = &quot;&lt;wst:Claims Dialect='http://schemas.xmlsoap.org/ws/2005/05/identity' &quot; +
	 * &quot;xmlns:wst='http://schemas.xmlsoap.org/ws/2005/02/trust' &quot; +
	 * &quot;xmlns:cl='http://schemas.xmlsoap.org/ws/2005/05/identity'&gt;&quot; +
	 * &quot;&lt;username&gt;user1@example.com&lt;/username&gt;&quot; +
	 * &quot;&lt;issuer&gt;" + new URI(&quot;http://example.com&quot;) + &quot;&lt;/issuer&gt;" +
	 * &quot;&lt;/wst:Claims&gt;&quot;;
	 * <br/>
	 * IElement claimsElement = new Element();<br/>
	 * claimsElement.set(claims);<br/>
	 * rst.setClaims(claimsElement);<br/>
	 * </code>
	 * 
	 * @param elemClaims the Claims
	 */
	public abstract void setClaims(IElement elemClaims);

	/**
	 * Sets the optional Entropy element that allows a requestor to specify entropy that is to be used in creating the key.
	 * 
	 * @param elemEntropy the Entropy
	 */
	public abstract void setEntropy(IElement elemEntropy);

	/**
	 * Sets the Lifetime element that specifies the duration of time between creation and expiration that the request is valid.<br/>
	 * The issuer does not have to honour this and may return a more or less restrictive duration. 
	 * 
	 * @param ltLifetime the Lifetime element to be associated with the RequestSecurityToken element
	 */
	public abstract void setLifetime(org.eclipse.higgins.sts.api.ILifetime ltLifetime);

	/**
	 * Sets the AllowPostdating element that indicates that returned tokens should allow requests for postdated tokens. 
	 * 
	 * @param elemAllowPostdating
	 */
	public abstract void setAllowPostdating(IElement elemAllowPostdating);

	/**
	 * Sets optional Renewing element that is used to specify renew semantics for types that support this operation.
	 * 
	 * @param elemRenewing the Renewing element.
	 * Example for setting the Renewing element:<br/><br/>
	 * <code>
	 * String renewing = &quot;&lt;wst:Renewing Allow=\&quot;true\&quot; OK=\&quot;false\&quot;/&gt;&quot;<br/>
	 * IElement renewingElement = new Element();<br/>
	 * renewingElement.set(renewing);<br/>
	 * rst.setRenewing(renewingElement);<br/><br/>
	 * </code>
	 * If attributes are not specified (see snippet example below), then 'Allow' defaults to 'true' and 'OK' to 'false'.<br/>
	 * <code>
	 * &lt;wst:Renewing/&gt;
	 * </code>
	 * 
	 */
	public abstract void setRenewing(IElement elemRenewing);

	/**
	 * Sets the optional OnBehalfOf element that indicates that the requestor is making the request on behalf of another.
	 * 
	 * @param elemOnBehalfOf is the OnBehalfOf element will contain either a <code>&lt;wsse:SecurityTokenReference&gt;</code> 
	 * or an <code>&lt;wsa:EndpointReference&gt;</code> element which will contain the identity on whose behalf the request is being made
	 */
	public abstract void setOnBehalfOf(IElement elemOnBehalfOf);

	/**
	 * Sets the Issuer element EndpointReference of the issuer of the security token that is presented in the message.
	 * 
	 * @param eprIssuer is the EndpointReference that specifies the Issuer
	 */
	public abstract void setIssuer(IEndpointReference eprIssuer);

	/**
	 * Sets the AuthenticationType
	 * 
	 * @param uriAuthenticationType the AuthenticationType
	 */
	public abstract void setAuthenticationType(java.net.URI uriAuthenticationType);

	/**
	 * Sets the optional URI element that indicates the type of key desired in this RequestSecurityToken. 
	 *  
	 * @param uriKeyType is the type of key for this RequestSecurityToken<br/>
	 * Example URIs:<br/>
	 * <code>http://schemas.xmlsoap.org/ws/2005/02/trust/SymmetricKey</code><br/>
	 * <code>http://schemas.xmlsoap.org/ws/2005/02/trust/PublicKey</code>
	 */
	public abstract void setKeyType(java.net.URI uriKeyType);

	/**
	 * Sets the optional KeySize element that indicates the size of the key required specified in number of bits.
	 * The receipient of this request SHOULD at least try to have the same strength as request.
	 * 
	 * @param nKeySize the KeySize
	 */
	public abstract void setKeySize(int nKeySize);

	/**
	 * Sets the optional URI element that indicates the desired SignatureAlgorithm used within the returned token.
	 * 
	 * @param uriSignatureAlgorithm the SignatureAlgorithm
	 */
	public abstract void setSignatureAlgorithm(java.net.URI uriSignatureAlgorithm);

	/**
	 * Sets the optional Encryption element that specifies that the requestor desires any returned secrets in issued 
	 * security tokens to be encrypted for the specified token.
	 * 
	 * @param elemEncryption the Encryption
	 */
	public abstract void setEncryption(IElement elemEncryption);

	/**
	 * Sets the optional EncryptionAlgorithm URI element that indicates the encryption algorithm used within the returned token.
	 * 
	 * @param uriEncryptionAlgorithm the EncryptionAlgorithm
	 */
	public abstract void setEncryptionAlgorithm(java.net.URI uriEncryptionAlgorithm);

	/**
	 * Sets the optional CanonicalizationAlgorithm URI element that indicates the canonicalization method used within the returned token.
	 * 
	 * @param uriCanonicalizationAlgorithm the CanonicalizationAlgorithm
	 */
	public abstract void setCanonicalizationAlgorithm(java.net.URI uriCanonicalizationAlgorithm);

	/**
	 * Sets the optional ProofEncryption element within the request.
	 * 
	 * @param elemProofEncryption the ProofEncryption
	 */
	public abstract void setProofEncryption(IElement elemProofEncryption);

	/**
	 * Sets the UseKey element that specifies which existing key to use, rather than creating a new one.
	 * 
	 * @param elemUseKey the UseKey
	 */
	public abstract void setUseKey(IElement elemUseKey);

	/**
	 * Sets the optional SignWith URI element that indicates the desired signature algorithm to be used with the issued security token.
	 * 
	 * @param uriSignWith the SignWith
	 */
	public abstract void setSignWith(java.net.URI uriSignWith);

	/**
	 * Sets the optional EncryptWith element that specifies the desired encryption algorithm to used with the issued security token.
	 * 
	 * @param uriEncryptWith the EncryptWith
	 */
	public abstract void setEncryptWith(java.net.URI uriEncryptWith);

	/**
	 * Sets the optional DelegateTo element.
	 * 
	 * @param elemDelegateTo is the identity receiving the delegation, which is specified by setting this value to the security token or 
	 * <code>&lt;wsse:SecurityTokenReference&gt; element.
	 */
	public abstract void setDelegateTo(IElement elemDelegateTo);

	/**
	 * Sets the optional Forwardable element.
	 * 
	 * @param bForwardable is the boolean value specifying whether this request is forwardable.
	 */
	public abstract void setForwardable(boolean bForwardable);

	/**
	 * Sets the Delegatable element which should be used in conjunction with the <code>&lt;wst:DelegateTo&gt;</code> element.
	 * 
	 * @param bDelegatable is the boolean value specifying whether this request should be delegated.
	 */
	public abstract void setDelegatable(boolean bDelegatable);

	/**
	 * Sets the optional Policy element that specifies a policy that indicates desired settings for the requested token.
	 * 
	 * @param elemPolicy the Policy
	 */
	public abstract void setPolicy(final IElement elemPolicy);

	/**
	 * Sets the optional PolicyReference element that specifies a reference to a policy that indicates desired settings for the requested token.
	 * 
	 * @param elemPolicyReference the PolicyReference
	 */
	public abstract void setPolicyReference(final IElement elemPolicyReference);

	/**
	 * Sets the optional URI that specifies an identifier/context for this request.
	 * 
	 * @param uriContext the Context URI
	 */
	public abstract void setContext(final String strContext);

	/**
	 * Sets the associated data object (this object is not serialized in the message)
	 * 
	 * @param objectData the data object to be associated (this object is not serialized in the message)
	 */
	public abstract void setData(final java.lang.Object objectData);
}