/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

//package consenthandler;
package org.eclipse.higgins.sts.api;

import java.io.*;

// An interface that allows the STS to communicate with the cell phone
public interface iTrustedDevice {	
	
	// Used for handling the request from the cell phone
	public boolean handleRequest (PrintWriter pw, BufferedReader br);
	
	/* Used to send the request for authorization.
	 message should contain the session specific id the client uses to communicate
	 the id is generated randomly */
	
	public void insertIntoQueue(String userName, String message, String id) ;
	
	// Store the certificate path, claim values, card history, claim type details.
	public void insertAdditionalInfo( String certificatePath, String ClaimValues,
			                          String cardHistory, String claimType, String id);
	
	// a function that waits for the final response from the user
	public boolean getResponseFromUser(String id, String username);

    // Function that creates the first message to the cell phone
	public String createNotification(String rpURL, String rpPolicyChanged,  
			String rpCertPathChange, String rpClaimsChanged, 
			String rpFirstVisit, String rpOptionalClaimsRequested, String id ); // takes the parameters.

	// Function used to  setup the cipher
    public void setupCipher() throws Exception;
    
}



