/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.api;

/**
 * Interface representing the information contained in WS-Addressing header elements
 * 
 * @author mikemci at us dot ibm dot com
 */
public interface IAddressingInformation
{
	// TODO: Attributed URI
	
	/**
	 * Gets the Addressing Namespace URI
	 * 
	 * @return the Addressing Namespace URI
	 */
	public abstract java.net.URI getNamespace();
	
	/**
	 * Gets the Action URI
	 * 
	 * @return the Action URI
	 */
	public abstract java.net.URI getAction();

	/**
	 * Gets the From EPR
	 * 
	 * @return the From EPR
	 */
	public abstract IEndpointReference getFrom();

	/**
	 * Gets the ReplyTo EPR
	 * 
	 * @return the ReplyTo EPR
	 */
	public abstract IEndpointReference getReplyTo();

	/**
	 * Gets the FaultTo EPR
	 * 
	 * @return the FaultTo EPR
	 */
	public abstract IEndpointReference getFaultTo();

	/**
	 * Gets the To URI
	 * 
	 * @return the To URI
	 */
	public abstract java.net.URI getTo();

	/**
	 * Gets the MessageID URI
	 * 
	 * @return the MessageID URI
	 */
	public abstract java.net.URI getMessageID();

	/**
	 * Gets the RelatesTo URI
	 * 
	 * @return the RelatesTo URI
	 */
	public abstract java.net.URI getRelatesTo();
	
	/**
	 * Gets the RelatesTo RelationshipType URI
	 * 
	 * @return the RelatesTo RelationshipType URI
	 */
	public abstract java.net.URI getRelatesToRelationshipType();

	/**
	 * Sets the Addressing namespace
	 * 
	 * @param uriNamespace the Addressing namespace URI
	 */
	public abstract void setNamespace(final java.net.URI uriNamespace);
	
	/**
	 * Sets the Action URI
	 * 
	 * @param uriAction the Action URI
	 */
	public abstract void setAction(final java.net.URI uriAction);

	/**
	 * Sets the From EPR
	 * 
	 * @param eprFrom the From EPR
	 */
	public abstract void setFrom(final IEndpointReference eprFrom);

	/**
	 * Sets the ReplyTo EPR
	 * 
	 * @param eprReplyTo the ReplyTo EPR
	 */
	public abstract void setReplyTo(final IEndpointReference eprReplyTo);

	/**
	 * Gets the FaultTo EPR
	 * 
	 * @param eprFaultTo the FaultTo EPR
	 */
	public abstract void setFaultTo(final IEndpointReference eprFaultTo);

	/**
	 * Sets the To URI
	 * 
	 * @param uriTo the To URI
	 */
	public abstract void setTo(final java.net.URI uriTo);

	/**
	 * Sets the MessageID URI
	 * 
	 * @param uriMessageID the MessageID URI
	 */
	public abstract void setMessageID(final java.net.URI uriMessageID);

	/**
	 * Sets the RelatesTo URI
	 * 
	 * @param uriRelatesTo the RelatesTo URI
	 */
	public abstract void setRelatesTo(final java.net.URI uriRelatesTo);
	
	/**
	 * Sets the RelatesTo RelationshipType URI
	 * 
	 * @param uriRelationshipType the RelatesTo RelationshipType URI
	 */
	public abstract void setRelatesToRelationshipType(final java.net.URI uriRelationshipType);
}
