/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.api;

/**
 * Interface representing contained objects providing conversions between underlying representations
 * 
 * @author mikemci at us dot ibm dot com
 */
public interface IObjectContainer
{
	/**
	 * Gets the Class of the contained object
	 * 
	 * @return the Class of the contained object (null if the contained object is null)
	 */
	public abstract java.lang.Class getObjectClass();
	
	/**
	 * Gets the List of the Classes supported by the underlying implementation
	 * 
	 * @return the List of the Classes supported by the underlying implementation
	 */
	public abstract java.util.List getSupportedClasses();

	/**
	 * Sets the contained object
	 * 
	 * @param object the object to set
	 * @throws UnsupportedContainedObjectClassException when object class is not supported by the underlying implementation
	 */
	public abstract void set
		(final Object object)
		throws Exception;
	
	/**
	 * Gets a clone of the contained object
	 * 
	 * @return a clone of the contained object
	 */
	public abstract Object get();
	// TODO: Clone the result in the implementations.
	
	/**
	 * Gets a clone of the contained object, converted to the Class specified by objectClass
	 * 
	 * @param objectClass the class of the object to be returned
	 * @return a clone of the contained object, converted to the Class specified by objectClass
	 * @throws UnsupportedContainedObjectClassException when the Class specified by objectClass is not supported by the underlying implementation
	 */
	public abstract Object getAs
		(Class objectClass)
		throws Exception;
}
