/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.api;

/**
 * Interface representing the RequestSecurityTokenResponse
 * 
 * @author mikemci at us dot ibm dot com
 */
public interface IRequestSecurityTokenResponse
{
	public abstract IElement getClientPseudonym();
	
	public abstract void setClientPseudonym(final IElement clientPseudonym);
	
	/**
	 * Get the ComputedKey URI element value that describes how to compute the key.
	 * 
	 * @return the ComputedKey URI
	 */
	public abstract java.net.URI getComputedKey();

	/**
	 * Gets the optional Context element URI String that specifies the identifier from the original request.
	 * 
	 * @return the String value of the Context URI
	 */
	public abstract String getContext();
	
	/**
	 * Gets the RequestedTokenCancelled element.
	 * 
	 * @return the RequestedTokenCancelled
	 */
	public abstract IElement getRequestedTokenCancelled();

	/**
	 * Gets the RequestedDisplayToken
	 * 
	 * @return the RequestedDisplayToken
	 */
	public abstract IDisplayToken getRequestedDisplayToken();


	/**
	 * Gets the optional element that describes the type of security token returned, specified as a URI.
	 * 
	 * @return the TokenType
	 */
	public abstract java.net.URI getTokenType();

	/**
	 * Gets the required RequestType element that is used to indicate the type of function that was requested, specified as a URI.  <br/>
	 * The values are defined by the WS-Trust specifications.
	 * 
	 * @return the RequestType
	 */
	public abstract java.net.URI getRequestType();

	/**
	 * Gets the requested RequestedSecurityToken element from the response.
	 * 
	 * @return the RequestedSecurityToken
	 */
	public abstract IElement getRequestedSecurityToken();

	/**
	 * Gets this optional element that specifies the scope for the service(s) to which this token applies.
	 * 
	 * @return the AppliesTo EndpointReference
	 */
	public abstract IEndpointReference getAppliesTo();

	/**
	 * Gets the optional RequestedAttachedReference element from the response.
	 * 
	 * @return the RequestedAttachedReference
	 */
	public abstract IElement getRequestedAttachedReference();

	/**
	 * Gets the optional RequestedUnattachedReference element from the response.
	 * 
	 * @return the RequestedUnattachedReference
	 */
	public abstract IElement getRequestedUnattachedReference();

	/**
	 * Gets the optional RequestedProofToken element that is used to return the proof-of-possession 
	 * token associated with the requested security token.
	 * 
	 * @return the RequestedProofToken
	 */
	public abstract IElement getRequestedProofToken();

	/**
	 * Gets the optional Entropy element that allows a requestor to specify entropy that is to be used in creating the key.
	 * 
	 * @return the Entropy
	 */
	public abstract IElement getEntropy();

	/**
	 * Gets the optional Lifetime element that specifies the duration of time between creation and expiration that the security token is valid.
	 * 
	 * @return the Lifetime
	 */
	public abstract ILifetime getLifetime();

	/**
	 * Gets the Status element that MUST be in the response when a validation request is made.
	 * 
	 * @return the Status
	 */
	public abstract IElement getStatus();

	/**
	 * Gets the AllowPostdating element that indicates that returned tokens should allow requests for postdated tokens.
	 * 
	 * @return the AllowPostdating
	 */
	public abstract IElement getAllowPostdating();

	/**
	 * Gets optional Renewing element that is used to specify renew semantics for types that support this operation.
	 * 
	 * @return the Renewing
	 */
	public abstract IElement getRenewing();

	/**
	 * Gets the optional OnBehalfOf element that indicates that the requestor is making the request on behalf of another.
	 * 
	 * @return the OnBehalfOf
	 */
	public abstract IElement getOnBehalfOf();

	/**
	 * Gets the Issuer element EndpointReference of the issuer of the security token that is presented in the message.
	 * 
	 * @return the Issuer element EndpointReference
	 */
	public abstract IEndpointReference getIssuer();

	/**
	 * Gets the AuthenticationType
	 * 
	 * @return the AuthenticationType
	 */
	public abstract java.net.URI getAuthenticationType();

	/**
	 * Gets the optional Authenticator element that verifies the computed hash.
	 * 
	 * @return the Authenticator
	 */
	public abstract IElement getAuthenticator();

	/**
	 * Gets the optional URI element that indicates the type of key desired in this RequestSecurityToken.
	 * 
	 * @return the KeyType
	 */
	public abstract java.net.URI getKeyType();

	/**
	 * Gets the optional KeySize element that indicates the size of the key required specified in number of bits.
	 * 
	 * @return the KeySize
	 */
	public abstract java.lang.Integer getKeySize();

	/**
	 * Gets optional URI element that indicates the desired SignatureAlgorithm used within the returned token.
	 * 
	 * @return the URI of the SignatureAlgorithm
	 */
	public abstract java.net.URI getSignatureAlgorithm();

	/**
	 * Gets the optional Encryption element that specifies that the requestor desires any returned secrets in issued 
	 * security tokens to be encrypted for the specified token.
	 * 
	 * @return the Encryption
	 */
	public abstract IElement getEncryption();

	/**
	 * Gets the optional EncryptionAlgorithm URI element that indicates the encryption algorithm used within the returned token.
	 * 
	 * @return the EncryptionAlgorithm
	 */
	public abstract java.net.URI getEncryptionAlgorithm();

	/**
	 * Gets the optional CanonicalizationAlgorithm URI element that indicates the canonicalization method used within the returned token.
	 * 
	 * @return the CanonicalizationAlgorithm
	 */
	public abstract java.net.URI getCanonicalizationAlgorithm();

	/**
	 * Gets the optional ProofEncryption element
	 * 
	 * @return the ProofEncryption
	 */
	public abstract IElement getProofEncryption();

	/**
	 * Gets the UseKey element that specifies which existing key to use, rather than creating a new one.
	 * 
	 * @return the UseKey
	 */
	public abstract IElement getUseKey();

	/**
	 * Gets the optional SignWith URI element that indicates the desired signature algorithm to be used with the issued security token.
	 * 
	 * @return the SignWith
	 */
	public abstract java.net.URI getSignWith();

	/**
	 * Gets the optional EncryptWith element that specifies the desired encryption algorithm to used with the issued security token.
	 * 
	 * @return the EncryptWith
	 */
	public abstract java.net.URI getEncryptWith();

	/**
	 * Gets the optional DelegateTo element.
	 * 
	 * @return the DelegateTo
	 */
	public abstract IElement getDelegateTo();

	/**
	 * Gets the Forwardable element
	 * 
	 * @return Boolean value representing whether the request is bound to the requestor's machine or service
	 */
	public abstract java.lang.Boolean getForwardable();

	/**
	 * Gets the Delegatable element which should be used in conjunction with the <code>&lt;wst:DelegateTo&gt;</code> element.
	 * 
	 * @return Boolean value representing whether the returned token MAY be delegated to another party
	 */
	public abstract java.lang.Boolean getDelegatable();

	/**
	 * Gets the optional Policy element that specifies a policy that indicates desired settings for the requested token.
	 * 
	 * @return the Policy
	 */
	public abstract IElement getPolicy();

	/**
	 * Gets the optional PolicyReference element that specifies a reference to a policy that indicates desired settings for the requested token.
	 * 
	 * @return the PolicyReference
	 */
	public abstract IElement getPolicyReference();

	/**
	 * Gets any other elements (other than those explicitly named)
	 * 
	 * @return any other elements (other than those explicitly named)
	 */
	public abstract java.util.List getAnyOtherElements();

	/**
	 * Gets the associated data object (this object is not serialized in the message)
	 * 
	 * @return the associated data object (this object is not serialized in the message)
	 */
	public abstract java.lang.Object getData();

	public abstract void setComputedKey(final java.net.URI uriComputedKey);

	/**
	 * Sets the RequestedTokenCancelled element.
	 * 
	 * @param elemRequestedTokenCancelled the RequestedTokenCancelled
	 */
	public abstract void setRequestedTokenCancelled(final IElement elemRequestedTokenCancelled);

	/**
	 * Sets the RequestedDisplayToken
	 * 
	 * @param elemRequestedDisplayToken the RequestedDisplayToken
	 */
	public abstract void setRequestedDisplayToken(final IDisplayToken elemRequestedDisplayToken);

	/**
	 * Sets the optional element that describes the type of security token returned, specified as a URI.
	 * 
	 * @param uriTokenType is the URI of the TokenType<br/>
	 * An example of a SAML 1.0 TokenType URI:<br/>
	 * <code>urn:oasis:names:tc:SAML:1.0:assertion</code>
	 */
	public abstract void setTokenType(final java.net.URI uriTokenType);

	/**
	 * Sets the required RequestType element that is used to indicate the type of function that was requested, specified as a URI.  <br/>
	 * The values are defined by the WS-Trust specifications.<br/>
	 * An example of an 'Issue' RequestType URI, defined by the 2005-02 WS-Trust specification:<br/>
	 * <code>new URI("http://schemas.xmlsoap.org/ws/2005/02/trust/Issue")</code>
	 * 
	 * @param uriRequestType the RequestType
	 */
	public abstract void setRequestType(final java.net.URI uriRequestType);

	/**
	 * Sets the requested RequestedSecurityToken element within the response.
	 * 
	 * @param elemRequestedSecurityToken the RequestedSecurityToken
	 */
	public abstract void setRequestedSecurityToken(final IElement elemRequestedSecurityToken);

	/**
	 * Sets this optional element that specifies the scope for the service(s) to which this token applies.
	 * 
	 * @param eprAppliesTo is the AppliesTo EndpointReference
	 */
	public abstract void setAppliesTo(final IEndpointReference eprAppliesTo);

	/**
	 * Sets the optional RequestedAttachedReference element in the response.
	 * 
	 * @param elemRequestedAttachedReference the RequestedAttachedReference
	 */
	public abstract void setRequestedAttachedReference(final IElement elemRequestedAttachedReference);

	/**
	 * Sets the optional RequestedUnattachedReference element in the response.
	 * 
	 * @param elemRequestedUnattachedReference the RequestedUnattachedReference
	 */
	public abstract void setRequestedUnattachedReference(final IElement elemRequestedUnattachedReference);

	/**
	 * Sets the optional RequestedProofToken element that is used to return the proof-of-possession 
	 * token associated with the requested security token.
	 * 
	 * @param elemRequestedProofToken the RequestedProofToken
	 */
	public abstract void setRequestedProofToken(final IElement elemRequestedProofToken);

	/**
	 * Sets the optional Entropy element that allows a requestor to specify entropy that is to be used in creating the key.
	 * 
	 * @param elemEntropy the Entropy
	 */
	public abstract void setEntropy(final IElement elemEntropy);

	/**
	 * Sets the optional Lifetime element that specifies the duration of time between creation and expiration that the security token is valid.
	 * 
	 * @param ltLifetime the Lifetime
	 */
	public abstract void setLifetime(final ILifetime ltLifetime);

	/**
	 * Sets the Status element that MUST be in the response when a validation request is made.
	 * 
	 * @param elemStatus is the Status URI.<br/>
	 * Examples of status URIs:<br/>
	 * <code>http://schemas.xmlsoap.org/ws/2005/02/trust/status/valid</code><br/>
	 * <code>http://schemas.xmlsoap.org/ws/2005/02/trust/status/invalid</code><br/>
	 */
	public abstract void setStatus(final IElement elemStatus);

	/**
	 * Sets the AllowPostdating element that indicates that returned tokens should allow requests for postdated tokens.
	 * 
	 * @param elemAllowPostdating the AllowPostdating
	 */
	public abstract void setAllowPostdating(final IElement elemAllowPostdating);

	/**
	 * Sets optional Renewing element that is used to specify renew semantics for types that support this operation.
	 * 
	 * @param elemRenewing the Renewing element.
	 * Example for setting the Renewing element:<br/><br/>
	 * <code>
	 * String renewing = &quot;&lt;wst:Renewing Allow=\&quot;true\&quot; OK=\&quot;false\&quot;/&gt;&quot;<br/>
	 * IElement renewingElement = new Element();<br/>
	 * renewingElement.set(renewing);<br/>
	 * rst.setRenewing(renewingElement);<br/><br/>
	 * </code>
	 * If attributes are not specified (see snippet example below), then 'Allow' defaults to 'true' and 'OK' to 'false'.<br/>
	 * <code>
	 * &lt;wst:Renewing/&gt;
	 * </code>
	 * 
	 */
	public abstract void setRenewing(final IElement elemRenewing);

	/**
	 * Sets the optional OnBehalfOf element that indicates that the requestor is making the request on behalf of another.
	 * 
	 * @param elemOnBehalfOf is the OnBehalfOf element will contain either a <code>&lt;wsse:SecurityTokenReference&gt;</code> 
	 * or an <code>&lt;wsa:EndpointReference&gt;</code> element which will contain the identity on whose behalf the request is being made
	 */
	public abstract void setOnBehalfOf(final IElement elemOnBehalfOf);

	/**
	 * Sets the Issuer element EndpointReference of the issuer of the security token that is presented in the message.
	 * 
	 * @param eprIssuer is the EndpointReference that specifies the Issuer
	 */
	public abstract void setIssuer(final IEndpointReference eprIssuer);

	/**
	 * Sets the AuthenticationType
	 * 
	 * @param uriAuthenticationType the AuthenticationType
	 */
	public abstract void setAuthenticationType(final java.net.URI uriAuthenticationType);

	/**
	 * Sets the optional Authenticator element that verifies the computed hash.
	 * 
	 * @param elemAuthenticator the Authenticator
	 */
	public abstract void setAuthenticator(final IElement elemAuthenticator);

	/**
	 * Sets the optional URI element that indicates the type of key desired in this RequestSecurityToken. 
	 *  
	 * @param uriKeyType is the type of key for this RequestSecurityToken<br/>
	 * Example URIs:<br/>
	 * <code>http://schemas.xmlsoap.org/ws/2005/02/trust/SymmetricKey</code><br/>
	 * <code>http://schemas.xmlsoap.org/ws/2005/02/trust/PublicKey</code>
	 */
	public abstract void setKeyType(final java.net.URI uriKeyType);

	/**
	 * Sets the optional KeySize element that indicates the size of the key required specified in number of bits.
	 * The receipient of this request SHOULD at least try to have the same strength as request.
	 * 
	 * @param nKeySize the KeySize
	 */
	public abstract void setKeySize(final int nKeySize);

	/**
	 * Sets the optional URI element that indicates the desired SignatureAlgorithm used within the returned token.
	 * 
	 * @param uriSignatureAlgorithm the SignatureAlgorithm
	 */
	public abstract void setSignatureAlgorithm(final java.net.URI uriSignatureAlgorithm);

	/**
	 * Sets the optional Encryption element that specifies that the requestor desires any returned secrets in issued 
	 * security tokens to be encrypted for the specified token.
	 * 
	 * @param elemEncryption the Encryption
	 */
	public abstract void setEncryption(final IElement elemEncryption);

	/**
	 * Sets the EncryptionAlgorithm
	 * 
	 * @param uriEncryptionAlgorithm the EncryptionAlgorithm
	 */
	public abstract void setEncryptionAlgorithm(final java.net.URI uriEncryptionAlgorithm);

	/**
	 * Sets the optional CanonicalizationAlgorithm URI element that indicates the canonicalization method used within the returned token.
	 * 
	 * @param uriCanonicalizationAlgorithm the CanonicalizationAlgorithm
	 */
	public abstract void setCanonicalizationAlgorithm(final java.net.URI uriCanonicalizationAlgorithm);

	/**
	 * Sets the optional ProofEncryption element.
	 * 
	 * @param elemProofEncryption the ProofEncryption
	 */
	public abstract void setProofEncryption(final IElement elemProofEncryption);

	/**
	 * Sets the UseKey element that specifies which existing key to use, rather than creating a new one.
	 * 
	 * @param elemUseKey the UseKey
	 */
	public abstract void setUseKey(final IElement elemUseKey);

	/**
	 * Sets the optional SignWith URI element that indicates the desired signature algorithm to be used with the issued security token.
	 * 
	 * @param uriSignWith the SignWith
	 */
	public abstract void setSignWith(final java.net.URI uriSignWith);

	/**
	 * Sets the optional EncryptWith element that specifies the desired encryption algorithm to used with the issued security token.
	 * 
	 * @param uriEncryptWith the EncryptWith
	 */
	public abstract void setEncryptWith(final java.net.URI uriEncryptWith);

	/**
	 * Sets the optional DelegateTo element.
	 * 
	 * @param elemDelegateTo is the identity receiving the delegation, which is specified by setting this value to the security token or 
	 * <code>&lt;wsse:SecurityTokenReference&gt; element.
	 */
	public abstract void setDelegateTo(final IElement elemDelegateTo);

	/**
	 * Sets the optional Forwardable element.
	 * 
	 * @param bForwardable is the boolean value specifying whether this request is forwardable.
	 */
	public abstract void setForwardable(final boolean bForwardable);

	/**
	 * Sets the Delegatable element which should be used in conjunction with the <code>&lt;wst:DelegateTo&gt;</code> element.
	 * 
	 * @param bDelegatable is the boolean value specifying whether returned token MAY be delegated to another party.
	 */
	public abstract void setDelegatable(final boolean bDelegatable);

	/**
	 * Sets the optional Policy element that specifies a policy that indicates desired settings for the requested token.
	 * 
	 * @param elemPolicy the Policy
	 */
	public abstract void setPolicy(final IElement elemPolicy);

	/**
	 * Sets the optional PolicyReference element that specifies a reference to a policy that indicates desired settings for the requested token.
	 * 
	 * @param elemPolicyReference the PolicyReference
	 */
	public abstract void setPolicyReference(final IElement elemPolicyReference);

	/**
	 * Sets the optional Context element URI String that specifies the identifier from the original request.
	 * 
	 * @param uriContext the String value of the Context URI
	 */
	public abstract void setContext(final String uriContext);

	/**
	 * Sets the associated data object (this object is not serialized in the message)
	 * 
	 * @param objectData the data object to be associated (this object is not serialized in the message)
	 */
	public abstract void setData(final java.lang.Object objectData);

}