/*******************************************************************************
 * Copyright (c) 2006-2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.api;

/**
 * @author mikemci
 *
 */
public interface ISAMLToken extends ISecurityToken
{

    public abstract IElement getConditions() throws Exception;
    
    public abstract void setConditions(IElement elemConditions) throws Exception;

    public abstract IElement getAdvice() throws Exception;
    
    public abstract void setAdvice(IElement elemAdvice) throws Exception;

    public abstract IElement getStatement() throws Exception;
    
    public abstract void setStatement(IElement elemStatement) throws Exception;
    
    public abstract IElement getSubjectStatement() throws Exception;
    
    public abstract void setSubjectStatement(IElement elemSubjectStatement) throws Exception;
    
    public abstract IElement getAuthenticationStatement() throws Exception;
    
    public abstract void setAuthenticationStatement(IElement elemAuthenticationStatement) throws Exception;

    public abstract IElement getAuthorizationDecisionStatement() throws Exception;
    
    public abstract void setAuthorizationDecisionStatement(IElement elemAuthorizationDecisionStatement) throws Exception;

    public abstract IElement getAttributeStatement() throws Exception;
    
    public abstract void setAttributeStatement(IElement elemAttributeStatement) throws Exception;

    public abstract IElement getSignature() throws Exception;
    
    public abstract void setSignature(IElement elemSignature) throws Exception; 

    public abstract String getIssuer() throws Exception;
    
    public abstract void setIssuer(String strIssuer) throws Exception;
    
    public abstract java.util.Date getIssueInstant() throws Exception;
    
    public abstract void setIssueInstant(java.util.Date dtIssueInstant) throws Exception;
}
